/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj;

import com.ibm.jutil.tasks.FifoScheduler;
import com.ibm.jutil.tasks.Task;
import com.ibm.jutil.tasks.TaskScheduler;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import com.ibm.posj.Handle;
import com.ibm.posj.event.DataEvent;
import com.ibm.posj.event.DirectIOEvent;
import com.ibm.posj.event.ErrorEvent;
import com.ibm.posj.event.HandleEvent;
import com.ibm.posj.event.OfflineEvent;
import com.ibm.posj.event.OnlineEvent;
import com.ibm.posj.event.OutputCompleteEvent;
import com.ibm.posj.event.StatusEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class DefaultHandleEventHelper
implements Handle.EventHelper {
    private List listeners = new ArrayList();
    private Handle handle = null;
    private TaskScheduler taskScheduler = null;
    private static Tracer tracer = TracerFactory.getInstance().createTracer("POSJ", "DefaultHandleEventHelper");

    public DefaultHandleEventHelper(Handle handle) {
        this(handle, (TaskScheduler)new FifoScheduler());
    }

    public DefaultHandleEventHelper(Handle handle, TaskScheduler taskScheduler) {
        this.handle = handle;
        this.taskScheduler = taskScheduler;
    }

    public Handle getHandle() {
        return this.handle;
    }

    public void fireOutputCompleteEvent(OutputCompleteEvent event) {
        this.taskScheduler.post((Task)new OutputCompleteEventTask(event));
    }

    public void fireDataEvent(DataEvent event) {
        this.taskScheduler.post((Task)new DataEventTask(event));
    }

    public void fireDirectIOEvent(DirectIOEvent event) {
        this.taskScheduler.post((Task)new DirectIOEventTask(event));
    }

    public void fireErrorEvent(ErrorEvent event) {
        this.taskScheduler.post((Task)new ErrorEventTask(event));
    }

    public void fireStatusEvent(StatusEvent event) {
        this.taskScheduler.post((Task)new StatusEventTask(event));
    }

    public void fireOnlineEvent(OnlineEvent event) {
        this.taskScheduler.post((Task)new OnlineEventTask(event));
    }

    public void fireOfflineEvent(OfflineEvent event) {
        this.taskScheduler.post((Task)new OfflineEventTask(event));
    }

    public synchronized void addHandleListener(Handle.Listener listener) {
        if (null != listener && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeHandleListener(Handle.Listener listener) {
        if (null != listener) {
            this.listeners.remove(listener);
        }
    }

    public synchronized int getListenerCount() {
        return this.listeners.size();
    }

    protected class OfflineEventTask
    extends AbstractEventTask {
        public OfflineEventTask(OfflineEvent event) {
            super(event);
        }

        protected void fireEvent(HandleEvent event, Handle.Listener listener) {
            listener.offlineEventOccurred((OfflineEvent)event);
        }
    }

    protected class OnlineEventTask
    extends AbstractEventTask {
        public OnlineEventTask(OnlineEvent event) {
            super(event);
        }

        protected void fireEvent(HandleEvent event, Handle.Listener listener) {
            listener.onlineEventOccurred((OnlineEvent)event);
        }
    }

    protected class StatusEventTask
    extends AbstractEventTask {
        public StatusEventTask(StatusEvent event) {
            super(event);
        }

        protected void fireEvent(HandleEvent event, Handle.Listener listener) {
            listener.statusEventOccurred((StatusEvent)event);
        }
    }

    protected class ErrorEventTask
    extends AbstractEventTask {
        public ErrorEventTask(ErrorEvent event) {
            super(event);
        }

        protected void fireEvent(HandleEvent event, Handle.Listener listener) {
            listener.errorEventOccurred((ErrorEvent)event);
        }
    }

    protected class DirectIOEventTask
    extends AbstractEventTask {
        public DirectIOEventTask(DirectIOEvent event) {
            super(event);
        }

        protected void fireEvent(HandleEvent event, Handle.Listener listener) {
            listener.directIOEventOccurred((DirectIOEvent)event);
        }
    }

    protected class DataEventTask
    extends AbstractEventTask {
        public DataEventTask(DataEvent event) {
            super(event);
        }

        protected void fireEvent(HandleEvent event, Handle.Listener listener) {
            listener.dataEventOccurred((DataEvent)event);
        }
    }

    protected class OutputCompleteEventTask
    extends AbstractEventTask {
        public OutputCompleteEventTask(OutputCompleteEvent event) {
            super(event);
        }

        protected void fireEvent(HandleEvent event, Handle.Listener listener) {
            listener.outputCompleteEventOccurred((OutputCompleteEvent)event);
        }
    }

    protected abstract class AbstractEventTask
    implements Task {
        private HandleEvent handleEvent = null;

        public AbstractEventTask(HandleEvent event) {
            this.handleEvent = event;
        }

        protected abstract void fireEvent(HandleEvent var1, Handle.Listener var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            ArrayList listenersCopy = null;
            List list = DefaultHandleEventHelper.this.listeners;
            synchronized (list) {
                listenersCopy = new ArrayList(DefaultHandleEventHelper.this.listeners);
            }
            Iterator iterator = listenersCopy.iterator();
            while (iterator.hasNext()) {
                Handle.Listener listener = (Handle.Listener)iterator.next();
                try {
                    this.fireEvent(this.handleEvent, listener);
                }
                catch (Exception t) {
                    if (!tracer.isOn()) continue;
                    tracer.print(t);
                }
            }
        }

        public Exception getException() {
            return null;
        }

        public boolean isExecuted() {
            return false;
        }

        public boolean isInException() {
            return false;
        }

        public String getName() {
            return "";
        }
    }
}

