/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.bus.hid;

import com.ibm.posj.bus.hid.HidKeylockStrategy;
import com.ibm.posj.util.KeylockUtil;

public abstract class DefaultHidKeylockStrategy
implements HidKeylockStrategy {
    public int getKeylockStatusByteIndex() {
        return -1;
    }

    public int getErrorStatusByteIndex() {
        return -1;
    }

    static class LegacyModeKbdKeylockStrategy
    extends DefaultHidKeylockStrategy
    implements HidKeylockStrategy.LegacyModeKbdKeylockStrategy {
        LegacyModeKbdKeylockStrategy() {
        }

        public int getKeylockStatusByteIndex() {
            return 2;
        }

        public int getErrorStatusByteIndex() {
            return 1;
        }

        public int getDevInfoPosition() {
            return 1;
        }

        public int getDeviceId(byte[] response) {
            return KeylockUtil.getUsbLegacyKeylockID(response);
        }
    }

    static class BootModeKbdKeylockStrategy
    extends AbstractAdministrativeHidKeylockStrategy
    implements HidKeylockStrategy.BootModeKbdKeylockStrategy {
        BootModeKbdKeylockStrategy() {
        }

        public int getDeviceId(byte[] response) {
            return KeylockUtil.getUsbBootKeylockID(response);
        }
    }

    static class NonBootModeKbdKeylockStrategy
    extends AbstractAdministrativeHidKeylockStrategy
    implements HidKeylockStrategy.BootModeKbdKeylockStrategy {
        NonBootModeKbdKeylockStrategy() {
        }

        public int getDeviceId(byte[] response) {
            return KeylockUtil.getUsbNonBootKeylockID(response);
        }
    }

    public static class Factory
    implements HidKeylockStrategy.Factory {
        public HidKeylockStrategy createNonBootModeKbdKeylockStrategy() {
            return new NonBootModeKbdKeylockStrategy();
        }

        public HidKeylockStrategy createBootModeKbdKeylockStrategy() {
            return new BootModeKbdKeylockStrategy();
        }

        public HidKeylockStrategy createLegacyModeKbdKeylockStrategy() {
            return new LegacyModeKbdKeylockStrategy();
        }
    }

    static abstract class AbstractAdministrativeHidKeylockStrategy
    extends DefaultHidKeylockStrategy {
        int ADMIN_STATUS_BYTE = 1;
        int ADMIN_REJECTED_BYTE = 0;
        int ADMIN_DEV_INFO_POSITION_BYTE = 0;

        AbstractAdministrativeHidKeylockStrategy() {
        }

        public int getKeylockStatusByteIndex() {
            return this.ADMIN_STATUS_BYTE;
        }

        public int getErrorStatusByteIndex() {
            return this.ADMIN_REJECTED_BYTE;
        }

        public int getDevInfoPosition() {
            return this.ADMIN_DEV_INFO_POSITION_BYTE;
        }

        public abstract int getDeviceId(byte[] var1);
    }
}

