/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.bus.hid.javaxusb;

import com.ibm.hid.DisconnectEvent;
import com.ibm.hid.HidAsync;
import com.ibm.hid.HidDevice;
import com.ibm.hid.HidException;
import com.ibm.hid.HidExceptionEvent;
import com.ibm.hid.HidListener;
import com.ibm.hid.ReportEvent;
import com.ibm.hid.util.HidUtil;
import com.ibm.jutil.RunnableManager;
import com.ibm.jutil.Util;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import com.ibm.posj.bus.hid.javaxusb.DefaultUsbInterfacePolicy;
import com.ibm.posj.event.EventListenerImp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.usb.UsbClaimException;
import javax.usb.UsbControlIrp;
import javax.usb.UsbDevice;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbInterface;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbNotOpenException;
import javax.usb.UsbPipe;
import javax.usb.UsbStallException;
import javax.usb.event.UsbDeviceDataEvent;
import javax.usb.event.UsbDeviceErrorEvent;
import javax.usb.event.UsbDeviceEvent;
import javax.usb.event.UsbDeviceListener;
import javax.usb.event.UsbPipeDataEvent;
import javax.usb.event.UsbPipeErrorEvent;
import javax.usb.event.UsbPipeListener;
import javax.usb.util.StandardRequest;

public class HidDeviceUsbAdapter
implements HidDevice {
    protected boolean connected = false;
    private RunnableManager asyncManager = new RunnableManager();
    protected UsbDevice usbDevice = null;
    protected UsbInterface usbInterface = null;
    protected List usbEndpoints = new Vector();
    protected UsbEndpoint outEndpoint = null;
    protected short idVendor = 0;
    protected short idProduct = 0;
    protected String idVendorString = null;
    protected String idProductString = null;
    protected String idString = null;
    protected byte bInterfaceNumber = 0;
    protected String bInterfaceNumberString = null;
    private UsbDeviceListener disconnectListener = new UsbDeviceDisconnectListener();
    private UsbPipeErrorListener outListener = new UsbPipeErrorListener();
    private ReportListener inListener = new ReportListener();
    private HidListenerHelper hlHelper = new HidListenerHelper();
    private AsyncVisitor asyncVisitor = new AsyncVisitor();
    private HidDevice synchronizedHidDevice = null;
    protected Tracer tracer;
    private static int instanceNumber = 1;
    private int usbStallExceptionRetry = 0;
    public static final int INT_BUFFERING = 1;
    public static final short DESCRIPTOR_MAX_LENGTH = 255;
    public static final short REPORT_INITIAL_LENGTH = 511;
    public static final short REPORT_INCREMENT_LENGTH = 255;
    public static final int MAX_ERROR_EVENTS = 10;
    protected static int MAX_RETRIES = 3;

    public HidDeviceUsbAdapter(UsbInterface uI) {
        this.init(uI);
    }

    public synchronized void connect() throws HidException {
        if (this.connected) {
            return;
        }
        if (this.tracer.isOn()) {
            this.tracer.println("Connecting HidDevice (hashCode " + this.hashCode() + ") to UsbDevice " + this.idString + " (hashCode " + this.usbDevice.hashCode() + ") UsbInterface " + this.bInterfaceNumberString);
        }
        try {
            this.usbInterface.claim(DefaultUsbInterfacePolicy.getInstance());
        }
        catch (UsbClaimException ucE) {
            String errMsg = "UsbInterface is already claimed : " + ucE.getMessage();
            if (this.tracer.isOn()) {
                this.tracer.println(errMsg);
            }
            throw new HidException(errMsg, (Exception)((Object)ucE));
        }
        catch (UsbException uE) {
            String errMsg = "Got UsbException while claiming : " + uE.getMessage();
            if (this.tracer.isOn()) {
                this.tracer.println(errMsg);
                this.tracer.print((Exception)((Object)uE));
            }
            throw new HidException(errMsg, (Exception)((Object)uE));
        }
        catch (UsbDisconnectedException udE) {
            String errMsg = "UsbDevice has been disconnected : " + udE.getMessage();
            if (this.tracer.isOn()) {
                this.tracer.println(errMsg);
            }
            throw new HidException(errMsg, (Exception)((Object)udE));
        }
        catch (UsbNotActiveException unaE) {
            String errMsg = "This UsbInterface is not active : " + unaE.getMessage();
            if (this.tracer.isOn()) {
                this.tracer.println(errMsg);
                this.tracer.print((Exception)((Object)unaE));
            }
            throw new HidException(errMsg, (Exception)((Object)unaE));
        }
        this.usbDevice.addUsbDeviceListener(this.disconnectListener);
        Iterator iterator = this.usbInterface.getUsbEndpoints().iterator();
        while (iterator.hasNext()) {
            UsbEndpoint ep = (UsbEndpoint)iterator.next();
            if (3 != ep.getType()) continue;
            if (-128 == ep.getDirection()) {
                this.addUsbEndpointIn(ep);
                continue;
            }
            if (0 != ep.getDirection()) continue;
            this.addUsbEndpointOut(ep);
        }
        if (this.tracer.isOn()) {
            this.tracer.println("Connected HidDevice (hashCode " + this.hashCode() + ") to UsbDevice " + this.idString + " (hashCode " + this.usbDevice.hashCode() + " ) successfully.");
        }
        this.connected = true;
    }

    public void disconnect() {
        this.disconnect(null);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public byte[] getDescriptor(byte descriptorType, byte descriptorIndex) throws HidException {
        return this.getDescriptor(descriptorType, descriptorIndex, true);
    }

    public byte[] getDescriptor(byte descriptorType, byte descriptorIndex, boolean sync) throws HidException {
        this.checkForConnection();
        if (this.tracer.isOn()) {
            this.tracer.println(3, "-->getDescriptor( " + Util.toHexString((byte)descriptorType) + ", " + Util.toHexString((byte)descriptorIndex) + ", " + sync + ")");
        }
        byte[] data = new byte[255];
        int length = this.submitRequest((byte)-127, (byte)6, (short)(descriptorType << 8 | descriptorIndex), data, sync);
        byte[] descriptor = new byte[length];
        System.arraycopy(data, 0, descriptor, 0, descriptor.length);
        if (this.tracer.isOn()) {
            this.tracer.println(3, "<--getDescriptor() = " + Util.toFormatedHexString((byte[])descriptor));
        }
        return descriptor;
    }

    public void setDescriptor(byte descriptorType, byte descriptorIndex, short descriptorLength, byte[] descriptor) throws HidException {
        this.setDescriptor(descriptorType, descriptorIndex, descriptorLength, descriptor, true);
    }

    public void setDescriptor(byte descriptorType, byte descriptorIndex, short descriptorLength, byte[] descriptor, boolean sync) throws HidException {
        this.checkForConnection();
        byte[] data = new byte[Util.unsignedInt((short)descriptorLength)];
        System.arraycopy(descriptor, 0, data, 0, Util.unsignedInt((short)descriptorLength));
        this.submitRequest((byte)1, (byte)7, (short)(descriptorType << 8 | descriptorIndex), data, sync);
    }

    public byte[] getReport(byte reportType, byte reportID) throws HidException {
        return this.getReport(reportType, reportID, true);
    }

    public byte[] getReport(byte reportType, byte reportID, boolean sync) throws HidException {
        this.checkForConnection();
        if (this.tracer.isOn()) {
            this.tracer.println(3, "-->getReport( " + Util.toHexString((byte)reportType) + ", " + Util.toHexString((byte)reportID) + ", " + sync + ")");
        }
        int attemptLen = 256;
        int length = 0;
        byte[] data = null;
        do {
            if ((attemptLen += 255) <= 65535) continue;
            attemptLen = 65535;
        } while ((length = this.submitRequest((byte)-95, (byte)1, (short)(reportType << 8 | reportID), data = new byte[attemptLen], sync)) == attemptLen && attemptLen < 65535);
        byte[] report = new byte[length];
        System.arraycopy(data, 0, report, 0, report.length);
        if (this.tracer.isOn()) {
            this.tracer.println(3, "<--getReport() = " + Util.toFormatedHexString((byte[])report));
        }
        return report;
    }

    public void setReport(byte reportType, byte reportID, short reportLength, byte[] report) throws HidException {
        this.setReport(reportType, reportID, reportLength, report, true);
    }

    public void setReport(byte reportType, byte reportID, short reportLength, byte[] report, boolean sync) throws HidException {
        this.checkForConnection();
        byte[] data = new byte[Util.unsignedInt((short)reportLength)];
        System.arraycopy(report, 0, data, 0, Util.unsignedInt((short)reportLength));
        this.submitRequest((byte)33, (byte)9, (short)(reportType << 8 | reportID), data, sync);
    }

    public byte getIdle(byte reportID) throws HidException {
        return this.getIdle(reportID, true);
    }

    public byte getIdle(byte reportID, boolean sync) throws HidException {
        this.checkForConnection();
        byte[] data = new byte[1];
        int length = this.submitRequest((byte)-95, (byte)2, reportID, data, sync);
        if (1 > length) {
            String errMsg = "UsbDevice did not return any data for getIdle request (length = " + length + ")";
            this.tracer.println(errMsg);
            throw new HidException(errMsg);
        }
        return data[0];
    }

    public void setIdle(byte reportID, byte duration) throws HidException {
        this.setIdle(reportID, duration, true);
    }

    public void setIdle(byte reportID, byte duration, boolean sync) throws HidException {
        this.checkForConnection();
        byte[] data = new byte[]{};
        this.submitRequest((byte)33, (byte)10, (short)(duration << 8 | reportID), data, sync);
    }

    public byte getProtocol() throws HidException {
        return this.getProtocol(true);
    }

    public byte getProtocol(boolean sync) throws HidException {
        this.checkForConnection();
        byte[] data = new byte[1];
        int length = this.submitRequest((byte)-95, (byte)3, (short)0, data, sync);
        if (1 > length) {
            String errMsg = "UsbDevice did not return any data for getProtocol request (length = " + length + ")";
            this.tracer.println(errMsg);
            throw new HidException(errMsg);
        }
        return data[0];
    }

    public void setProtocol(byte protocol) throws HidException, IllegalArgumentException {
        this.setProtocol(protocol, true);
    }

    public void setProtocol(byte protocol, boolean sync) throws HidException, IllegalArgumentException {
        this.checkForConnection();
        if (0 != protocol && 1 != protocol) {
            throw new IllegalArgumentException("Protocol must be 0 (boot mode) or 1 (non-boot mode)");
        }
        byte[] data = new byte[]{};
        this.submitRequest((byte)33, (byte)11, protocol, data, sync);
    }

    public void async(final HidAsync hidAsync) {
        Runnable asyncRunner = new Runnable(){

            public void run() {
                hidAsync.accept(HidDeviceUsbAdapter.this.asyncVisitor);
            }
        };
        this.asyncManager.add(asyncRunner);
    }

    public void addHidListener(HidListener listener) {
        this.hlHelper.addHidListener(listener);
    }

    public void removeHidListener(HidListener listener) {
        this.hlHelper.removeHidListener(listener);
    }

    public synchronized HidDevice getSynchronizedHidDevice() {
        if (null == this.synchronizedHidDevice) {
            this.synchronizedHidDevice = HidUtil.getSynchronizedHidDevice(this);
        }
        return this.synchronizedHidDevice;
    }

    public synchronized HidDevice getUnsynchronizedHidDevice() {
        return this;
    }

    protected void init(UsbInterface uI) {
        this.usbInterface = uI;
        this.usbDevice = this.usbInterface.getUsbConfiguration().getUsbDevice();
        this.idVendor = this.usbDevice.getUsbDeviceDescriptor().idVendor();
        this.idProduct = this.usbDevice.getUsbDeviceDescriptor().idProduct();
        this.idVendorString = "0x" + Util.toHexString((short)this.idVendor);
        this.idProductString = "0x" + Util.toHexString((short)this.idProduct);
        this.idString = "<" + this.idVendorString + "," + this.idProductString + ">";
        this.bInterfaceNumber = this.usbInterface.getUsbInterfaceDescriptor().bInterfaceNumber();
        this.bInterfaceNumberString = Integer.toString(Util.unsignedInt((byte)this.bInterfaceNumber));
        this.tracer = TracerFactory.getInstance().createTracer("HID" + instanceNumber++, "HidDeviceUsbAdapter" + this.idString);
    }

    protected int submitRequest(byte bmRequestType, byte bRequest, short wValue, byte[] data, boolean sync) throws HidException {
        String errMsg;
        short wIndex = (short)(0xFF & this.bInterfaceNumber);
        if (3 == this.tracer.getTraceLevel()) {
            String traceMsg = sync ? "sync" : "async";
            traceMsg = traceMsg + " submitRequest(";
            traceMsg = traceMsg + "0x" + Util.toHexString((byte)bmRequestType) + ",";
            traceMsg = traceMsg + "0x" + Util.toHexString((byte)bRequest) + ",";
            traceMsg = traceMsg + "0x" + Util.toHexString((short)wValue) + ",";
            traceMsg = traceMsg + "0x" + Util.toHexString((short)wIndex) + ",";
            traceMsg = traceMsg + Integer.toString(data.length) + ",";
            traceMsg = traceMsg + Util.toFormatedHexString((byte[])data) + ")";
            if (-127 == bmRequestType) {
                traceMsg = "HID_GET_DESCRIPTOR : " + traceMsg;
            }
            if (-95 == bmRequestType) {
                traceMsg = "HID_GET_REPORT : " + traceMsg;
            }
            this.tracer.println(traceMsg);
        }
        UsbControlIrp usbControlIrp = this.usbDevice.createUsbControlIrp(bmRequestType, bRequest, wValue, wIndex);
        usbControlIrp.setData(data);
        try {
            if (sync) {
                this.usbDevice.syncSubmit(usbControlIrp);
            } else {
                this.usbDevice.asyncSubmit(usbControlIrp);
            }
        }
        catch (UsbException uE) {
            String errMsg2 = "Could not submit UsbControlIrp (UsbException) : " + uE.getMessage();
            this.tracer.println(errMsg2);
            this.tracer.print((Exception)((Object)uE));
            throw new HidException(errMsg2);
        }
        catch (IllegalArgumentException iaE) {
            String errMsg3 = "Could not submit illegal UsbControlIrp : " + iaE.getMessage();
            this.tracer.println(errMsg3);
            this.tracer.print((Exception)iaE);
            throw new HidException(errMsg3);
        }
        catch (UsbDisconnectedException udE) {
            errMsg = "UsbDevice has been disconnected.";
            this.tracer.println(errMsg);
            this.disconnectAndThrow(new HidException(errMsg));
        }
        if (!sync) {
            usbControlIrp.waitUntilComplete();
        }
        if (usbControlIrp.isUsbException()) {
            uE = usbControlIrp.getUsbException();
            errMsg = "UsbControlIrp submission resulted in UsbException : " + uE.getMessage();
            this.tracer.println(errMsg);
            this.tracer.print((Exception)((Object)uE));
            throw new HidException(errMsg);
        }
        int result = usbControlIrp.getActualLength();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void disconnect(HidException hidException) {
        this.connected = false;
        this.tracer.println("Disconnecting HidDevice (hashCode " + this.hashCode() + ") from UsbDevice " + this.idString + " (hashCode " + this.usbDevice.hashCode() + ")");
        this.usbDevice.removeUsbDeviceListener(this.disconnectListener);
        List list = this.usbEndpoints;
        synchronized (list) {
            Iterator iterator = this.usbEndpoints.iterator();
            while (iterator.hasNext()) {
                UsbEndpoint ep = (UsbEndpoint)iterator.next();
                UsbPipe pipe = ep.getUsbPipe();
                pipe.removeUsbPipeListener((UsbPipeListener)this.inListener);
                try {
                    pipe.abortAllSubmissions();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    pipe.close();
                }
                catch (Exception e) {}
            }
            this.usbEndpoints.clear();
        }
        this.hlHelper.hidDeviceDisconnected(new DisconnectEvent(this, hidException));
        if (null != this.outEndpoint) {
            UsbPipe pipe = this.outEndpoint.getUsbPipe();
            pipe.removeUsbPipeListener((UsbPipeListener)this.outListener);
            try {
                pipe.abortAllSubmissions();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                pipe.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.outEndpoint = null;
        try {
            this.usbInterface.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addUsbEndpointIn(UsbEndpoint ep) throws HidException {
        UsbPipe pipe = ep.getUsbPipe();
        if (pipe.isOpen()) {
            this.disconnectAndThrow(new HidException("Could not access interrupt in pipe (already open)"));
        }
        pipe.addUsbPipeListener((UsbPipeListener)this.inListener);
        List list = this.usbEndpoints;
        synchronized (list) {
            this.usbEndpoints.add(ep);
        }
        try {
            pipe.open();
        }
        catch (Exception e) {
            String errMsg = "Could not open UsbPipe : " + e.getMessage();
            this.tracer.println(errMsg);
            this.tracer.print(e);
            this.disconnectAndThrow(new HidException(errMsg));
        }
        try {
            for (int i = 0; i < 1; ++i) {
                this.submitBuffer(pipe);
            }
        }
        catch (HidException hE) {
            this.disconnectAndThrow(hE);
        }
    }

    protected void addUsbEndpointOut(UsbEndpoint ep) throws HidException {
        if (null != this.outEndpoint) {
            return;
        }
        UsbPipe pipe = ep.getUsbPipe();
        if (pipe.isOpen()) {
            this.disconnectAndThrow(new HidException("Could not access interrupt out pipe (already open)"));
        }
        pipe.addUsbPipeListener((UsbPipeListener)this.outListener);
        this.outEndpoint = ep;
        try {
            pipe.open();
        }
        catch (Exception e) {
            String errMsg = "Could not open UsbPipe : " + e.getMessage();
            this.tracer.println(errMsg);
            this.tracer.print(e);
            this.disconnectAndThrow(new HidException(errMsg));
        }
    }

    protected void disconnectAndThrow(HidException hE) throws HidException {
        this.disconnect(hE);
        throw hE;
    }

    protected void checkForConnection() throws HidException {
        if (!this.isConnected()) {
            throw new HidException("Not connected");
        }
    }

    protected void submitBuffer(UsbPipe pipe) throws HidException {
        try {
            int bufferSize = Util.unsignedInt((short)pipe.getUsbEndpoint().getUsbEndpointDescriptor().wMaxPacketSize());
            if (this.tracer.isOn()) {
                this.tracer.println("submitBuffer on endpoint " + Util.toHexString((byte)pipe.getUsbEndpoint().getUsbEndpointDescriptor().bEndpointAddress()) + " length " + bufferSize);
            }
            pipe.asyncSubmit(new byte[bufferSize]);
        }
        catch (UsbStallException usE) {
            this.clearFeature();
            if (this.usbStallExceptionRetry < 3) {
                ++this.usbStallExceptionRetry;
                if (this.tracer.isOn()) {
                    this.tracer.println("submitBuffer - Retry" + this.usbStallExceptionRetry);
                }
                this.submitBuffer(pipe);
            }
            if (this.tracer.isOn()) {
                this.tracer.println("submitBuffer Retry Limit reached" + this.usbStallExceptionRetry);
                this.tracer.println("Could not resubmit buffer after UsbStallException");
                this.tracer.print((Exception)((Object)usE));
            }
            throw new HidException("Could not resubmit buffer after UsbStallException");
        }
        catch (UsbException uE) {
            String errMsg = "Could not submit UsbIrp(s) : " + uE.getMessage();
            if (this.tracer.isOn()) {
                this.tracer.println(errMsg);
                this.tracer.print((Exception)((Object)uE));
            }
            throw new HidException(errMsg);
        }
        catch (UsbNotActiveException unaE) {
            String errMsg = "This pipe is not active : " + unaE.getMessage();
            if (this.tracer.isOn()) {
                this.tracer.println(errMsg);
            }
            throw new HidException(errMsg);
        }
        catch (UsbNotOpenException unoE) {
            String errMsg = "This pipe is not open : " + unoE.getMessage();
            if (this.tracer.isOn()) {
                this.tracer.println(errMsg);
            }
            throw new HidException(errMsg);
        }
        catch (UsbDisconnectedException udE) {
            String errMsg = "This UsbDevice has been disconnected : " + udE.getMessage();
            if (this.tracer.isOn()) {
                this.tracer.println(errMsg);
            }
            throw new HidException(errMsg);
        }
        catch (IllegalArgumentException iaE) {
            String errMsg = "Illegal buffer submitted to UsbPipe : " + iaE.getMessage();
            if (this.tracer.isOn()) {
                this.tracer.println(errMsg);
                this.tracer.print((Exception)iaE);
            }
            throw new HidException(errMsg);
        }
    }

    protected void clearFeature() throws HidException {
        try {
            if (this.tracer.isOn()) {
                this.tracer.println("clearing feature for interface : " + this.usbInterface.getUsbInterfaceDescriptor().bInterfaceNumber());
            }
            StandardRequest.clearFeature((UsbDevice)this.usbInterface.getUsbConfiguration().getUsbDevice(), (byte)1, (short)1, (short)this.usbInterface.getUsbInterfaceDescriptor().bInterfaceNumber());
            if (this.tracer.isOn()) {
                this.tracer.println(2, "<--clearFeature complete.");
            }
        }
        catch (IllegalArgumentException e) {
            if (this.tracer.isOn()) {
                this.tracer.println("IllegalArgumentException when clearing feature, disconnect interface");
                this.tracer.print((Exception)e);
            }
            this.disconnect();
            throw new HidException("IllegalArgumentException when clearing feature, interface disconnected ");
        }
        catch (UsbException e) {
            if (this.tracer.isOn()) {
                this.tracer.println("UsbException when clearing feature, disconnect interface");
                this.tracer.print((Exception)((Object)e));
            }
            this.disconnect();
            throw new HidException("UsbException when clearing feature, interface disconnected ");
        }
    }

    private class AsyncVisitor
    implements HidAsync.AsyncVisitor {
        private AsyncVisitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitAsyncGetDescriptor(HidAsync.AsyncGetDescriptor async) {
            try {
                byte[] descriptor = HidDeviceUsbAdapter.this.getDescriptor(async.getDescriptorType(), async.getDescriptorIndex(), false);
                async.setDescriptor(descriptor);
                async.setDescriptorLength((short)descriptor.length);
            }
            catch (HidException hE) {
                async.setHidException(hE);
            }
            finally {
                async.setCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitAsyncSetDescriptor(HidAsync.AsyncSetDescriptor async) {
            try {
                HidDeviceUsbAdapter.this.setDescriptor(async.getDescriptorType(), async.getDescriptorIndex(), async.getDescriptorLength(), async.getDescriptor(), false);
            }
            catch (HidException hE) {
                async.setHidException(hE);
            }
            finally {
                async.setCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitAsyncGetReport(HidAsync.AsyncGetReport async) {
            try {
                byte[] report = HidDeviceUsbAdapter.this.getReport(async.getReportType(), async.getReportID(), false);
                async.setReport(report);
                async.setReportLength((short)report.length);
            }
            catch (HidException hE) {
                async.setHidException(hE);
            }
            finally {
                async.setCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitAsyncSetReport(HidAsync.AsyncSetReport async) {
            try {
                HidDeviceUsbAdapter.this.setReport(async.getReportType(), async.getReportID(), async.getReportLength(), async.getReport(), false);
            }
            catch (HidException hE) {
                async.setHidException(hE);
            }
            finally {
                async.setCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitAsyncGetIdle(HidAsync.AsyncGetIdle async) {
            try {
                byte idle = HidDeviceUsbAdapter.this.getIdle(async.getReportID(), false);
                async.setIdleSetting(idle);
            }
            catch (HidException hE) {
                async.setHidException(hE);
            }
            finally {
                async.setCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitAsyncSetIdle(HidAsync.AsyncSetIdle async) {
            try {
                HidDeviceUsbAdapter.this.setIdle(async.getReportID(), async.getIdleSetting(), false);
            }
            catch (HidException hE) {
                async.setHidException(hE);
            }
            finally {
                async.setCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitAsyncGetProtocol(HidAsync.AsyncGetProtocol async) {
            try {
                byte protocol = HidDeviceUsbAdapter.this.getProtocol(false);
                async.setProtocol(protocol);
            }
            catch (HidException hE) {
                async.setHidException(hE);
            }
            finally {
                async.setCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitAsyncSetProtocol(HidAsync.AsyncSetProtocol async) {
            try {
                HidDeviceUsbAdapter.this.setProtocol(async.getProtocol(), false);
            }
            catch (HidException hE) {
                async.setHidException(hE);
            }
            finally {
                async.setCompleted();
            }
        }
    }

    private class HidListenerHelper
    extends EventListenerImp
    implements HidListener {
        private HidListenerHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reportEventOccurred(ReportEvent event) {
            if (HidDeviceUsbAdapter.this.tracer.isOn()) {
                HidDeviceUsbAdapter.this.tracer.println("-->reportEventOccurred() : sending to " + this.listeners.size() + " listeners.");
                HidDeviceUsbAdapter.this.tracer.println("ReportEvent data : " + Util.toFormatedHexString((byte[])event.getData()));
            }
            if (this.isEmpty()) {
                if (HidDeviceUsbAdapter.this.tracer.isOn()) {
                    HidDeviceUsbAdapter.this.tracer.println("No listeners to send event to.");
                }
                return;
            }
            HashMap hashMap = this.listeners;
            synchronized (hashMap) {
                Iterator iterator = this.listeners.values().iterator();
                while (iterator.hasNext()) {
                    EventListenerImp.EventListenerRunnableManager elrM = (EventListenerImp.EventListenerRunnableManager)((Object)iterator.next());
                    HidListener hL = (HidListener)elrM.getEventListener();
                    Runnable r = new Runnable(this, hL, event){
                        private final /* synthetic */ HidListener val$hL;
                        private final /* synthetic */ ReportEvent val$event;
                        private final /* synthetic */ HidListenerHelper this$1;
                        {
                            this.this$1 = this$1;
                            this.val$hL = val$hL;
                            this.val$event = val$event;
                        }

                        public void run() {
                            this.val$hL.reportEventOccurred(this.val$event);
                        }
                    };
                    elrM.add(r);
                }
            }
            if (HidDeviceUsbAdapter.this.tracer.isOn()) {
                HidDeviceUsbAdapter.this.tracer.println(2, "<--reportEventOccurred() : Sent ReportEvent to all Listeners (" + this.listeners.size() + ")");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void hidExceptionEventOccurred(HidExceptionEvent event) {
            if (HidDeviceUsbAdapter.this.tracer.isOn()) {
                HidDeviceUsbAdapter.this.tracer.println("-->hidExceptionEventOccurred() : sending to " + this.listeners.size() + " listeners.");
            }
            if (this.isEmpty()) {
                if (HidDeviceUsbAdapter.this.tracer.isOn()) {
                    HidDeviceUsbAdapter.this.tracer.println("No listeners to send event to.");
                }
                return;
            }
            HashMap hashMap = this.listeners;
            synchronized (hashMap) {
                Iterator iterator = this.listeners.values().iterator();
                while (iterator.hasNext()) {
                    EventListenerImp.EventListenerRunnableManager elrM = (EventListenerImp.EventListenerRunnableManager)((Object)iterator.next());
                    HidListener hL = (HidListener)elrM.getEventListener();
                    Runnable r = new Runnable(this, hL, event){
                        private final /* synthetic */ HidListener val$hL;
                        private final /* synthetic */ HidExceptionEvent val$event;
                        private final /* synthetic */ HidListenerHelper this$1;
                        {
                            this.this$1 = this$1;
                            this.val$hL = val$hL;
                            this.val$event = val$event;
                        }

                        public void run() {
                            this.val$hL.hidExceptionEventOccurred(this.val$event);
                        }
                    };
                    elrM.add(r);
                }
            }
            if (HidDeviceUsbAdapter.this.tracer.isOn()) {
                HidDeviceUsbAdapter.this.tracer.println(2, "<--hidExceptionEventOccurred() : Sent ExceptionEvent to all Listeners");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void hidDeviceDisconnected(DisconnectEvent event) {
            if (HidDeviceUsbAdapter.this.tracer.isOn()) {
                HidDeviceUsbAdapter.this.tracer.println(2, "-->hidDeviceDisconnected() : sending to " + this.listeners.size() + " listeners.");
            }
            if (this.isEmpty()) {
                if (HidDeviceUsbAdapter.this.tracer.isOn()) {
                    HidDeviceUsbAdapter.this.tracer.println("No listeners to send event to.");
                }
                return;
            }
            HashMap hashMap = this.listeners;
            synchronized (hashMap) {
                Iterator iterator = this.listeners.values().iterator();
                while (iterator.hasNext()) {
                    EventListenerImp.EventListenerRunnableManager elrM = (EventListenerImp.EventListenerRunnableManager)((Object)iterator.next());
                    HidListener hL = (HidListener)elrM.getEventListener();
                    Runnable r = new Runnable(this, hL, event){
                        private final /* synthetic */ HidListener val$hL;
                        private final /* synthetic */ DisconnectEvent val$event;
                        private final /* synthetic */ HidListenerHelper this$1;
                        {
                            this.this$1 = this$1;
                            this.val$hL = val$hL;
                            this.val$event = val$event;
                        }

                        public void run() {
                            this.val$hL.hidDeviceDisconnected(this.val$event);
                        }
                    };
                    elrM.add(r);
                }
            }
            if (HidDeviceUsbAdapter.this.tracer.isOn()) {
                HidDeviceUsbAdapter.this.tracer.println(2, "<--hidDeviceDisconnected() : Sent DisconnectEvent to all Listeners");
            }
        }

        public void addHidListener(HidListener listener) {
            this.addEventListener(listener);
        }

        public void removeHidListener(HidListener listener) {
            this.removeEventListener(listener);
        }
    }

    private class ReportListener
    extends UsbPipeErrorListener
    implements UsbPipeListener {
        private ReportListener() {
        }

        public void dataEventOccurred(UsbPipeDataEvent event) {
            super.dataEventOccurred(event);
            HidDeviceUsbAdapter.this.tracer.println("ReportListener");
            byte bEndpointAddress = event.getUsbPipe().getUsbEndpoint().getUsbEndpointDescriptor().bEndpointAddress();
            String bEndpointAddressString = "0x" + Util.toHexString((byte)bEndpointAddress);
            if (HidDeviceUsbAdapter.this.tracer.isOn() && 3 == HidDeviceUsbAdapter.this.tracer.getTraceLevel()) {
                HidDeviceUsbAdapter.this.tracer.println(3, "-->dataEventOccurred() on UsbEndpoint " + bEndpointAddressString + " (length " + event.getData().length + ") : " + Util.toFormatedHexString((byte[])event.getData()));
            }
            UsbPipe pipe = event.getUsbPipe();
            byte[] data = new byte[event.getData().length];
            System.arraycopy(event.getData(), 0, data, 0, event.getData().length);
            HidDeviceUsbAdapter.this.hlHelper.reportEventOccurred(new ReportEvent(HidDeviceUsbAdapter.this, data));
            try {
                HidDeviceUsbAdapter.this.submitBuffer(pipe);
            }
            catch (HidException hE) {
                HidDeviceUsbAdapter.this.disconnect(hE);
            }
            if (HidDeviceUsbAdapter.this.tracer.isOn()) {
                HidDeviceUsbAdapter.this.tracer.println(3, "<--dataEventOccurred() on UsbEndpoint " + bEndpointAddressString + " : Resubmitted buffer, finished.");
            }
        }
    }

    class UsbPipeErrorListener
    implements UsbPipeListener {
        protected int errorCount = 0;

        UsbPipeErrorListener() {
        }

        public void errorEventOccurred(UsbPipeErrorEvent event) {
            if (!HidDeviceUsbAdapter.this.isConnected()) {
                return;
            }
            ++this.errorCount;
            UsbPipe pipe = event.getUsbPipe();
            UsbEndpoint ep = pipe.getUsbEndpoint();
            String bEndpointAddressString = null;
            if (HidDeviceUsbAdapter.this.tracer.isOn()) {
                bEndpointAddressString = "0x" + Util.toHexString((byte)ep.getUsbEndpointDescriptor().bEndpointAddress());
                HidDeviceUsbAdapter.this.tracer.println("-->errorEventOccurred() on UsbEndpoint " + bEndpointAddressString);
            }
            HidException hidException = new HidException("Error (" + this.errorCount + "/" + 10 + ") on pipe 0x" + bEndpointAddressString + " : " + event.getUsbException());
            HidDeviceUsbAdapter.this.hlHelper.hidExceptionEventOccurred(new HidExceptionEvent(HidDeviceUsbAdapter.this, hidException));
            if (10 <= this.errorCount) {
                String errMsg = "Too many consecutive error events (" + this.errorCount + "), disconnecting from UsbDevice.";
                if (HidDeviceUsbAdapter.this.tracer.isOn()) {
                    HidDeviceUsbAdapter.this.tracer.println(errMsg);
                }
                HidDeviceUsbAdapter.this.disconnect(new HidException(errMsg));
            }
            try {
                HidDeviceUsbAdapter.this.submitBuffer(pipe);
            }
            catch (HidException hE) {
                HidDeviceUsbAdapter.this.disconnect(hE);
            }
            if (HidDeviceUsbAdapter.this.tracer.isOn()) {
                HidDeviceUsbAdapter.this.tracer.println("<--errorEventOccurred() on UsbEndpoint " + bEndpointAddressString + " : Resubmitted buffer, finished.");
            }
        }

        public void dataEventOccurred(UsbPipeDataEvent event) {
            this.errorCount = 0;
        }
    }

    private class UsbDeviceDisconnectListener
    implements UsbDeviceListener {
        private UsbDeviceDisconnectListener() {
        }

        public void dataEventOccurred(UsbDeviceDataEvent uddE) {
        }

        public void errorEventOccurred(UsbDeviceErrorEvent udeE) {
        }

        public void usbDeviceDetached(UsbDeviceEvent udE) {
            HidDeviceUsbAdapter.this.disconnect(new HidException("UsbDevice disconnected"));
        }
    }
}

