/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.bus.hid.javaxusb;

import com.ibm.jutil.Util;
import com.ibm.posj.PosException;
import com.ibm.posj.bus.hid.javaxusb.DefaultUsbInterfacePolicy;
import com.ibm.posj.bus.hid.javaxusb.DeferredUsbInitializer;
import com.ibm.posj.bus.hid.javaxusb.UsbInitializer;
import javax.usb.UsbControlIrp;
import javax.usb.UsbInterface;

public abstract class ReenumerateInitializer
extends DeferredUsbInitializer
implements UsbInitializer {
    protected abstract byte getUsbInterfaceNumber();

    protected abstract byte[] getReenumerateCommand();

    protected boolean shouldWaitForDevice() {
        return true;
    }

    protected short getVendorId() {
        return this.getUsbDevice().getUsbDeviceDescriptor().idVendor();
    }

    protected short getProductId() {
        return this.getUsbDevice().getUsbDeviceDescriptor().idProduct();
    }

    protected String getSerialNumber() {
        try {
            return this.getUsbDevice().getSerialNumberString();
        }
        catch (Exception e) {
            if (this.tracer.isOn()) {
                this.tracer.println("Could not get SerialNumber : " + e.getMessage());
                this.tracer.print(e);
            }
            return "";
        }
    }

    protected void deferredInitialize() {
        String errMsg;
        byte bmRequestType = 33;
        byte bRequest = 9;
        short wValue = 512;
        short wIndex = (short)(0xFF & this.getUsbInterfaceNumber());
        UsbControlIrp irp = this.getUsbDevice().createUsbControlIrp(bmRequestType, bRequest, wValue, wIndex);
        irp.setData(this.getReenumerateCommand());
        UsbInterface iface = null;
        try {
            iface = this.getUsbDevice().getActiveUsbConfiguration().getUsbInterface(this.getUsbInterfaceNumber());
        }
        catch (Exception e) {
            if (this.tracer.isOn()) {
                errMsg = "Could not get UsbInterface " + Util.unsignedInt((byte)this.getUsbInterfaceNumber()) + " : " + e.getMessage();
                this.tracer.println(errMsg);
                this.tracer.print(e);
            }
            this.getUsbHandlePopulator().setLastException(new PosException("Could not re-enumerate UsbDevice : " + this.getUsbDevice(), e));
        }
        try {
            iface.claim(DefaultUsbInterfacePolicy.getInstance());
        }
        catch (Exception e) {
            if (this.tracer.isOn()) {
                errMsg = "Could not claim UsbInterface " + Util.unsignedInt((byte)this.getUsbInterfaceNumber()) + " : " + e.getMessage();
                this.tracer.println(errMsg);
                this.tracer.print(e);
            }
            this.getUsbHandlePopulator().setLastException(new PosException("Could not re-enumerate UsbDevice : " + this.getUsbDevice(), e));
        }
        short vId = 0;
        short pId = 0;
        String sN = "";
        boolean w = this.shouldWaitForDevice();
        if (w) {
            vId = this.getVendorId();
            pId = this.getProductId();
            sN = this.getSerialNumber();
            this.getUsbHandlePopulator().waitForDeviceToReenumerate(vId, pId, sN, this.getUsbDevice().hashCode());
        }
        try {
            this.getUsbDevice().syncSubmit(irp);
        }
        catch (Exception e) {
            if (this.tracer.isOn()) {
                String errMsg2 = "Exception while submitting re-enumeration command (this may be ok) : " + e.getMessage();
                this.tracer.println(errMsg2);
                this.tracer.print(e);
            }
            this.getUsbHandlePopulator().setLastException(new PosException("Could not re-enumerate UsbDevice : " + this.getUsbDevice(), e));
        }
    }
}

