/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.bus.rs232;

import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import com.ibm.posj.HandleException;
import com.ibm.posj.bus.rs232.Rs232IntegratedScannerProtocolListener;
import com.ibm.posj.bus.rs232.Rs232IntegratedScannerState;
import com.ibm.posj.util.DevCats;
import java.io.IOException;
import java.io.InputStream;

public abstract class Rs232IntegratedScannerProtocol {
    public static final int OK = 1;
    public static final int WAIT = 2;
    public static final int ERROR = 3;
    private static final int MIN_INTERVAL = 5;
    private static final String RECOVERY_NOT_ENABLED_STRING = "Recovery not enabled.";
    private static final String PROTOCOL_ALREADY_RECOVERING_STRING = "Protocol already recovering.";
    private static final String PROTOCOL_NOT_RECOVERING_STRING = "Protocol not recovering.";
    private static final String POLLER_THREAD_NAME = "DevicePollerThread";
    protected Tracer tracer = TracerFactory.getInstance().createTracer(((Object)DevCats.SCANNER_DEVCAT).toString(), this.getClass().getName());
    protected DevicePoller devicePoller = null;
    protected Rs232IntegratedScannerProtocolListener protocolListener = null;
    private boolean isRecovering = false;

    Rs232IntegratedScannerProtocol(Rs232IntegratedScannerProtocolListener protocolListener, int pollIntervalInMinutes) {
        Thread pollerThread = null;
        this.protocolListener = protocolListener;
        if (pollIntervalInMinutes <= 0) {
            return;
        }
        if (pollIntervalInMinutes < 5) {
            pollIntervalInMinutes = 5;
        }
        this.devicePoller = new DevicePoller(pollIntervalInMinutes);
        pollerThread = new Thread(this.devicePoller);
        pollerThread.setName(POLLER_THREAD_NAME);
        pollerThread.start();
        this.devicePoller.startPolling();
    }

    public void write(byte[] buffer) throws HandleException {
        if (this.tracer.isOn()) {
            this.tracer.println("-->write");
        }
        block7: while (true) {
            switch (this.getCurrentState().write(buffer)) {
                case 2: {
                    if (this.tracer.isOn()) {
                        this.tracer.println("waiting...");
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                    continue block7;
                }
                case 3: {
                    if (this.tracer.isOn()) {
                        this.tracer.println("write exception");
                        this.tracer.println("<--write");
                    }
                    throw new HandleException("Communication Error with device");
                }
                case 1: {
                    if (this.tracer.isOn()) {
                        this.tracer.println("write ok");
                        this.tracer.println("<--write");
                    }
                    return;
                }
            }
        }
    }

    public void flushInputStream(InputStream is) {
        block4: {
            if (this.tracer.isOn()) {
                this.tracer.println(3, "Flushing input stream...");
            }
            try {
                while (is.available() > 0) {
                    is.read();
                }
            }
            catch (IOException e) {
                if (!this.tracer.isOn()) break block4;
                this.tracer.print((Exception)e);
            }
        }
    }

    public void submitToAdapter(byte[] data) {
        if (this.tracer.isOn()) {
            this.tracer.println("-->submitToAdapter");
        }
        this.protocolListener.writeToPort(data);
        if (this.tracer.isOn()) {
            this.tracer.println("<--submitToAdapter");
        }
    }

    public void fireDataEvent(byte[] data) {
        this.protocolListener.fireDataEvent(data);
    }

    public void fireErrorEvent(int type) {
        this.protocolListener.fireErrorEvent(type);
    }

    public void fireDirectIOEvent(byte[] data) {
        this.protocolListener.fireDirectIOEvent(data);
    }

    public void fireOnlineEvent() {
        this.protocolListener.fireOnlineEvent();
    }

    public void fireOfflineEvent() {
        this.protocolListener.fireOfflineEvent();
    }

    public void startRecovering() {
        if (this.tracer.isOn()) {
            this.tracer.println("-->startRecovering()");
        }
        if (!this.isRecoveringEnabled()) {
            if (this.tracer.isOn()) {
                this.tracer.println(RECOVERY_NOT_ENABLED_STRING);
            }
            return;
        }
        if (this.isRecovering()) {
            if (this.tracer.isOn()) {
                this.tracer.println(PROTOCOL_ALREADY_RECOVERING_STRING);
            }
            return;
        }
        this.isRecovering = true;
        this.fireErrorEvent(-100);
        this.fireOfflineEvent();
        this.devicePoller.stopPolling();
        this.restart();
        this.devicePoller.startPolling();
        if (this.tracer.isOn()) {
            this.tracer.println("<--startRecovering()");
        }
    }

    public void stopRecovering() {
        if (this.tracer.isOn()) {
            this.tracer.println("-->stopRecovering()");
        }
        if (!this.isRecoveringEnabled()) {
            if (this.tracer.isOn()) {
                this.tracer.println(RECOVERY_NOT_ENABLED_STRING);
            }
            return;
        }
        if (!this.isRecovering()) {
            if (this.tracer.isOn()) {
                this.tracer.println(PROTOCOL_NOT_RECOVERING_STRING);
            }
            return;
        }
        this.isRecovering = false;
        this.fireOnlineEvent();
        if (this.tracer.isOn()) {
            this.tracer.println("<--stopRecovering()");
        }
    }

    public boolean isRecovering() {
        return this.isRecovering;
    }

    public boolean isRecoveringEnabled() {
        return this.devicePoller != null;
    }

    protected void pollDevice() throws HandleException {
    }

    protected void processPollDeviceException() {
        this.restart();
    }

    protected void start() {
    }

    protected void stop() {
    }

    protected void restart() {
        this.stop();
        this.start();
    }

    protected abstract Rs232IntegratedScannerState getCurrentState();

    private class DevicePoller
    implements Runnable {
        private long intervalInMillis = 0L;
        private boolean isPolling = false;

        public DevicePoller(int intervalInSeconds) {
            this.intervalInMillis = intervalInSeconds * 1000;
        }

        public void startPolling() {
            this.isPolling = true;
        }

        public void stopPolling() {
            this.isPolling = false;
        }

        public boolean isPolling() {
            return this.isPolling;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                if (!this.isPolling) {
                    continue;
                }
                DevicePoller devicePoller = this;
                synchronized (devicePoller) {
                    try {
                        this.wait(this.intervalInMillis);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    Rs232IntegratedScannerProtocol.this.pollDevice();
                    continue;
                }
                catch (HandleException e) {
                    Rs232IntegratedScannerProtocol.this.processPollDeviceException();
                    continue;
                }
                break;
            }
        }
    }
}

