/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.bus.rs232;

import com.ibm.jutil.BooleanMonitor;
import com.ibm.jutil.ByteArrayCollector;
import com.ibm.jutil.SleepPolicy;
import com.ibm.jutil.Util;
import com.ibm.jutil.tasks.AbstractActiveObject;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.posj.bus.rs232.javaxcomm.Rs232PortCommAdapter;
import com.ibm.posj.printer.PrinterWriter;
import com.ibm.rs232.Rs232Port;
import com.ibm.rs232.event.Rs232DataEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class Rs232PrinterReader
implements Rs232PortCommAdapter.DataReaderStrategy {
    public static final int DLE = 16;
    public static final int XON = 17;
    public static final int XOFF = 19;
    private Rs232PrinterReader reader = null;
    private boolean flowXONXOFF = false;
    private boolean firstCall = true;
    private DataHandler dataHandle = new DataHandler();
    private ByteArrayCollector collector = ByteArrayCollector.getCollector();
    public PushbackInputStream pbis = null;
    int len = -1;
    long lastRead = 0L;
    byte[] lenBuffer = new byte[]{0, 0};

    public Rs232PrinterReader(Rs232Port port) {
        this.configFlowControl(port.getRs232config().getFlowControl());
    }

    private void configFlowControl(int flowControl) {
        int XON_XOFF;
        if (this.traceOn()) {
            this.trace().println("config Flow Control to-->" + flowControl);
        }
        if (flowControl == (XON_XOFF = 12)) {
            this.flowXONXOFF = true;
        }
    }

    public void kill() {
        this.dataHandle.die();
    }

    public boolean isReceiving() {
        boolean ret = false;
        if (null != this.pbis) {
            try {
                int total = (int)(System.currentTimeMillis() - this.lastRead);
                int avail = this.pbis.available();
                if (avail > 0 || total < 2500) {
                    ret = true;
                }
            }
            catch (Exception e) {
                this.trace().print(e);
            }
        }
        return ret;
    }

    public void dataAvailable(InputStream isr, Rs232Port.EventHelper helper) throws IOException {
        if (this.firstCall) {
            this.dataHandle.setStreamHelper(isr, helper);
            this.firstCall = false;
        }
        if (!this.dataHandle.isStarted()) {
            this.dataHandle.start();
        }
        this.dataHandle.increment();
    }

    private void handleData(InputStream isr, Rs232Port.EventHelper helper) throws IOException {
        if (-1 == this.len) {
            if (this.pbis.available() < 8) {
                return;
            }
            if (this.traceOn()) {
                this.trace().println(">>doRead length");
            }
            try {
                this.doRead(2, this.lenBuffer);
            }
            catch (IllegalArgumentException iae) {
                if (this.traceOn()) {
                    this.trace().print((Exception)iae);
                }
                this.len = -1;
                return;
            }
            if (this.traceOn()) {
                this.trace().println("<<doRead length " + Util.toFormatedHexString((byte[])this.lenBuffer));
            }
            if (this.lenBuffer[0] == 0 && this.lenBuffer[1] == 0) {
                this.pbis.unread(0);
                this.len = -1;
                return;
            }
            int high = Util.unsignedInt((byte)this.lenBuffer[0]);
            int low = Util.unsignedInt((byte)this.lenBuffer[1]);
            this.len = (high << 8) + low - 2;
            if (this.traceOn()) {
                this.trace().println("Proposed length " + this.len + " available " + this.pbis.available());
            }
        }
        if (0 >= this.len) {
            this.len = -1;
            return;
        }
        byte[] data = this.collector.getArray(this.len);
        try {
            if (this.trace().isOn()) {
                this.trace().print("-->Status doRead");
            }
            this.doRead(this.len, data);
            if (this.trace().isOn()) {
                this.trace().print("<--Status doRead");
            }
        }
        catch (IllegalArgumentException iae) {
            this.trace().print((Exception)iae);
            this.len = -1;
            return;
        }
        this.trace().println("fire " + Util.toFormatedHexString((byte[])data));
        helper.fireDataEvent(new Rs232DataEvent(this, data));
        this.len = -1;
    }

    protected void doRead(int len, byte[] data) throws IllegalArgumentException {
        int read = 0;
        int jread = 0;
        while (read != len) {
            try {
                this.trace().println(">> doread " + Thread.currentThread().getName());
                jread = this.pbis.read();
                if (this.trace().isOn()) {
                    this.trace().print(3, Util.toHexString((int)jread));
                }
                if (this.flowXONXOFF && 16 == jread) {
                    jread = this.pbis.read();
                    jread = this.unstuff(jread);
                }
                data[read++] = (byte)jread;
                this.lastRead = System.currentTimeMillis();
                if (len < 256 || read < 5 || (data[4] & 0x80) > 0) continue;
                throw new IllegalArgumentException("Length > 256 and not a image read");
            }
            catch (Exception e) {
                this.trace().print(e);
                this.waitForData();
            }
        }
        this.trace().println("<< doread " + Thread.currentThread().getName());
    }

    protected void waitForData() {
        if (this.traceOn()) {
            this.trace().println("BAD: Waiting for data");
        }
        while (true) {
            try {
                if (this.pbis.available() > 0) {
                    return;
                }
            }
            catch (Exception e) {
                this.trace().print(e);
            }
            SleepPolicy.sleep((long)200L);
        }
    }

    /*
     * WARNING - void declaration
     */
    private byte unstuff(int start) {
        void var2_2;
        if (this.trace().isOn()) {
            this.trace().print("unstuff " + Util.toHexString((int)start));
        }
        switch (start) {
            case 49: {
                int uns = 16;
                break;
            }
            case 48: {
                int uns = 17;
                break;
            }
            case 50: {
                int uns = 19;
                break;
            }
            default: {
                throw new IllegalArgumentException("INVALID: Status from the printer");
            }
        }
        return (byte)var2_2;
    }

    public boolean traceOn() {
        return PrinterWriter.getTracer().isOn();
    }

    public Tracer trace() {
        return PrinterWriter.getTracer();
    }

    public class DataHandler
    extends AbstractActiveObject {
        private boolean infinite = true;
        private int dataAvailCnt = 0;
        private BooleanMonitor lock = new BooleanMonitor(false);
        private InputStream isr;
        private Rs232Port.EventHelper helper;

        public void setStreamHelper(InputStream i, Rs232Port.EventHelper eh) {
            this.isr = i;
            this.helper = eh;
        }

        public void increment() {
            ++this.dataAvailCnt;
            if (this.lock.isTrue()) {
                this.lock.set(false);
            }
        }

        public void die() {
            this.infinite = false;
        }

        protected void runActiveObject() {
            while (this.infinite) {
                try {
                    if (Rs232PrinterReader.this.pbis != null && Rs232PrinterReader.this.pbis.available() < 7) {
                        Rs232PrinterReader.this.trace().println("Using reader " + Rs232PrinterReader.this.pbis.available());
                        this.lock.set(true);
                        try {
                            this.lock.waitForFalse(6000);
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                    if (null == Rs232PrinterReader.this.pbis) {
                        Rs232PrinterReader.this.pbis = new PushbackInputStream(this.isr, 50);
                    }
                    if (Rs232PrinterReader.this.traceOn()) {
                        Rs232PrinterReader.this.trace().println(this.dataAvailCnt + "-->handleData Data availables - size = " + Rs232PrinterReader.this.pbis.available());
                    }
                    Rs232PrinterReader.this.handleData(this.isr, this.helper);
                    if (Rs232PrinterReader.this.traceOn()) {
                        Rs232PrinterReader.this.trace().println("<--handleData dataAvailable available " + Rs232PrinterReader.this.pbis.available());
                    }
                    if (Rs232PrinterReader.this.pbis.available() > 8) {
                        Rs232PrinterReader.this.dataAvailable(Rs232PrinterReader.this.pbis, this.helper);
                    }
                    --this.dataAvailCnt;
                }
                catch (IOException ie) {
                    Rs232PrinterReader.this.trace().print((Exception)ie);
                }
            }
            Rs232PrinterReader.this.trace().println("-->!!! Exiting reader thread");
        }
    }
}

