/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.bus.rs232.javaxcomm;

import com.ibm.rs232.Rs232Config;
import java.util.Enumeration;
import jpos.config.JposEntry;
import jpos.config.simple.xml.SimpleXmlRegPopulator;

public class Rs232Util {
    public static final String DEFAULT_PORTNAME = "";
    public static final int DEFAULT_BAUDRATE = 9600;
    public static final int DEFAULT_DATABITS = 8;
    public static final int DEFAULT_PARITY = 0;
    public static final int DEFAULT_STOPBITS = 1;
    public static final int DEFAULT_FLOWCONTROL = 0;

    public static Rs232Config createRs232Config(JposEntry jposEntry) {
        Object obj = jposEntry.getPropertyValue("portName");
        String portName = obj == null ? DEFAULT_PORTNAME : (String)obj;
        obj = jposEntry.getPropertyValue("baudRate");
        int baudRate = obj == null ? 9600 : Integer.valueOf((String)obj);
        obj = jposEntry.getPropertyValue("dataBits");
        int dataBits = obj == null ? 8 : Integer.valueOf((String)obj);
        obj = jposEntry.getPropertyValue("parity");
        int parity = obj == null ? 0 : Rs232Util.mapParity((String)obj);
        obj = jposEntry.getPropertyValue("stopBits");
        int stopBits = obj == null ? 1 : Rs232Util.mapStopBits((String)obj);
        obj = jposEntry.getPropertyValue("flowControl");
        int flowControl = obj == null ? 0 : Rs232Util.mapFlowControl((String)obj);
        return new Rs232Config(portName, baudRate, dataBits, parity, stopBits, flowControl);
    }

    public static Enumeration getJposEntries(String fileName) {
        SimpleXmlRegPopulator xmlPop = new SimpleXmlRegPopulator();
        xmlPop.load(fileName);
        Enumeration e = xmlPop.getEntries();
        return e;
    }

    protected static int mapParity(String jclParity) {
        int parity = jclParity.equals("None") ? 0 : (jclParity.equals("Even") ? 2 : (jclParity.equals("Mark") ? 3 : (jclParity.equals("Odd") ? 1 : (jclParity.equals("Space") ? 4 : 0))));
        return parity;
    }

    protected static int mapStopBits(String jclStopBits) {
        int stopBits = jclStopBits.equals("1") ? 1 : (jclStopBits.equals("1.5") ? 3 : (jclStopBits.equals("2") ? 2 : 1));
        return stopBits;
    }

    protected static int mapFlowControl(String jclFlowControl) {
        int flowControl = jclFlowControl.equals("None") ? 0 : (jclFlowControl.equals("Xon/Xoff") ? 12 : (jclFlowControl.equals("Hardware") ? 3 : 0));
        return flowControl;
    }
}

