/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.bus.rs485;

import com.ibm.jsio.SioDevice;
import com.ibm.jsio.event.SioDeviceDataEvent;
import com.ibm.posj.FiscalPrinterInfoHelper;
import com.ibm.posj.HandleCmd;
import com.ibm.posj.HandleException;
import com.ibm.posj.HandleKey;
import com.ibm.posj.SystemCmd;
import com.ibm.posj.bus.FiscalPrinterHandleImp;
import com.ibm.posj.bus.HandleImpVisitor;
import com.ibm.posj.bus.rs485.AbstractRs485HandleImp;
import com.ibm.posj.bus.rs485.Rs485FiscalPrinterInfoHelper;
import com.ibm.posj.event.DataEvent;
import com.ibm.posj.event.DirectIOEvent;
import com.ibm.posj.event.StatusEvent;
import com.ibm.posj.util.DevCat;
import com.ibm.posj.util.DevCats;

public class Rs485FiscalPrinterHandleImp
extends AbstractRs485HandleImp
implements FiscalPrinterHandleImp {
    private boolean protocolStarted = false;
    private boolean devInfoReceived = false;
    private byte devID = 0;

    public Rs485FiscalPrinterHandleImp(HandleKey key, SioDevice sioDevice) {
        super(key, sioDevice);
    }

    public void accept(HandleImpVisitor visitor) {
        visitor.visitFiscalPrinter(this);
    }

    public DevCat getDevCat() {
        return DevCats.FISCALPRINTER_DEVCAT;
    }

    public short getECLevel() {
        return (short)Rs485FiscalPrinterInfoHelper.getInstance().getECLevel();
    }

    public FiscalPrinterInfoHelper getInfoHelper() {
        return Rs485FiscalPrinterInfoHelper.getInstance();
    }

    public void startProtocol() {
        if (this.protocolStarted) {
            return;
        }
        this.protocolStarted = true;
        IPLEndSimm submitter = new IPLEndSimm(this);
        submitter.start();
    }

    public void stopProtocol() {
        this.protocolStarted = false;
    }

    protected void dataEventOccurred(SioDeviceDataEvent event) {
        if (this.isTracerOn()) {
            this.traceNormal("-->dataEventOccurred");
            this.traceNormal("data length: " + event.getData().length);
        }
        if (this.getHandle() == null) {
            if (this.isTracerOn()) {
                this.traceNormal("null handle <--dataEventOccurred");
            }
            return;
        }
        if (this.getHandle().isDirectIOMode()) {
            this.getHandle().getEventHelper().fireDirectIOEvent(new DirectIOEvent(this, event.getData()));
        }
        if (Rs485FiscalPrinterInfoHelper.getInstance().isDeviceInfo(event.getData())) {
            this.devInfoReceived = true;
        }
        Rs485FiscalPrinterInfoHelper.getInstance().setFiscalInformation(event.getData());
        this.getHandle().getEventHelper().fireDataEvent(new DataEvent(this, event.getData()));
        if (this.isTracerOn()) {
            this.traceNormal("<--dataEventOccurred");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void submit(HandleCmd cmd) throws HandleException {
        ln = 0;
        cmddata = null;
        if (this.isTracerOn()) {
            this.traceNormal("-->submit");
        }
        if (cmd == null) {
            if (this.isTracerOn()) {
                this.traceNormal("null command exception");
            }
            throw new HandleException("Attempted to submit a null command to handle");
        }
        try {
            switch (cmd.getCode()) {
                case 104: {
                    if (this.isTracerOn()) {
                        this.traceNormal("_DIRECT_WRITE_CMD_CODE");
                    }
                    ln = cmd.toBytes().length;
                    cmddata = new byte[ln];
                    System.arraycopy(cmd.toBytes(), 0, cmddata, 0, ln);
                    this.submitSync(cmddata, 0, ln);
                    ** break;
lbl19:
                    // 1 sources

                    break;
                }
                case 1201: {
                    if (this.isTracerOn()) {
                        this.traceNormal("_WRITE_CODE");
                    }
                    ln = cmd.toBytes().length + 2;
                    cmddata = new byte[ln];
                    cmddata[0] = 27;
                    cmddata[1] = 102;
                    System.arraycopy(cmd.toBytes(), 0, cmddata, 2, ln - 2);
                    this.submitSync(cmddata, 0, ln);
                    ** break;
lbl30:
                    // 1 sources

                    break;
                }
                case 100: {
                    if (this.isTracerOn()) {
                        this.traceNormal("TEST_REQUEST_CMD_CODE");
                    }
                    ln = cmd.toBytes().length;
                    cmddata = new byte[ln];
                    System.arraycopy(cmd.toBytes(), 0, cmddata, 0, ln);
                    this.submitSync(cmddata, 0, ln);
                    ** break;
lbl39:
                    // 1 sources

                    break;
                }
                case 101: {
                    if (this.isTracerOn()) {
                        this.traceNormal("STATUS_REQUEST_CMD_CODE");
                    }
                    ln = cmd.toBytes().length;
                    cmddata = new byte[ln];
                    System.arraycopy(cmd.toBytes(), 0, cmddata, 0, ln);
                    this.submitSync(cmddata, 0, ln);
                    ** break;
lbl48:
                    // 1 sources

                    break;
                }
                case 102: {
                    if (this.isTracerOn()) {
                        this.traceNormal("RESET_CMD_CODE");
                    }
                    ln = cmd.toBytes().length;
                    cmddata = new byte[ln];
                    System.arraycopy(cmd.toBytes(), 0, cmddata, 0, ln);
                    this.submitSync(cmddata, 0, ln);
                    ** break;
lbl57:
                    // 1 sources

                    break;
                }
                case 103: {
                    if (this.isTracerOn()) {
                        this.traceNormal("DEVICE_INFO_REQUEST_CMD_CODE");
                    }
                    ln = cmd.toBytes().length;
                    cmddata = new byte[ln];
                    System.arraycopy(cmd.toBytes(), 0, cmddata, 0, ln);
                    this.submitSync(cmddata, 0, ln);
                    i = 0;
                    while (!this.devInfoReceived && i < 30) {
                        ++i;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {}
                    }
                    ((SystemCmd.DeviceInfoRequestCmd)cmd).setFirmwareLevel(this.getECLevel());
                    if (this.devID == 0) {
                        ((SystemCmd.DeviceInfoRequestCmd)cmd).setDeviceType(2702);
                        ((SystemCmd.DeviceInfoRequestCmd)cmd).setDeviceId(2720);
                        ** break;
lbl78:
                        // 1 sources

                    } else if (this.devID == 1) {
                        ((SystemCmd.DeviceInfoRequestCmd)cmd).setDeviceType(2703);
                        ((SystemCmd.DeviceInfoRequestCmd)cmd).setDeviceId(2719);
                        ** break;
                    }
lbl83:
                    // 3 sources

                    break;
                }
                default: {
                    if (this.isTracerOn()) {
                        this.traceNormal("unknown command");
                    }
                    throw new HandleException("unknown command");
                }
            }
        }
        catch (HandleException he) {
            if (this.isTracerOn()) {
                this.traceNormal("handle exception");
            }
            this.setHandleCmdResultInError(cmd, true);
            throw he;
        }
        finally {
            cmd.setCompleted(true);
        }
        cmd.setCompleted(true);
        if (this.isTracerOn()) {
            this.traceNormal("<--submit");
        }
    }

    private class IPLEndSimm
    extends Thread {
        private Rs485FiscalPrinterHandleImp handleImp = null;

        public IPLEndSimm(Rs485FiscalPrinterHandleImp imp) {
            this.handleImp = imp;
        }

        public void run() {
            try {
                IPLEndSimm.sleep(2000L);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            byte[] data = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 67};
            this.handleImp.getHandle().getEventHelper().fireStatusEvent(new StatusEvent(this.handleImp, 2));
            SioDeviceDataEvent ev = new SioDeviceDataEvent(this.handleImp.getSioDevice(), this.handleImp.getSioDevice().createSioIrp(data, false), data);
            this.handleImp.dataEventOccurred(ev);
        }
    }
}

