/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.bus.rs485;

import com.ibm.jutil.UtilProperties;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import com.ibm.posj.util.DefaultProperties;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public final class Rs485Util {
    private static Rs485Util instance = null;
    private HashMap waitTime = new HashMap();
    private final Tracer tracer = TracerFactory.getInstance().createTracer("RS485", "Rs485Util");
    public static final String WAIT_TIME_PROP = "com.ibm.posj.bus.rs485.waitTime.";

    private Rs485Util() {
    }

    private static synchronized Rs485Util getInstance() {
        if (instance == null) {
            instance = new Rs485Util();
            instance.init();
        }
        return instance;
    }

    public static boolean hasCustomWaitTime(byte number) {
        return Rs485Util.getMap().containsKey(Rs485Util.getMapKey(number));
    }

    public static byte getCustomAdressWaitTime(byte number) {
        if (!Rs485Util.hasCustomWaitTime(number)) {
            return -1;
        }
        UtilSioDevice dev = (UtilSioDevice)Rs485Util.getMap().get(Rs485Util.getMapKey(number));
        return dev.getAddressWaitTime();
    }

    public static byte getCustomInterByteWaitTime(byte number) {
        if (!Rs485Util.hasCustomWaitTime(number)) {
            return -1;
        }
        UtilSioDevice dev = (UtilSioDevice)Rs485Util.getMap().get(Rs485Util.getMapKey(number));
        return dev.getInterByteWaitTime();
    }

    private void init() {
        DefaultProperties prop = new DefaultProperties();
        prop.loadProperties();
        this.loadProperties((UtilProperties)prop, this.waitTime);
    }

    private void loadProperties(UtilProperties prop, Map map) {
        if (this.tracer.isOn()) {
            this.trace("-->loadProperties");
        }
        Enumeration e = prop.getPropertyNames();
        String property = "";
        String value = "";
        String devId = "";
        StringBuffer traceText = new StringBuffer();
        int pos = 0;
        byte aWait = 0;
        byte bWait = 0;
        while (e.hasMoreElements()) {
            property = (String)e.nextElement();
            if (!property.startsWith(WAIT_TIME_PROP)) continue;
            value = prop.getStringProperty(property);
            pos = value.indexOf(44);
            try {
                aWait = Integer.decode(value.substring(0, pos)).byteValue();
                bWait = Integer.decode(value.substring(pos + 1)).byteValue();
            }
            catch (NumberFormatException nfe) {
                if (!this.tracer.isOn()) continue;
                this.tracer.print((Exception)nfe);
                this.trace("Unable to load \"" + property + "=" + value + "\" property : " + nfe.toString());
                continue;
            }
            pos = property.lastIndexOf(46);
            devId = property.substring(pos + 1);
            if (this.tracer.isOn() && !map.containsKey(devId)) {
                traceText.append("{" + devId + "=" + value + "} ");
                if (map.size() % 5 == 4) {
                    traceText.append("\n");
                }
            }
            map.put(devId, new UtilSioDevice(aWait, bWait));
        }
        if (this.tracer.isOn()) {
            this.trace(map.size() + " properties loaded for " + WAIT_TIME_PROP);
            this.trace("<com.ibm.posj.bus.rs485.waitTime. Format :<SioDeviceNumber>,<Address wait>,<InterByte wait>>\n" + traceText.toString() + "\n</" + WAIT_TIME_PROP + ">");
            this.trace("<--loadProperties");
        }
    }

    private static Map getMap() {
        return Rs485Util.getInstance().waitTime;
    }

    private static Object getMapKey(byte number) {
        return Integer.toHexString(number).toUpperCase();
    }

    private void trace(String s) {
        this.tracer.println(2, s);
    }

    private class UtilSioDevice {
        private byte aWait;
        private byte iWait;

        public UtilSioDevice(byte a, byte i) {
            this.aWait = a;
            this.iWait = i;
        }

        public byte getAddressWaitTime() {
            return this.aWait;
        }

        public byte getInterByteWaitTime() {
            return this.iWait;
        }
    }
}

