/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.kbd;

import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import com.ibm.posj.kbd.POSKeyboardMapDoubleKey;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class POSKeyboardMap {
    private Tracer tracer;
    private static final String className = "POSKeyboardMap";
    private String inString;
    private int lineNumber;
    private int[][] kbdMap;
    private int kbdMapLength;
    private int kbdMapDblKeyLength;
    private int[][] vMap;
    private int vMapLength;
    private int[] s1Array;
    private int[] s2Array;
    private int[][] doubleKeyRuleSet;
    private POSKeyboardMapDoubleKey doubleKeyProcessor;
    private static Vector scancodeSeqVector = new Vector();
    private static Vector virScancodeVector = new Vector();
    private static final int FOUND = 1;
    private static final int IN_PROGRESS = 2;
    private static final int NOT_FOUND = 3;
    public static final int LESS = -1;
    public static final int EQUAL = 0;
    public static final int GREATER = 1;
    static final String START_VIRTUAL_SC_TOKEN = "[";
    static final String END_VIRTUAL_SC_TOKEN = "]";
    static final int END_SENTINAL = -1;
    private static int pHead = 0;
    private static int pTail = 0;
    private static int index = 0;
    private static int kbdMapMaxWidth = 0;
    private static int[][] inputBuf = new int[0][0];
    private static int[] virtualKey = new int[0];
    private static int flag = 3;

    protected POSKeyboardMap(String fileName) {
        block5: {
            this.tracer = TracerFactory.getInstance().createTracer(className);
            this.lineNumber = 0;
            this.kbdMap = new int[0][0];
            this.kbdMapLength = 0;
            this.kbdMapDblKeyLength = 0;
            this.vMap = new int[0][0];
            this.vMapLength = 0;
            this.s1Array = new int[0];
            this.s2Array = new int[0];
            this.doubleKeyRuleSet = new int[0][];
            try {
                FileReader fr = new FileReader(fileName);
                BufferedReader br = new BufferedReader(fr);
                while ((this.inString = br.readLine()) != null) {
                    ++this.lineNumber;
                    if (this.inString.trim() == null || this.inString.startsWith("#")) continue;
                    this.processInputLine(this.inString);
                }
                fr.close();
                this.doubleKeyProcessor = new POSKeyboardMapDoubleKey(this.doubleKeyRuleSet);
                this.showVector(virScancodeVector, "content of virScancodeVector:");
                this.showVector(scancodeSeqVector, "content of scancodeSeqVector:");
                makeArrayFromVector n = new makeArrayFromVector(virScancodeVector);
                this.vMap = n.getArray();
                this.vMapLength = n.getArrayLenght();
                makeArrayFromVector m = new makeArrayFromVector(scancodeSeqVector);
                this.kbdMap = m.getArray();
                this.kbdMapLength = m.getArrayLenght();
                this.kbdMapDblKeyLength = this.doubleKeyProcessor.getDoubleKeyList().length;
                pHead = 0;
                pTail = this.kbdMapLength;
                index = 0;
                kbdMapMaxWidth = m.getArrayMaxWidth();
                inputBuf = new int[kbdMapMaxWidth][2];
                this.showArray(this.kbdMap, this.kbdMapLength, "scancodeSequenceArray");
                this.showArray(this.vMap, this.vMapLength, "virtualScancodeArray");
            }
            catch (FileNotFoundException e) {
                this.kbdMapLength = 0;
                this.kbdMapDblKeyLength = 0;
                this.doubleKeyProcessor = new POSKeyboardMapDoubleKey(new int[0][0]);
                if (this.tracer.isOn()) {
                    this.tracer.print((Exception)e);
                    this.tracer.println("file not found!" + e);
                }
            }
            catch (IOException e) {
                this.kbdMapLength = 0;
                this.kbdMapDblKeyLength = 0;
                this.doubleKeyProcessor = new POSKeyboardMapDoubleKey(new int[0][0]);
                if (!this.tracer.isOn()) break block5;
                this.tracer.print((Exception)e);
            }
        }
    }

    public void processInputLine(String s) {
        int i;
        if (s.length() < 3) {
            return;
        }
        String virtualScancodeLine = "";
        String scancodeSequenceLine = "";
        char[] tmp = s.toCharArray();
        for (int cnt = 0; cnt < tmp.length; ++cnt) {
            if (tmp[cnt] != '\t') continue;
            tmp[cnt] = 32;
        }
        s = new String(tmp);
        if (this.tracer.isOn()) {
            this.tracer.println("processInputLine s:" + s);
        }
        if (s.startsWith(START_VIRTUAL_SC_TOKEN) && (i = s.indexOf(END_VIRTUAL_SC_TOKEN)) != -1) {
            virtualScancodeLine = s.substring(1, i).trim();
            scancodeSequenceLine = s.substring(i + 1).trim();
        } else {
            i = s.indexOf(" ");
            if (i != -1) {
                virtualScancodeLine = s.substring(0, i).trim();
                scancodeSequenceLine = s.substring(i + 1).trim();
            }
        }
        int[] virtualScancodeLineArray = this.processString(virtualScancodeLine);
        int[] scancodeSequenceLineArray = this.processString(scancodeSequenceLine);
        if (virtualScancodeLineArray.length != 0 && virtualScancodeLineArray[0] == 255) {
            int[][] doubleKeyRuleSetTmp = new int[this.doubleKeyRuleSet.length + 1][];
            for (int k = 0; k < this.doubleKeyRuleSet.length; ++k) {
                doubleKeyRuleSetTmp[k] = this.doubleKeyRuleSet[k];
            }
            doubleKeyRuleSetTmp[this.doubleKeyRuleSet.length] = scancodeSequenceLineArray;
            this.doubleKeyRuleSet = doubleKeyRuleSetTmp;
            virtualScancodeLineArray = new int[]{};
            scancodeSequenceLineArray = new int[]{};
        }
        if (this.tracer.isOn()) {
            this.tracer.println("input line:" + s);
        }
        if (virtualScancodeLineArray.length != 0 && scancodeSequenceLineArray.length != 0 && this.validateArrayValue(virtualScancodeLineArray, Integer.MAX_VALUE)) {
            if (this.tracer.isOn()) {
                this.tracer.println("-->OK");
            }
            this.insertElement(virtualScancodeLineArray, scancodeSequenceLineArray);
        } else if (this.tracer.isOn()) {
            this.tracer.println("-->Ignore");
        }
    }

    private int[] processString(String s) {
        String s1;
        int[] scanCodes = new int[]{};
        StringTokenizer st = new StringTokenizer(s);
        if (this.tracer.isOn()) {
            this.tracer.println("processString s:" + s);
        }
        while (st.hasMoreTokens() && !(s1 = st.nextToken()).startsWith("#")) {
            int n = this.decodeString(s1);
            if (-1 != n) {
                int[] temp = new int[scanCodes.length + 1];
                for (int i = 0; i < scanCodes.length; ++i) {
                    temp[i] = scanCodes[i];
                }
                temp[scanCodes.length] = n;
                scanCodes = temp;
                continue;
            }
            return new int[0];
        }
        return scanCodes;
    }

    private boolean validateArrayValue(int[] array, int max) {
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max) continue;
            return false;
        }
        return true;
    }

    private int decodeString(String s) {
        int n = 0;
        try {
            switch (s.length()) {
                case 0: {
                    return -1;
                }
                case 1: {
                    return this.convertToScancode(s.charAt(0));
                }
                case 2: {
                    if (s.charAt(0) != '^') break;
                    char c = s.charAt(1);
                    if (Character.isLetter(c)) {
                        c = Character.toUpperCase(c);
                    }
                    if ((n = c - 64) >= 0 && n <= 31) break;
                    if (this.tracer.isOn()) {
                        this.tracer.println("invalid character following ^: " + s.charAt(1));
                    }
                    return -1;
                }
            }
            if (s.charAt(0) == '+') {
                s = s.substring(1, s.length());
            }
            if (((n = Integer.decode(s).intValue()) & 0xFFFF0000) != 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException ne) {
            if (this.tracer.isOn()) {
                this.tracer.println("Numeric error");
            }
            n = -1;
        }
        return n;
    }

    protected abstract int convertToScancode(char var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertElement(int[] virtualScancodes, int[] scancodes) {
        Vector vector = scancodeSeqVector;
        synchronized (vector) {
            boolean found = false;
            int index = 0;
            for (index = 0; index < scancodeSeqVector.size(); ++index) {
                int r = this.doCompaire((int[])scancodeSeqVector.elementAt(index), scancodes);
                if (r > 0) {
                    scancodeSeqVector.insertElementAt(scancodes, index);
                    virScancodeVector.insertElementAt(virtualScancodes, index);
                    found = true;
                    break;
                }
                if (r < 0) continue;
                found = true;
                break;
            }
            if (!found) {
                scancodeSeqVector.addElement(scancodes);
                virScancodeVector.addElement(virtualScancodes);
            }
        }
    }

    private int doCompaire(int[] first, int[] second) {
        int rc = 0;
        int nSize = first.length;
        if (second.length < first.length) {
            nSize = second.length;
        }
        for (int i = 0; i < nSize; ++i) {
            if (first[i] > second[i]) {
                return 1;
            }
            if (first[i] >= second[i]) continue;
            return -1;
        }
        if (first.length > second.length) {
            return 1;
        }
        if (first.length < second.length) {
            return -1;
        }
        return rc;
    }

    public int getDoubleKeyLen() {
        return this.kbdMapDblKeyLength;
    }

    public int getKeyboardMapLen() {
        return this.kbdMapLength;
    }

    public synchronized int[][] lookupDoubleKey(int inChar, int keyEventType) {
        int[] lr;
        Object ret = this.doubleKeyProcessor.getDoubleKeyPosition(inChar) != -1 ? ((lr = this.doubleKeyProcessor.processDoubleKey(inChar, keyEventType)).length == 0 ? new int[0][0] : (Object)new int[][]{lr}) : (Object)new int[][]{{inChar, keyEventType}};
        return ret;
    }

    public synchronized int[][] lookupScancodes(int inChar, int keyEventType) {
        flag = 3;
        if (index >= kbdMapMaxWidth) {
            int[][] sendBuf = new int[kbdMapMaxWidth][2];
            System.arraycopy(inputBuf, 0, sendBuf, 0, kbdMapMaxWidth);
            pHead = 0;
            pTail = this.kbdMapLength;
            index = 0;
            return sendBuf;
        }
        POSKeyboardMap.inputBuf[POSKeyboardMap.index][0] = inChar;
        POSKeyboardMap.inputBuf[POSKeyboardMap.index][1] = keyEventType;
        for (int i = pHead; i < pTail; ++i) {
            if (inChar != this.kbdMap[i][index]) continue;
            pHead = i;
            if (index == this.kbdMap[i].length - 1) {
                flag = 1;
                break;
            }
            for (int j = pHead + 1; j < pTail; ++j) {
                if (inChar == this.kbdMap[j][index]) continue;
                pTail = j;
                break;
            }
            flag = 2;
            break;
        }
        if (flag == 1) {
            int cnt = this.vMap[pHead].length;
            int[][] sendBuf = new int[cnt][2];
            for (int i = 0; i < cnt; ++i) {
                sendBuf[i][0] = this.vMap[pHead][i];
                sendBuf[i][1] = keyEventType;
            }
            if (cnt == 1) {
                sendBuf[0][1] = keyEventType;
            }
            pHead = 0;
            pTail = this.kbdMapLength;
            index = 0;
            return sendBuf;
        }
        if (flag == 3) {
            int[][] sendBuf = new int[index + 1][2];
            System.arraycopy(inputBuf, 0, sendBuf, 0, index + 1);
            pHead = 0;
            pTail = this.kbdMapLength;
            index = 0;
            return sendBuf;
        }
        ++index;
        return new int[0][0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showVector(Vector v, String msg) {
        if (this.tracer.isOn()) {
            this.tracer.println(" vector size: " + v.size());
        }
        Vector vector = v;
        synchronized (vector) {
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                this.showArray((int[])e.nextElement());
            }
        }
    }

    public void showArray(int[] a) {
        String sTmp = "";
        for (int j = 0; j < a.length; ++j) {
            sTmp = sTmp + "0x" + Integer.toHexString(a[j]) + " ";
        }
        if (this.tracer.isOn()) {
            this.tracer.println(sTmp);
        }
    }

    public void showArray(int[][] a2, int length, String msg) {
        if (this.tracer.isOn()) {
            this.tracer.println(msg + " length=" + length + " contains:");
        }
        for (int i = 0; i < length; ++i) {
            this.showArray(a2[i]);
        }
    }

    public void setCapKeyUp(boolean cku) {
        if (this.doubleKeyProcessor != null) {
            this.doubleKeyProcessor.setCapKeyUp(cku);
        }
    }

    private class makeArrayFromVector {
        private int length;
        private int maxWidth = 0;
        private int[][] array2 = new int[0][0];

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        makeArrayFromVector(Vector v) {
            Vector vector = v;
            synchronized (vector) {
                this.length = v.size();
                this.array2 = new int[this.length][];
                for (int i = 0; i < this.length; ++i) {
                    this.array2[i] = (int[])v.elementAt(i);
                    if (this.array2[i].length <= this.maxWidth) continue;
                    this.maxWidth = this.array2[i].length;
                }
            }
        }

        public int getArrayMaxWidth() {
            return this.maxWidth;
        }

        public int getArrayLenght() {
            return this.length;
        }

        public int[][] getArray() {
            return this.array2;
        }
    }
}

