/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.ram;

import com.ibm.jutil.Util;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import com.ibm.posj.HandleException;
import com.ibm.posj.HardTotalsCmd;
import com.ibm.posj.ram.AbstractRamDevice;
import com.ibm.posj.ram.RamDevice;
import com.ibm.posj.util.DevCats;

public class NvRamDevice
extends AbstractRamDevice
implements RamDevice {
    HardTotalsCmd.Factory cmdFactory = null;
    private Tracer tracer = TracerFactory.getInstance().createTracer(((Object)DevCats.HARDTOTALS_DEVCAT).toString(), "NvRamDevice");
    public static final int NVRAM_SYSTEM_SIZE = 1024;

    public NvRamDevice(HardTotalsCmd.Factory cmdFactory) {
        try {
            this.setCmdFactory(cmdFactory);
            this.initRamSize();
            this.restoreFileStructure();
        }
        catch (IllegalArgumentException iarge) {
        }
        catch (IllegalAccessException iacce) {
        }
        catch (UnsupportedOperationException uoe) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected void initRamSize() {
        try {
            HardTotalsCmd.GetHardTotalsInfCmd cmd = this.getCmdFactory().createGetHardTotalsInfCmd();
            cmd.submit();
            this.setUserSize(cmd.getTotalSize() - 1024);
            this.setSystemSize(1024);
            cmd.recycle();
        }
        catch (HandleException handleException) {
            // empty catch block
        }
    }

    protected void writeRamData(int memoryPosition, AbstractRamDevice.RamData ramData) {
        int offset = ramData.getOffset();
        int count = ramData.getCount();
        byte[] buffer = ramData.getData();
        try {
            HardTotalsCmd.WriteHardTotalsDataCmd cmd = this.getCmdFactory().createWriteHardTotalsDataCmd(memoryPosition, count, buffer, 0);
            if (this.tracer.isOn()) {
                this.tracer.println("write memoryPosition-> " + memoryPosition + " count-> " + count + " buffer.size-> " + buffer.length);
                int temp = count;
                if (count > 300) {
                    temp = 300;
                }
                this.tracer.println("<Contents:" + Util.toFormatedHexString((byte[])buffer, (int)0, (int)temp) + "\\Contents>");
            }
            cmd.submit();
            cmd.recycle();
        }
        catch (HandleException he) {
            // empty catch block
        }
    }

    protected void readRamData(int memoryPosition, AbstractRamDevice.RamData ramData) {
        int offset = ramData.getOffset();
        int count = ramData.getCount();
        byte[] buffer = ramData.getData();
        try {
            HardTotalsCmd.ReadHardTotalsDataCmd cmd = this.getCmdFactory().createReadHardTotalsDataCmd(memoryPosition, count, buffer);
            cmd.submit();
            if (this.tracer.isOn()) {
                int tcnt = count > 250 ? 250 : count;
                this.tracer.println("read memoryPosition-> " + memoryPosition + " count-> " + count + " buffer.size-> " + buffer.length);
                this.tracer.println("<Contents:" + Util.toFormatedHexString((byte[])buffer, (int)0, (int)tcnt) + "\\Contents>");
            }
            cmd.recycle();
        }
        catch (HandleException he) {
            // empty catch block
        }
    }

    public void checkStatus() throws UnsupportedOperationException {
        try {
            HardTotalsCmd.GetHardTotalsInfCmd cmd = this.getCmdFactory().createGetHardTotalsInfCmd();
            cmd.submit();
            cmd.recycle();
        }
        catch (HandleException he) {
            throw new UnsupportedOperationException();
        }
    }

    private HardTotalsCmd.Factory getCmdFactory() {
        return this.cmdFactory;
    }

    private void setCmdFactory(HardTotalsCmd.Factory cmdFactory) {
        this.cmdFactory = cmdFactory;
    }
}

