/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.util;

import com.ibm.jutil.Util;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import com.ibm.posj.PosSystem;
import com.ibm.posj.PosSystemManager;
import com.ibm.posj.util.CrcFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class CrcFileManager {
    private static Tracer tracer = TracerFactory.getInstance().createTracer("CrcFileManager");
    private String checkSum;
    private String serialNumber;
    private String fileName;
    private BufferedReader inFile;
    private BufferedWriter outFile;
    private Hashtable bmpStored = new Hashtable();
    public static final String BITMAP_FILE_PROP_NAME = "com.ibm.posj.util.CrcFileLocation";
    private static final String DEFAULT_BITMAP_FILE_LOCATION = "~/.ibmjpos";
    private static final String BITMAP_FILE_NAME = "ibmjposcrc";
    private static final int NUMBER_OF_ELEMENTS = 8;

    public CrcFileManager(String sNumber) {
        tracer.println("CrcFileManager  -> serialNumber" + sNumber);
        if (sNumber != null && sNumber.length() > 1) {
            this.serialNumber = sNumber.trim().replace(' ', '_');
            this.fileName = this.getLocation() + BITMAP_FILE_NAME + sNumber + ".dat";
        } else {
            this.serialNumber = "";
            this.fileName = this.getLocation() + BITMAP_FILE_NAME + ".dat";
        }
        tracer.println("filename " + this.fileName);
        try {
            File f = new File(this.getLocation());
            boolean exist = f.exists();
            if (!exist) {
                tracer.println(this.getLocation() + " does not exist, create it");
                f.mkdir();
            }
            new File(this.fileName).createNewFile();
            this.bmpStored.clear();
        }
        catch (IOException ioe) {
            tracer.println("Could not create the CrcFileManager File \n" + ioe);
        }
        catch (SecurityException se) {
            tracer.println("Could not create the CrcFileManager File \n" + se);
        }
        this.loadFile();
    }

    public boolean hasElement(CrcFile crcFile) {
        if (crcFile == null) {
            return false;
        }
        return this.bmpStored.containsValue(crcFile);
    }

    public boolean hasElementAt(int number, int station) {
        String key = station + "" + number;
        return this.bmpStored.containsKey(key);
    }

    public void addElement(CrcFile crcFile, byte[] ckSum) {
        if (tracer.isOn()) {
            tracer.println("addElement -->" + crcFile);
        }
        if (crcFile == null || ckSum == null) {
            if (tracer.isOn()) {
                tracer.println("element null, not added");
            }
            return;
        }
        this.checkSum = Util.toFormatedHexString((byte[])ckSum);
        String key = crcFile.getStation() + "" + crcFile.getNumber();
        this.bmpStored.put(key, crcFile);
        this.saveFile();
        if (tracer.isOn()) {
            tracer.println("<--addElement ");
        }
    }

    public void removeElement(int number, int station, byte[] ckSum) {
        tracer.println("removeElement");
        if (ckSum == null) {
            tracer.println("element not added");
            return;
        }
        this.checkSum = Util.toFormatedHexString((byte[])ckSum);
        String key = station + "" + number;
        this.bmpStored.remove(key);
        this.saveFile();
        tracer.println(this.toString());
    }

    public boolean isTotalsCrcEqual(byte[] ckSum) {
        return this.checkSum != null && ckSum != null && this.checkSum.equalsIgnoreCase(Util.toFormatedHexString((byte[])ckSum));
    }

    public void reset() {
        this.removeFile();
        this.bmpStored.clear();
    }

    public int getSize() {
        return this.bmpStored.size();
    }

    public Enumeration getElements() {
        return this.bmpStored.elements();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Checksum -");
        sb.append(this.checkSum);
        sb.append("\n");
        sb.append("SerialNumber -");
        sb.append(this.serialNumber);
        sb.append("\n");
        Enumeration crcFiles = this.bmpStored.elements();
        while (crcFiles.hasMoreElements()) {
            sb.append(crcFiles.nextElement().toString()).append("\n");
        }
        return sb.toString();
    }

    public String getLocation() {
        String location;
        PosSystem.Properties prop = PosSystemManager.getInstance().getProperties();
        if (!prop.isLoaded()) {
            prop.loadProperties();
        }
        if ((location = prop.isPropertyDefined(BITMAP_FILE_PROP_NAME) ? prop.getPropertyString(BITMAP_FILE_PROP_NAME) : DEFAULT_BITMAP_FILE_LOCATION).startsWith("~")) {
            location = System.getProperty("user.home") + location.substring(1);
        }
        if (!location.endsWith(File.separator)) {
            location = location + File.separator;
        }
        return location;
    }

    private void loadFile() {
        try {
            String s;
            tracer.println("loadFile->");
            this.inFile = new BufferedReader(new InputStreamReader(new FileInputStream(this.fileName)));
            this.checkSum = this.inFile.readLine();
            while ((s = this.inFile.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(s, ",");
                if (st.countTokens() == 8) {
                    CrcFile crcFile = new CrcFile();
                    while (st.hasMoreTokens()) {
                        String pair = st.nextToken();
                        int index = pair.lastIndexOf("=");
                        if (index == -1) continue;
                        String name = pair.substring(0, index);
                        String value = pair.substring(index + 1);
                        if (name.equals("Number")) {
                            crcFile.setNumber(Integer.parseInt(value));
                            continue;
                        }
                        if (name.equals("Crc")) {
                            crcFile.setCrc(Integer.parseInt(value));
                            continue;
                        }
                        if (name.equals("Station")) {
                            crcFile.setStation(Integer.parseInt(value));
                            continue;
                        }
                        if (name.equals("Width")) {
                            crcFile.setWidth(Integer.parseInt(value));
                            continue;
                        }
                        if (name.equals("Alignment")) {
                            crcFile.setAlignment(Integer.parseInt(value));
                            continue;
                        }
                        if (name.equals("TabAligment")) {
                            crcFile.setTabAlignment(Integer.parseInt(value));
                            continue;
                        }
                        if (name.equals("FileName")) {
                            crcFile.setFileName(value.trim());
                            continue;
                        }
                        if (!name.equals("FileSize")) continue;
                        crcFile.setFileSize(Integer.parseInt(value));
                    }
                    String key = crcFile.getStation() + "" + crcFile.getNumber();
                    this.bmpStored.put(key, crcFile);
                    continue;
                }
                if (!tracer.isOn()) continue;
                tracer.println("line in file does not match the format " + st.toString());
            }
            this.inFile.close();
            if (tracer.isOn()) {
                tracer.println("<--loadFile" + this);
            }
        }
        catch (FileNotFoundException fnf) {
            tracer.println(this.fileName + " not found " + fnf.getCause());
        }
        catch (IOException ioe) {
            tracer.println("IOException while loadinf file " + ioe.getCause());
        }
    }

    private void saveFile() {
        this.removeFile();
        try {
            this.outFile = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.fileName)));
            this.writeLine(this.checkSum);
            Enumeration crcFiles = this.bmpStored.elements();
            while (crcFiles.hasMoreElements()) {
                this.writeLine(crcFiles.nextElement().toString());
            }
            this.outFile.flush();
            this.outFile.close();
        }
        catch (FileNotFoundException fnf) {
            tracer.println(this.fileName + " not found " + fnf);
        }
        catch (IOException ioe) {
            tracer.println("IOError saving file" + ioe.getCause());
        }
    }

    private void writeLine(String s) {
        try {
            this.outFile.write(s, 0, s.length());
            this.outFile.newLine();
        }
        catch (IOException e) {
            tracer.println(" error writing line to file " + e);
        }
    }

    private void removeFile() {
        try {
            new File(this.fileName).delete();
        }
        catch (SecurityException se) {
            tracer.println("Could not delete the " + this.fileName + " \n" + se);
        }
    }
}

