/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.util;

import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import com.ibm.posj.util.DevCat;
import com.ibm.posj.util.DevCats;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import jpos.config.JposEntry;
import jpos.config.JposEntryRegistry;
import jpos.loader.JposServiceLoader;

public class JclHelper {
    private JposEntryRegistry jposEntryRegistry = null;
    private Tracer tracer = TracerFactory.getInstance().createTracer("JclHelper");
    private static JclHelper instance = null;

    JclHelper() {
    }

    public static JclHelper getInstance() {
        if (instance == null) {
            instance = new JclHelper();
            instance.init();
        }
        return instance;
    }

    protected void init() {
        this.jposEntryRegistry = JposServiceLoader.getManager().getEntryRegistry();
    }

    public void reloadRegistry() {
        this.jposEntryRegistry.load();
    }

    public DevCat[] getConfiguredDevCats() {
        JposEntry[] entries = this.getConfiguredJposEntries();
        HashMap<String, DevCat> devCatMap = new HashMap<String, DevCat>();
        for (int i = 0; i < entries.length; ++i) {
            String devCatString = (String)entries[i].getPropertyValue("deviceCategory");
            DevCat devCat = DevCats.getDevCatForName(devCatString);
            if (!devCat.equals(DevCats.UNKNOWN_DEVCAT)) {
                devCatMap.put(((Object)devCat).toString(), devCat);
                continue;
            }
            this.tracer.println("Found UnknowDevCat in JCL");
        }
        DevCat[] devCats = new DevCat[devCatMap.size()];
        Iterator iterator = devCatMap.values().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            devCats[i++] = (DevCat)iterator.next();
        }
        return devCats;
    }

    public DevCat[] getConfiguredDevCats(String devBus) {
        JposEntry[] entries = this.getConfiguredJposEntries();
        HashMap<String, DevCat> devCatMap = new HashMap<String, DevCat>();
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].hasPropertyWithValue((Object)devBus)) continue;
            String devCatString = (String)entries[i].getPropertyValue("deviceCategory");
            DevCat devCat = DevCats.getDevCatForName(devCatString);
            devCatMap.put(((Object)devCat).toString(), devCat);
        }
        DevCat[] devCats = new DevCat[devCatMap.size()];
        Iterator iterator = devCatMap.values().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            devCats[i++] = (DevCat)iterator.next();
        }
        return devCats;
    }

    public String[] getLogicalNames(DevCat devCat) {
        JposEntry[] entries = this.getConfiguredJposEntries();
        ArrayList<String> lNameList = new ArrayList<String>();
        for (int i = 0; i < entries.length; ++i) {
            String devCatString = (String)entries[i].getPropertyValue("deviceCategory");
            if (!DevCats.getDevCatForName(devCatString).equals(devCat)) continue;
            lNameList.add(entries[i].getLogicalName());
        }
        String[] lNames = new String[lNameList.size()];
        for (int i = 0; i < lNameList.size(); ++i) {
            lNames[i] = (String)lNameList.get(i);
        }
        return lNames;
    }

    public String[] getAllConfiguredLogicalNames() {
        JposEntry[] entries = this.getConfiguredJposEntries();
        String[] lNames = new String[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            lNames[i] = entries[i].getLogicalName();
        }
        return lNames;
    }

    public JposEntry[] getConfiguredJposEntries() {
        Enumeration entries = this.jposEntryRegistry.getEntries();
        ArrayList list = new ArrayList();
        while (entries.hasMoreElements()) {
            list.add(entries.nextElement());
        }
        JposEntry[] entryArray = new JposEntry[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            entryArray[i] = (JposEntry)list.get(i);
        }
        return entryArray;
    }

    public JposEntry[] getConfiguredJposEntries(String devBus) {
        JposEntry[] entries = this.getConfiguredJposEntries();
        HashMap<String, JposEntry> jposEntryMap = new HashMap<String, JposEntry>();
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].hasPropertyWithValue((Object)devBus) || !this.isIbmJposEntry(entries[i])) continue;
            jposEntryMap.put(entries[i].getLogicalName(), entries[i]);
        }
        JposEntry[] jposEntries = new JposEntry[jposEntryMap.size()];
        Iterator iterator = jposEntryMap.values().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            jposEntries[i++] = (JposEntry)iterator.next();
        }
        return jposEntries;
    }

    public JposEntry[] getConfiguredJposEntries(String devBus, DevCat devCat) {
        JposEntry[] entries = this.getConfiguredJposEntries();
        HashMap<String, JposEntry> jposEntryMap = new HashMap<String, JposEntry>();
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].hasPropertyWithValue((Object)devBus) || !entries[i].hasPropertyWithValue((Object)((Object)devCat).toString())) continue;
            jposEntryMap.put(entries[i].getLogicalName(), entries[i]);
        }
        JposEntry[] jposEntries = new JposEntry[jposEntryMap.size()];
        Iterator iterator = jposEntryMap.values().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            jposEntries[i++] = (JposEntry)iterator.next();
        }
        return jposEntries;
    }

    public JposEntry getConfiguredJposEntry(String logicalName) {
        return this.jposEntryRegistry.getJposEntry(logicalName);
    }

    public static DevCat getDevCat(JposEntry entry) {
        Object obj = entry.getPropertyValue("deviceCategory");
        return DevCats.getDevCatForName((String)obj);
    }

    private boolean isIbmJposEntry(JposEntry entry) {
        return entry.getPropertyValue("vendorName").equals("IBM");
    }
}

