/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.util;

public class KeylockUtil {
    public static final int DEV_INFO_TYPE_BYTE = 0;
    public static final int DEV_INFO_ID_BYTE = 1;
    public static final int DEV_INFO_FEATURE_BYTE = 2;
    public static final int USB_ADMIN_DEV_ID_POSITION = 4;
    public static final int USB_ADMIN_FEATURES_POSITION = 5;
    public static final int USB_LEGACY_DEV_ID_POSITION = 5;
    public static final int USB_LEGACY_FEATURES_POSITION = 6;

    public static int getRs485KeylockID(byte[] response) {
        if (response.length < 5) {
            return 2910;
        }
        switch (response[1]) {
            case 1: {
                if (response[2] == 17) {
                    return 2916;
                }
            }
            case 2: {
                return 2915;
            }
            case 3: {
                return 2918;
            }
            case 4: {
                return 2917;
            }
            case 12: {
                return 2919;
            }
            case 5: {
                return 2920;
            }
            case 6: {
                if (response[2] == 0) {
                    return 2923;
                }
                return 2921;
            }
            case 11: {
                return 2924;
            }
            case 28: {
                return 2922;
            }
        }
        return 2910;
    }

    public static int getPs2KeylockID(short response) {
        int value = 2910;
        if (response == 1) {
            value = 2912;
        } else if (response == 4) {
            value = 2913;
        } else if (response == 2) {
            value = 2914;
        }
        return value;
    }

    public static int getUsbBootKeylockID(byte[] response) {
        if (response.length <= 5) {
            return 2910;
        }
        byte devId = response[4];
        byte features = response[5];
        switch (devId) {
            case 4: {
                return 2928;
            }
            case 5: {
                return 2929;
            }
            case 11: {
                return 2949;
            }
        }
        return 2910;
    }

    public static int getUsbNonBootKeylockID(byte[] response) {
        if (response.length <= 5) {
            return 2910;
        }
        byte devId = response[4];
        byte features = response[5];
        switch (devId) {
            case 4: {
                return 2944;
            }
            case 5: {
                return 2945;
            }
        }
        return 2910;
    }

    public static int getUsbLegacyKeylockID(byte[] response) {
        if (response.length <= 6) {
            return 2910;
        }
        switch (response[5]) {
            case 1: {
                if (response[6] == 17) {
                    return 2934;
                }
            }
            case 2: {
                return 2933;
            }
            case 3: {
                return 2935;
            }
            case 4: {
                return 2936;
            }
            case 5: {
                return 2937;
            }
            case 12: {
                return 2938;
            }
            case 6: {
                if (response[6] == 11) {
                    return 2939;
                }
                return 2940;
            }
            case 11: {
                return 2951;
            }
        }
        return 2910;
    }

    public static boolean isDBCS(int id) {
        switch (id) {
            case 2914: 
            case 2916: 
            case 2920: 
            case 2921: 
            case 2922: 
            case 2923: 
            case 2924: 
            case 2926: 
            case 2929: 
            case 2931: 
            case 2932: 
            case 2934: 
            case 2937: 
            case 2939: 
            case 2940: 
            case 2945: 
            case 2949: 
            case 2950: 
            case 2951: {
                return true;
            }
        }
        return false;
    }
}

