/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.util;

import java.util.BitSet;

public class PosjUtil {
    public static int toUnsignedInt(byte b) {
        return b & 0xFF;
    }

    public static int toUnsignedInt(short s) {
        return s & 0xFFFF;
    }

    public static void setBitSet(BitSet bs, int pos, boolean value) {
        if (value) {
            bs.set(pos);
        } else {
            bs.clear(pos);
        }
    }

    public static boolean isBitSelected(int value, int pos) {
        int bit = 1;
        if (pos >= 32) {
            throw new IllegalArgumentException("The pos argument must be less than 32");
        }
        return (value & (bit <<= pos)) == bit;
    }

    public static int clearBit(int value, int pos) {
        if (!PosjUtil.isBitSelected(value, pos)) {
            return value;
        }
        int bit = 1;
        if (pos >= 32) {
            throw new IllegalArgumentException("The pos argument must be less than 32");
        }
        return value ^ (bit <<= pos);
    }

    public static int setBit(int value, int pos) {
        int bit = 1;
        if (pos >= 32) {
            throw new IllegalArgumentException("The pos argument must be less than 32");
        }
        return value | (bit <<= pos);
    }

    public static int setByte(int dest, byte value, int pos) {
        if (pos < 0 || pos > 3) {
            throw new IllegalArgumentException("The pos argument must be 0,1,2 or 3");
        }
        int tmp = 0;
        switch (pos) {
            case 0: {
                dest &= 0xFFFFFF;
                tmp = PosjUtil.toUnsignedInt(value) << 24;
                dest |= tmp;
                break;
            }
            case 1: {
                dest &= 0xFF00FFFF;
                tmp = PosjUtil.toUnsignedInt(value) << 16;
                dest |= tmp;
                break;
            }
            case 2: {
                dest &= 0xFFFF00FF;
                tmp = PosjUtil.toUnsignedInt(value) << 8;
                dest |= tmp;
                break;
            }
            case 3: {
                dest &= 0xFFFFFF00;
                dest |= PosjUtil.toUnsignedInt(value);
            }
        }
        return dest;
    }

    public static int convertTo(short highBytes, short lowBytes) {
        int integer = 0;
        integer = PosjUtil.toUnsignedInt(highBytes) << 16;
        return integer |= PosjUtil.toUnsignedInt(lowBytes);
    }
}

