/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.os.windows;

import com.ibm.jusb.os.windows.WindowsControlRequest;
import com.ibm.jusb.os.windows.WindowsIsochronousRequest;
import com.ibm.jusb.os.windows.WindowsPipeRequest;
import com.ibm.jusb.os.windows.WindowsRequest;
import com.ibm.jusb.os.windows.util.WindowsUsbTracerStatic;

class WindowsCompletter {
    WindowsCompletter() {
    }

    private static int completeBulkPipeRequest(WindowsPipeRequest request, byte[] buffer, int status) {
        if (buffer == null) {
            if (WindowsUsbTracerStatic.getInstance().isOn()) {
                WindowsUsbTracerStatic.getInstance().println("[completeBulkPipeRequest]buffer is null (no data received).");
            }
            request.setActualLength(0);
            return status;
        }
        if (request.getLength() < buffer.length && WindowsUsbTracerStatic.getInstance().isOn()) {
            WindowsUsbTracerStatic.getInstance().println("[completeBulkPipeRequest]Actual length " + buffer.length + " greater than requested length " + request.getLength());
        }
        System.arraycopy(buffer, request.getOffset(), request.getData(), 0, buffer.length);
        request.setActualLength(buffer.length);
        return status;
    }

    private static int completeControlPipeRequest(WindowsControlRequest request, byte[] buffer, int status) {
        if (buffer == null) {
            if (WindowsUsbTracerStatic.getInstance().isOn()) {
                WindowsUsbTracerStatic.getInstance().println("[completeCtlPipeRequest]buffer is null (no data received).");
            }
            request.setActualLength(0);
            return status;
        }
        if (request.getLength() < buffer.length && WindowsUsbTracerStatic.getInstance().isOn()) {
            WindowsUsbTracerStatic.getInstance().println("[completeCtlPipeRequest]response " + buffer.length + " greater than requested length " + request.getLength());
        }
        System.arraycopy(buffer, request.getOffset(), request.getData(), 0, buffer.length);
        request.setActualLength(buffer.length);
        return status;
    }

    private static int completeInterruptPipeRequest(WindowsPipeRequest request, byte[] buffer, int status) {
        if (buffer == null) {
            if (WindowsUsbTracerStatic.getInstance().isOn()) {
                WindowsUsbTracerStatic.getInstance().println("[completeIntPipeRequest]buffer is null (no data received).");
            }
            request.setActualLength(0);
            return status;
        }
        if (request.getLength() < buffer.length && WindowsUsbTracerStatic.getInstance().isOn()) {
            WindowsUsbTracerStatic.getInstance().println("[completeIntPipeRequest]response " + buffer.length + " greater than requested length " + request.getLength());
        }
        System.arraycopy(buffer, request.getOffset(), request.getData(), 0, buffer.length);
        request.setActualLength(buffer.length);
        return status;
    }

    private static int completeIsochronousPipeRequest(WindowsPipeRequest request, byte[] buffer, int status) {
        if (buffer == null) {
            if (WindowsUsbTracerStatic.getInstance().isOn()) {
                WindowsUsbTracerStatic.getInstance().println("[completeIsoPipeRequest]buffer is null (no data received).");
            }
            request.setActualLength(0);
            return status;
        }
        if (request.getLength() < buffer.length && WindowsUsbTracerStatic.getInstance().isOn()) {
            WindowsUsbTracerStatic.getInstance().println("[completeIsoPipeRequest]response " + buffer.length + " greater than requested length " + request.getLength());
        }
        System.arraycopy(buffer, request.getOffset(), request.getData(), 0, buffer.length);
        request.setActualLength(buffer.length);
        return status;
    }

    private static int completeIsochronousRequest(WindowsRequest request, byte[] buffer, int status) {
        int ret = WindowsCompletter.destroyIsoBuffer((WindowsIsochronousRequest)request, buffer, status);
        if (WindowsUsbTracerStatic.getInstance().isOn()) {
            WindowsUsbTracerStatic.getInstance().println("[completeIsoRequest]USB Completed");
        }
        return ret;
    }

    private static int completePipeRequest(WindowsPipeRequest request, byte[] buffer, int status) {
        int ret = 0;
        if (WindowsUsbTracerStatic.getInstance().isOn()) {
            WindowsUsbTracerStatic.getInstance().println("[completePipeRequest]Completing URB");
        }
        switch (request.getPipeType()) {
            case 1: {
                ret = WindowsCompletter.completeControlPipeRequest((WindowsControlRequest)request, buffer, status);
                break;
            }
            case 2: {
                ret = WindowsCompletter.completeBulkPipeRequest(request, buffer, status);
                break;
            }
            case 3: {
                ret = WindowsCompletter.completeInterruptPipeRequest(request, buffer, status);
                break;
            }
            case 4: {
                ret = WindowsCompletter.completeIsochronousPipeRequest(request, buffer, status);
                break;
            }
            default: {
                if (WindowsUsbTracerStatic.getInstance().isOn()) {
                    WindowsUsbTracerStatic.getInstance().println("[completePipeRequest]Unknown pipe type :" + request.getType());
                }
                ret = -1;
            }
        }
        if (WindowsUsbTracerStatic.getInstance().isOn()) {
            WindowsUsbTracerStatic.getInstance().println("[completePipeRequest]URB Completed");
        }
        return ret;
    }

    private static int destroyIsoBuffer(WindowsIsochronousRequest request, byte[] buffer, int status) {
        return 0;
    }

    static int completeRequest(WindowsRequest windowsRequest, byte[] buffer, int status) {
        int err = 0;
        switch (windowsRequest.getType()) {
            case 1: {
                err = WindowsCompletter.completePipeRequest((WindowsPipeRequest)windowsRequest, buffer, status);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                err = WindowsCompletter.completeIsochronousRequest(windowsRequest, buffer, status);
                break;
            }
            default: {
                if (WindowsUsbTracerStatic.getInstance().isOn()) {
                    WindowsUsbTracerStatic.getInstance().println("[completeRequest]Unknown Request type: " + windowsRequest.getType());
                }
                err = -1;
            }
        }
        return err;
    }
}

