/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.os.windows;

import com.ibm.jusb.os.windows.JavaxUsb;
import com.ibm.jusb.os.windows.WindowsCompletter;
import com.ibm.jusb.os.windows.WindowsRequest;
import com.ibm.jusb.os.windows.WindowsRequestProxy;
import com.ibm.jusb.os.windows.WindowsSubmitter;
import com.ibm.jusb.os.windows.util.WindowsUsbTracerStatic;
import javax.usb.UsbException;

public class WindowsDeviceProxy
extends WindowsRequestProxy {
    private int fd = 0;
    private String key = null;
    private Runnable proxyRunnable = new Runnable(){

        public void run() {
            WindowsDeviceProxy.this.startRequestPoller();
        }
    };
    private int startError = -1;
    private Object startLock = new Object();
    private Thread thread = null;

    public WindowsDeviceProxy(String k) {
        this.key = k;
        this.fd = JavaxUsb.open_device(this.getKey());
        if (0 > this.fd) {
            this.startCompleted(this.fd);
        }
        this.startCompleted(0);
        try {
            this.start();
        }
        catch (UsbException usbException) {
            // empty catch block
        }
    }

    public void stop() {
        this.fd = -1;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public String getKey() {
        return this.key;
    }

    public boolean isRunning() {
        try {
            return this.thread.isAlive();
        }
        catch (NullPointerException npE) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws UsbException {
        Thread t = new Thread(this.proxyRunnable);
        t.setDaemon(true);
        Object object = this.startLock;
        synchronized (object) {
            t.start();
        }
        if (0 != this.startError) {
            throw new UsbException("Could not connect to USB device : " + JavaxUsb.nativeGetErrorMessage(this.startError));
        }
        this.thread = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCompleted(int error) {
        Object object = this.startLock;
        synchronized (object) {
            this.startError = error;
            this.startLock.notifyAll();
        }
    }

    public void CompleteRequest(WindowsRequest windowsRequest, int status, int ndx) {
        int err = 0;
        byte[] buf = JavaxUsb.getCompleteBuffer(ndx);
        err = WindowsCompletter.completeRequest(windowsRequest, buf, status);
        if (err != 0) {
            windowsRequest.setError(err);
        }
        windowsRequest.setCompleted(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean getMustExit() {
        if (this.fd == -1) return true;
        WindowsDeviceProxy windowsDeviceProxy = this;
        if (!windowsDeviceProxy.thread.interrupted()) return false;
        return true;
    }

    private void startRequestPoller() {
        while (!this.getMustExit()) {
            if (this.isRequestWaiting()) {
                WindowsRequest windowsRequest = this.getReadyRequest();
                if (windowsRequest != null) {
                    if (WindowsUsbTracerStatic.getInstance().isOn()) {
                        WindowsUsbTracerStatic.getInstance().println("[requestPoller]Submitting request #" + windowsRequest.getRequestNumber());
                    }
                    WindowsSubmitter.submitRequest(this.fd, this, windowsRequest);
                }
                if ((windowsRequest = this.getCancelRequest()) == null) continue;
                if (WindowsUsbTracerStatic.getInstance().isOn()) {
                    WindowsUsbTracerStatic.getInstance().println("[requestPoller]Submitting abort request #" + windowsRequest.getRequestNumber());
                }
                WindowsSubmitter.cancelRequest(this.fd, windowsRequest);
                continue;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }
}

