/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.os.windows;

import com.ibm.jusb.UsbIrpImp;
import com.ibm.jusb.os.windows.JavaxUsb;
import com.ibm.jusb.os.windows.WindowsRequest;
import javax.usb.UsbException;

public class WindowsPipeRequest
extends WindowsRequest {
    private UsbIrpImp usbIrpImp = null;
    private int pipeType = 0;
    private byte epAddress = 0;
    private byte[] data = null;
    private int offset = 0;
    private int length = 0;
    private int actualLength = 0;
    private boolean shortPacket = true;
    private int urbAddress = 0;
    public static final int PIPE_CONTROL = 1;
    public static final int PIPE_BULK = 2;
    public static final int PIPE_INTERRUPT = 3;
    public static final int PIPE_ISOCHRONOUS = 4;

    public WindowsPipeRequest(byte type, byte addr) {
        this.setPipeType(type);
        this.setEndpointAddress(addr);
    }

    public int getType() {
        return 1;
    }

    public byte getDirection() {
        return (byte)(0xFFFFFF80 & this.getEndpointAddress());
    }

    public byte[] getData() {
        return this.data;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public boolean getAcceptShortPacket() {
        return this.shortPacket;
    }

    public void setActualLength(int len) {
        this.actualLength = len;
    }

    public UsbIrpImp getUsbIrpImp() {
        return this.usbIrpImp;
    }

    public void setUsbIrpImp(UsbIrpImp irp) {
        this.usbIrpImp = irp;
        this.data = irp.getData();
        this.offset = irp.getOffset();
        this.length = irp.getLength();
        this.shortPacket = irp.getAcceptShortPacket();
    }

    public void setCompleted(boolean c) {
        if (c) {
            this.completeUsbIrp();
        }
        super.setCompleted(c);
    }

    public void completeUsbIrp() {
        if (0 != this.getError()) {
            this.getUsbIrpImp().setUsbException(new UsbException("Error submitting IRP : " + JavaxUsb.nativeGetErrorMessage(this.getError())));
        }
        this.getUsbIrpImp().setActualLength(this.actualLength);
        this.getUsbIrpImp().complete();
    }

    public void setPipeType(byte type) {
        switch (type) {
            case 0: {
                this.pipeType = 1;
                break;
            }
            case 2: {
                this.pipeType = 2;
                break;
            }
            case 3: {
                this.pipeType = 3;
                break;
            }
            case 1: {
                this.pipeType = 4;
                break;
            }
        }
    }

    public void setEndpointAddress(byte addr) {
        this.epAddress = addr;
    }

    public int getPipeType() {
        return this.pipeType;
    }

    public byte getEndpointAddress() {
        return this.epAddress;
    }
}

