/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.os.windows;

import com.ibm.jusb.os.windows.JavaxUsb;
import com.ibm.jusb.os.windows.WindowsControlRequest;
import com.ibm.jusb.os.windows.WindowsDeviceProxy;
import com.ibm.jusb.os.windows.WindowsInterfaceRequest;
import com.ibm.jusb.os.windows.WindowsPipeRequest;
import com.ibm.jusb.os.windows.WindowsRequest;
import com.ibm.jusb.os.windows.WindowsSetConfigurationRequest;
import com.ibm.jusb.os.windows.WindowsSetInterfaceRequest;
import com.ibm.jusb.os.windows.util.WindowsUsbTracerStatic;

class WindowsSubmitter {
    WindowsSubmitter() {
    }

    private static void cancelPipeRequest(int fd, WindowsPipeRequest request) {
        int ret = 0;
        byte urbaddress = request.getEndpointAddress();
        if (WindowsUsbTracerStatic.getInstance().isOn()) {
            WindowsUsbTracerStatic.getInstance().println("[cancelPipeRequest]Canceling URB.");
        }
        if ((ret = JavaxUsb.submitCancelPipeRequest(request.getRequestNumber(), fd, urbaddress)) != 0 && WindowsUsbTracerStatic.getInstance().isOn()) {
            WindowsUsbTracerStatic.getInstance().println("[cancelPipeRequest]Could not unlink urb %#x (error " + ret + ")");
        }
    }

    private static int submitClaimInterfaceRequest(int fd, WindowsInterfaceRequest request, WindowsDeviceProxy proxy) {
        int ret = 0;
        boolean triedDisconnect = false;
        int interfaceNumber = request.getInterfaceNumber();
        ret = JavaxUsb.submitClaimInterfaceRequest(request.getRequestNumber(), fd, interfaceNumber, proxy);
        if (WindowsUsbTracerStatic.getInstance().isOn()) {
            if (ret != 0) {
                WindowsUsbTracerStatic.getInstance().println("[submitClaimIntRequest]Could not claim interface :" + interfaceNumber + "errno : " + ret);
            } else {
                WindowsUsbTracerStatic.getInstance().println("[submitClaimIntRequest]Interface " + interfaceNumber + "claimed");
            }
        }
        return ret;
    }

    private static int submitControlPipeRequest(int fd, WindowsControlRequest request, WindowsDeviceProxy proxy) {
        int ret = 0;
        int offset = request.getOffset();
        int bufferLength = request.getLength();
        byte[] buffer = new byte[bufferLength];
        byte direction = (byte)(0xFFFFFF80 & request.bmRequestType());
        byte type = (byte)(0x60 & request.bmRequestType());
        byte target = (byte)(0x1F & request.bmRequestType());
        System.arraycopy(request.getData(), offset, buffer, 0, bufferLength);
        ret = JavaxUsb.submitControlPipeRequest(request.getRequestNumber(), fd, request.getEndpointAddress(), request, buffer, bufferLength, direction, type, target, request.bRequest(), request.wValue(), request.wIndex(), proxy);
        return ret;
    }

    private static int submitInterruptPipeRequest(int fd, WindowsPipeRequest request, WindowsDeviceProxy proxy) {
        int ret = 0;
        int bufferLength = request.getLength();
        byte[] buffer = new byte[bufferLength];
        System.arraycopy(request.getData(), request.getOffset(), buffer, 0, bufferLength);
        ret = JavaxUsb.submitInterruptPipeRequest(request.getRequestNumber(), fd, request.getEndpointAddress(), request, buffer, bufferLength, proxy);
        return ret;
    }

    private static int submitIsClaimedInterfaceRequest(int fd, WindowsInterfaceRequest request, WindowsDeviceProxy proxy) {
        int ret = 0;
        int interfaceNumber = request.getInterfaceNumber();
        ret = JavaxUsb.submitIsClaimedInterfaceRequest(request.getRequestNumber(), fd, interfaceNumber, proxy);
        return ret;
    }

    private static int submitPipeRequest(int fd, WindowsPipeRequest request, WindowsDeviceProxy proxy) {
        int ret = 0;
        byte endpoint = request.getEndpointAddress();
        WindowsPipeRequest userContext = request;
        switch (request.getPipeType()) {
            case 1: {
                ret = WindowsSubmitter.submitControlPipeRequest(fd, (WindowsControlRequest)request, proxy);
                break;
            }
            case 3: {
                ret = WindowsSubmitter.submitInterruptPipeRequest(fd, request, proxy);
                break;
            }
            default: {
                if (WindowsUsbTracerStatic.getInstance().isOn()) {
                    WindowsUsbTracerStatic.getInstance().println("[submitPipeRequest]Unknown pipe type :" + request.getPipeType());
                }
                ret = -1;
            }
        }
        return ret;
    }

    private static int submitReleaseInterfaceRequest(int fd, WindowsInterfaceRequest request, WindowsDeviceProxy proxy) {
        int ret = 0;
        int interfaceNumber = request.getInterfaceNumber();
        ret = JavaxUsb.submitReleaseInterfaceRequest(request.getRequestNumber(), fd, interfaceNumber, proxy);
        if (WindowsUsbTracerStatic.getInstance().isOn()) {
            if (ret != 0) {
                WindowsUsbTracerStatic.getInstance().println("[submitReleaseIntRequest]Error releasing interface " + interfaceNumber + " errno:" + ret);
            } else {
                WindowsUsbTracerStatic.getInstance().println("[submitClaimIntRequest]Interface " + interfaceNumber + " released");
            }
        }
        return ret;
    }

    private static int submitSetConfigurationRequest(int fd, WindowsSetConfigurationRequest request, WindowsDeviceProxy proxy) {
        int ret = 0;
        ret = JavaxUsb.submitSetConfigurationRequest(request.getRequestNumber(), fd, request.getConfiguration(), proxy);
        return ret;
    }

    private static int submitSetInterfaceRequest(int fd, WindowsSetInterfaceRequest request, WindowsDeviceProxy proxy) {
        int ret = 0;
        ret = JavaxUsb.submitSetInterfaceRequest(request.getRequestNumber(), fd, request.getInterface(), request.getSetting(), proxy);
        return ret;
    }

    static void cancelRequest(int fd, WindowsRequest windowsRequest) {
        switch (windowsRequest.getType()) {
            case 1: {
                WindowsSubmitter.cancelPipeRequest(fd, (WindowsPipeRequest)windowsRequest);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                if (!WindowsUsbTracerStatic.getInstance().isOn()) break;
                WindowsUsbTracerStatic.getInstance().println("[cancelRequest]Unknown Request type: " + windowsRequest.getType());
            }
        }
    }

    static void submitRequest(int fd, WindowsDeviceProxy proxy, WindowsRequest windowsRequest) {
        int err;
        boolean sync = false;
        switch (windowsRequest.getType()) {
            case 1: {
                if (WindowsUsbTracerStatic.getInstance().isOn()) {
                    WindowsUsbTracerStatic.getInstance().println("[submitRequest]Pipe");
                }
                err = WindowsSubmitter.submitPipeRequest(fd, (WindowsPipeRequest)windowsRequest, proxy);
                break;
            }
            case 2: {
                if (WindowsUsbTracerStatic.getInstance().isOn()) {
                    WindowsUsbTracerStatic.getInstance().println("[submitRequest]SetInterface");
                }
                err = WindowsSubmitter.submitSetInterfaceRequest(fd, (WindowsSetInterfaceRequest)windowsRequest, proxy);
                sync = true;
                break;
            }
            case 3: {
                if (WindowsUsbTracerStatic.getInstance().isOn()) {
                    WindowsUsbTracerStatic.getInstance().println("[submitRequest]SetConfiguration");
                }
                err = WindowsSubmitter.submitSetConfigurationRequest(fd, (WindowsSetConfigurationRequest)windowsRequest, proxy);
                sync = true;
                break;
            }
            case 4: {
                if (WindowsUsbTracerStatic.getInstance().isOn()) {
                    WindowsUsbTracerStatic.getInstance().println("[submitRequest]ClaimInterface");
                }
                err = WindowsSubmitter.submitClaimInterfaceRequest(fd, (WindowsInterfaceRequest)windowsRequest, proxy);
                sync = true;
                break;
            }
            case 6: {
                if (WindowsUsbTracerStatic.getInstance().isOn()) {
                    WindowsUsbTracerStatic.getInstance().println("[submitRequest]ReleaseInterface");
                }
                err = WindowsSubmitter.submitReleaseInterfaceRequest(fd, (WindowsInterfaceRequest)windowsRequest, proxy);
                sync = true;
                break;
            }
            case 5: {
                if (WindowsUsbTracerStatic.getInstance().isOn()) {
                    WindowsUsbTracerStatic.getInstance().println("[submitRequest]IsClaimed");
                }
                err = WindowsSubmitter.submitIsClaimedInterfaceRequest(fd, (WindowsInterfaceRequest)windowsRequest, proxy);
                sync = true;
                break;
            }
            default: {
                if (WindowsUsbTracerStatic.getInstance().isOn()) {
                    WindowsUsbTracerStatic.getInstance().println("[submitRequest]Unknown Request type: " + windowsRequest.getType());
                }
                err = -1;
            }
        }
        if (err != 0) {
            windowsRequest.setError(err);
        }
        if (sync || err != 0) {
            windowsRequest.setCompleted(true);
        }
    }
}

