/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.os.windows.util;

import com.ibm.jusb.os.windows.util.WindowsUsbTracerStdOut;
import java.lang.reflect.Constructor;
import javax.usb.UsbHostManager;

public abstract class WindowsUsbTracer {
    int currentLevel = 0;
    public static final String TRACE_MSG_LEVEL = "com.ibm.jusb.os.windows.WindowsUsbTracer.currentLevel";
    public static final String TRACE_IMPLEMENTATION_PROPERTY = "com.ibm.jusb.os.windows.WindowsUsbTracer";
    protected String defaultName;
    protected int defaultLevel;
    public static final String TRACE_CRITICAL_PROPERTY = "TRACE_CRITICAL";
    public static final String TRACE_ERROR_PROPERTY = "TRACE_ERROR";
    public static final String TRACE_WARN_PROPERTY = "TRACE_WARN";
    public static final String TRACE_NOTICE_PROPERTY = "TRACE_NOTICE";
    public static final String TRACE_INFO_PROPERTY = "TRACE_INFO";
    public static final String TRACE_DEBUG_PROPERTY = "TRACE_DEBUG";
    public static final int TRACE_OFF = 0;
    public static final int TRACE_CRITICAL = 100;
    public static final int TRACE_ERROR = 200;
    public static final int TRACE_WARN = 300;
    public static final int TRACE_NOTICE = 400;
    public static final int TRACE_INFO = 500;
    public static final int TRACE_DEBUG = 600;
    static /* synthetic */ Class class$java$lang$String;

    protected WindowsUsbTracer(String name, int level) {
        this.setDefaultName(name);
        this.setDefaultLevel(level);
        try {
            String strLevel = UsbHostManager.getProperties().getProperty(TRACE_MSG_LEVEL);
            strLevel.trim();
            this.currentLevel = WindowsUsbTracer.getIntTraceLevel(strLevel);
        }
        catch (Exception e) {
            this.currentLevel = level;
        }
    }

    public boolean isOn() {
        return this.currentLevel >= 100;
    }

    public void println(String msg) {
        this.print(this.getDefaultName(), this.getDefaultLevel(), msg + "\n");
    }

    public void println(int level, String msg) {
        this.print(this.getDefaultName(), level, msg + "\n");
    }

    public abstract void print(String var1, int var2, String var3);

    public static int getIntTraceLevel(String level) throws Exception {
        if (level.equalsIgnoreCase("TRACE_OFF")) {
            return 0;
        }
        if (TRACE_CRITICAL_PROPERTY.equalsIgnoreCase(level.trim())) {
            return 100;
        }
        if (TRACE_ERROR_PROPERTY.equalsIgnoreCase(level.trim())) {
            return 200;
        }
        if (TRACE_WARN_PROPERTY.equalsIgnoreCase(level.trim())) {
            return 300;
        }
        if (TRACE_NOTICE_PROPERTY.equalsIgnoreCase(level.trim())) {
            return 400;
        }
        if (TRACE_INFO_PROPERTY.equalsIgnoreCase(level.trim())) {
            return 500;
        }
        if (TRACE_DEBUG_PROPERTY.equalsIgnoreCase(level.trim())) {
            return 600;
        }
        throw new Exception("Unknown trace level : " + level);
    }

    public static WindowsUsbTracer getUsbTracer(String name, int level) {
        try {
            Class[] constructorClasses = new Class[]{class$java$lang$String == null ? (class$java$lang$String = WindowsUsbTracer.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE};
            String className = UsbHostManager.getProperties().getProperty(TRACE_IMPLEMENTATION_PROPERTY);
            Constructor<?> classConstructor = Class.forName(className).getConstructor(constructorClasses);
            Object[] constructorObjects = new Object[]{name, new Integer(level)};
            return (WindowsUsbTracer)classConstructor.newInstance(constructorObjects);
        }
        catch (Exception e) {
            return new WindowsUsbTracerStdOut(name, level);
        }
    }

    public void setDefaultName(String name) {
        this.defaultName = name;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public void setDefaultLevel(int level) {
        this.defaultLevel = level;
    }

    public int getDefaultLevel() {
        return this.defaultLevel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

