/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pattern;

import com.ibm.pattern.AbstractPool;
import com.ibm.pattern.Pool;
import com.ibm.pattern.Recyclable;
import com.ibm.pattern.Recycler;

public abstract class RecycleFactory
implements Recycler {
    private Pool pool = new AbstractPool(){

        protected Object createObject() {
            return RecycleFactory.this.createRecyclable();
        }
    };

    public Recyclable takeRecyclable() {
        return (Recyclable)this.getPool().get();
    }

    protected void returnRecyclable(Recyclable recyclable) {
        this.cleanRecyclable(recyclable);
        try {
            this.getPool().put(recyclable);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected abstract Recyclable createRecyclable();

    protected void cleanRecyclable(Recyclable recyclable) {
        recyclable.clean();
    }

    protected Pool getPool() {
        return this.pool;
    }
}

