/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.poskbd;

import com.ibm.pattern.EventListenerHelper;
import com.ibm.poskbd.bus.IBMPosKbdManager;
import com.ibm.poskbd.event.PosKbdEvent;
import com.ibm.poskbd.event.PosKbdListener;
import java.lang.reflect.Method;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public abstract class PosKbdManager {
    public static int[] validKbds = null;
    public static int[] validKbdsByVendor = null;
    public static int[] validKbdsByProduct = null;
    private static PosKbdManager posKbdManager = null;
    private static final String PREFERRED_INSTANCE_KEY = "poskbd.preferred.manager";
    private static final String ADDITIONAL_INSTANCE_KEY = "poskbd.additional.manager";

    public static synchronized PosKbdManager getInstance() {
        if (null == posKbdManager) {
            posKbdManager = PosKbdManager.getPreferredInstance();
        }
        if (null != posKbdManager) {
            return posKbdManager;
        }
        if (null == posKbdManager) {
            PosKbdManager.useAggregatePosKbdManager();
        }
        return posKbdManager;
    }

    public abstract ListIterator getKeyboards();

    public abstract void reinitialize();

    public abstract void addPosKbdListener(PosKbdListener var1);

    public abstract void removePosKbdListener(PosKbdListener var1);

    public static void setValidKeyboards(int[] validId) {
        validKbds = validId;
    }

    public static void setValidKeyboardsByVendorProduct(int[] validVend, int[] validProd) {
        validKbdsByVendor = validVend;
        validKbdsByProduct = validProd;
    }

    protected static void reflectPosKbdManagers(AggregatePosKbdManager manager, String key) {
        PosKbdManager m;
        int i = 1;
        String className = System.getProperties().getProperty(key + "." + i++);
        while (null != className && null != (m = PosKbdManager.createPosKbdManager(className))) {
            manager.addPosKbdManager(m);
            className = System.getProperties().getProperty(key + "." + i++);
        }
    }

    protected static PosKbdManager getPosKbdManager() {
        return posKbdManager;
    }

    private static PosKbdManager getPreferredInstance() {
        String className = System.getProperties().getProperty(PREFERRED_INSTANCE_KEY);
        return PosKbdManager.createPosKbdManager(className);
    }

    private static void useAggregatePosKbdManager() {
        AggregatePosKbdManager manager = new AggregatePosKbdManager();
        posKbdManager = manager;
        PosKbdManager.reflectPosKbdManagers(manager, ADDITIONAL_INSTANCE_KEY);
        manager.addPosKbdManager(IBMPosKbdManager.getInstance());
    }

    private static PosKbdManager createPosKbdManager(String className) {
        try {
            Class<?> c = Class.forName(className);
            Method m = c.getDeclaredMethod("getInstance", new Class[0]);
            return (PosKbdManager)m.invoke(c, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
        catch (Error e) {
            return null;
        }
    }

    public static class PosKbdListenerHelper
    extends EventListenerHelper
    implements PosKbdListener {
        public void keyboardConnected(PosKbdEvent event) {
            this.addTimerTask(new ConnectTask(event));
        }

        public void keyboardDisconnected(PosKbdEvent event) {
            this.addTimerTask(new DisconnectTask(event));
        }

        private class DisconnectTask
        extends EventListenerHelper.HelperTask {
            public DisconnectTask(PosKbdEvent event) {
                super(event);
            }

            public void run() {
                List list = PosKbdListenerHelper.this.getEventListeners();
                for (int i = 0; i < list.size(); ++i) {
                    ((PosKbdListener)list.get(i)).keyboardDisconnected((PosKbdEvent)this.eventObject);
                }
            }
        }

        private class ConnectTask
        extends EventListenerHelper.HelperTask {
            public ConnectTask(PosKbdEvent event) {
                super(event);
            }

            public void run() {
                List list = PosKbdListenerHelper.this.getEventListeners();
                for (int i = 0; i < list.size(); ++i) {
                    ((PosKbdListener)list.get(i)).keyboardConnected((PosKbdEvent)this.eventObject);
                }
            }
        }
    }

    public static class AggregatePosKbdManager
    extends PosKbdManager {
        private PosKbdListenerHelper listenerHelper = new PosKbdListenerHelper();
        private List managers = new Vector();

        public ListIterator getKeyboards() {
            Vector keyboards = new Vector();
            for (int i = 0; i < this.managers.size(); ++i) {
                ListIterator kbds = ((PosKbdManager)this.managers.get(i)).getKeyboards();
                while (kbds.hasNext()) {
                    keyboards.add(kbds.next());
                }
            }
            return keyboards.listIterator();
        }

        public void reinitialize() {
            for (int i = 0; i < this.managers.size(); ++i) {
                ((PosKbdManager)this.managers.get(i)).reinitialize();
            }
        }

        public void addPosKbdListener(PosKbdListener listener) {
            this.listenerHelper.addEventListener(listener);
        }

        public void removePosKbdListener(PosKbdListener listener) {
            this.listenerHelper.removeEventListener(listener);
        }

        public void addPosKbdManager(PosKbdManager manager) {
            manager.addPosKbdListener(this.listenerHelper);
            this.managers.add(manager);
        }

        public void removePosKbdManager(PosKbdManager manager) {
            manager.removePosKbdListener(this.listenerHelper);
            this.managers.remove(manager);
        }
    }
}

