/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Vector;
import jpos.BaseControl;
import jpos.JposConst;
import jpos.JposException;
import jpos.ScaleControl15;
import jpos.events.DataEvent;
import jpos.events.DataListener;
import jpos.events.DirectIOEvent;
import jpos.events.DirectIOListener;
import jpos.events.ErrorEvent;
import jpos.events.ErrorListener;
import jpos.events.OutputCompleteEvent;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;
import jpos.loader.JposServiceConnection;
import jpos.loader.JposServiceLoader;
import jpos.services.EventCallbacks;
import jpos.services.ScaleService12;
import jpos.services.ScaleService13;
import jpos.services.ScaleService14;
import jpos.services.ScaleService15;

public class Scale
implements ScaleControl15,
JposConst {
    protected static final String deviceControlDescription = "JavaPOS Scale Device Control";
    protected static final int deviceControlVersion = 1005000;
    protected static final int deviceVersion12 = 1002000;
    protected static final int deviceVersion13 = 1003000;
    protected static final int deviceVersion14 = 1004000;
    protected static final int deviceVersion15 = 1005000;
    protected JposServiceConnection serviceConnection = null;
    protected int serviceVersion;
    protected ScaleService12 service12 = null;
    protected ScaleService13 service13 = null;
    protected ScaleService14 service14 = null;
    protected ScaleService15 service15 = null;
    protected Vector directIOListeners = new Vector();
    protected Vector dataListeners = new Vector();
    protected Vector errorListeners = new Vector();
    protected Vector statusUpdateListeners = new Vector();

    public boolean getCapDisplay() throws JposException {
        try {
            return this.service12.getCapDisplay();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapDisplayText() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getCapDisplayText();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the ScaleControl13 interface");
    }

    public boolean getCapPriceCalculating() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getCapPriceCalculating();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the ScaleControl13 interface");
    }

    public int getCapPowerReporting() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getCapPowerReporting();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the ScaleControl13 interface");
    }

    public boolean getCapTareWeight() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getCapTareWeight();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the ScaleControl13 interface");
    }

    public boolean getCapZeroScale() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getCapZeroScale();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the ScaleControl13 interface");
    }

    public String getCheckHealthText() throws JposException {
        try {
            return this.service12.getCheckHealthText();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getClaimed() throws JposException {
        try {
            return this.service12.getClaimed();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getDeviceControlDescription() {
        return deviceControlDescription;
    }

    public int getDeviceControlVersion() {
        return 1005000;
    }

    public boolean getDeviceEnabled() throws JposException {
        try {
            return this.service12.getDeviceEnabled();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setDeviceEnabled(boolean deviceEnabled) throws JposException {
        try {
            this.service12.setDeviceEnabled(deviceEnabled);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getDeviceServiceDescription() throws JposException {
        try {
            return this.service12.getDeviceServiceDescription();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getDeviceServiceVersion() throws JposException {
        try {
            return this.service12.getDeviceServiceVersion();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getFreezeEvents() throws JposException {
        try {
            return this.service12.getFreezeEvents();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setFreezeEvents(boolean freezeEvents) throws JposException {
        try {
            this.service12.setFreezeEvents(freezeEvents);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getPhysicalDeviceDescription() throws JposException {
        try {
            return this.service12.getPhysicalDeviceDescription();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getPhysicalDeviceName() throws JposException {
        try {
            return this.service12.getPhysicalDeviceName();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getState() {
        try {
            return this.service12.getState();
        }
        catch (Exception e) {
            return 1;
        }
    }

    public int getMaximumWeight() throws JposException {
        try {
            return this.service12.getMaximumWeight();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getWeightUnit() throws JposException {
        try {
            return this.service12.getWeightUnit();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getAsyncMode() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getAsyncMode();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the ScaleControl13 interface");
    }

    public void setAsyncMode(boolean asyncMode) throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                this.service13.setAsyncMode(asyncMode);
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the ScaleControl13 interface");
        }
    }

    public boolean getAutoDisable() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getAutoDisable();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the ScaleControl13 interface");
    }

    public void setAutoDisable(boolean autoDisable) throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                this.service13.setAutoDisable(autoDisable);
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the ScaleControl13 interface");
        }
    }

    public int getDataCount() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getDataCount();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the ScaleControl13 interface");
    }

    public boolean getDataEventEnabled() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getDataEventEnabled();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the ScaleControl13 interface");
    }

    public void setDataEventEnabled(boolean dataEventEnabled) throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                this.service13.setDataEventEnabled(dataEventEnabled);
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the ScaleControl13 interface");
        }
    }

    public int getMaxDisplayTextChars() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getMaxDisplayTextChars();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the ScaleControl13 interface");
    }

    public long getSalesPrice() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getSalesPrice();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the ScaleControl13 interface");
    }

    public int getTareWeight() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getTareWeight();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the ScaleControl13 interface");
    }

    public void setTareWeight(int tareWeight) throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                this.service13.setTareWeight(tareWeight);
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the ScaleControl13 interface");
        }
    }

    public long getUnitPrice() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getUnitPrice();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the ScaleControl13 interface");
    }

    public void setUnitPrice(long unitPrice) throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                this.service13.setUnitPrice(unitPrice);
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the ScaleControl13 interface");
        }
    }

    public int getPowerNotify() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getPowerNotify();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the ScaleControl13 interface");
    }

    public void setPowerNotify(int powerNotify) throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                this.service13.setPowerNotify(powerNotify);
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the ScaleControl13 interface");
        }
    }

    public int getPowerState() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getPowerState();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the ScaleControl13 interface");
    }

    public void claim(int timeout) throws JposException {
        try {
            this.service12.claim(timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public synchronized void close() throws JposException {
        try {
            this.service12.close();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Service not open", e);
        }
        try {
            try {
                this.serviceConnection.disconnect();
            }
            catch (Exception e) {
                throw new JposException(104, "Unable to free service connection", e);
            }
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.service12 = null;
            this.service13 = null;
            this.service14 = null;
            this.service15 = null;
            throw throwable;
        }
        Object var2_6 = null;
        this.service12 = null;
        this.service13 = null;
        this.service14 = null;
        this.service15 = null;
    }

    public void checkHealth(int level) throws JposException {
        try {
            this.service12.checkHealth(level);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void directIO(int command, int[] data, Object object) throws JposException {
        try {
            this.service12.directIO(command, data, object);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public synchronized void open(String logicalDeviceName) throws JposException {
        if (this.service12 != null) {
            throw new JposException(106, "Device control already open");
        }
        try {
            this.serviceConnection = JposServiceLoader.findService(logicalDeviceName);
            this.serviceConnection.connect();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(104, "Could not connect to service", e);
        }
        try {
            this.service12 = (ScaleService12)((Object)this.serviceConnection.getService());
        }
        catch (Exception e) {
            throw new JposException(104, "Could not get service instance", e);
        }
        try {
            this.serviceVersion = this.service12.getDeviceServiceVersion();
        }
        catch (Exception e) {
            throw new JposException(104, "Could not get service version information", e);
        }
        if (this.serviceVersion >= 1003000) {
            try {
                this.service13 = (ScaleService13)this.service12;
            }
            catch (Exception e) {
                throw new JposException(104, "Service does not fully implement ScaleDevice13 interface", e);
            }
        }
        if (this.serviceVersion >= 1004000) {
            try {
                this.service14 = (ScaleService14)this.service12;
            }
            catch (Exception e) {
                throw new JposException(104, "Service does not fully implement ScaleDevice14 interface", e);
            }
        }
        if (this.serviceVersion >= 1005000) {
            try {
                this.service15 = (ScaleService15)this.service12;
            }
            catch (Exception e) {
                throw new JposException(104, "Service does not fully implement ScaleDevice15 interface", e);
            }
        }
        ScaleCallbacks callbacks = new ScaleCallbacks();
        this.service12.open(logicalDeviceName, callbacks);
    }

    public void release() throws JposException {
        try {
            this.service12.release();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void readWeight(int[] weightData, int timeout) throws JposException {
        try {
            this.service12.readWeight(weightData, timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void clearInput() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                this.service13.clearInput();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the ScaleControl13 interface");
        }
    }

    public void displayText(String data) throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                this.service13.displayText(data);
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the ScaleControl13 interface");
        }
    }

    public void zeroScale() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                this.service13.zeroScale();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the ScaleControl13 interface");
        }
    }

    public void addDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.addElement(l);
        }
    }

    public void removeDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.removeElement(l);
        }
    }

    public void addDataListener(DataListener l) {
        Vector vector = this.dataListeners;
        synchronized (vector) {
            this.dataListeners.addElement(l);
        }
    }

    public void removeDataListener(DataListener l) {
        Vector vector = this.dataListeners;
        synchronized (vector) {
            this.dataListeners.removeElement(l);
        }
    }

    public void addErrorListener(ErrorListener l) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.addElement(l);
        }
    }

    public void removeErrorListener(ErrorListener l) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.removeElement(l);
        }
    }

    public void addStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.addElement(l);
        }
    }

    public void removeStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.removeElement(l);
        }
    }

    protected class ScaleCallbacks
    implements EventCallbacks {
        protected ScaleCallbacks() {
        }

        public BaseControl getEventSource() {
            return Scale.this;
        }

        public void fireDataEvent(DataEvent e) {
            Vector vector = Scale.this.dataListeners;
            synchronized (vector) {
                int x = 0;
                while (x < Scale.this.dataListeners.size()) {
                    ((DataListener)Scale.this.dataListeners.elementAt(x)).dataOccurred(e);
                    ++x;
                }
            }
        }

        public void fireDirectIOEvent(DirectIOEvent e) {
            Vector vector = Scale.this.directIOListeners;
            synchronized (vector) {
                int x = 0;
                while (x < Scale.this.directIOListeners.size()) {
                    ((DirectIOListener)Scale.this.directIOListeners.elementAt(x)).directIOOccurred(e);
                    ++x;
                }
            }
        }

        public void fireErrorEvent(ErrorEvent e) {
            Vector vector = Scale.this.errorListeners;
            synchronized (vector) {
                int x = 0;
                while (x < Scale.this.errorListeners.size()) {
                    ((ErrorListener)Scale.this.errorListeners.elementAt(x)).errorOccurred(e);
                    ++x;
                }
            }
        }

        public void fireOutputCompleteEvent(OutputCompleteEvent e) {
        }

        public void fireStatusUpdateEvent(StatusUpdateEvent e) {
            Vector vector = Scale.this.statusUpdateListeners;
            synchronized (vector) {
                int x = 0;
                while (x < Scale.this.statusUpdateListeners.size()) {
                    ((StatusUpdateListener)Scale.this.statusUpdateListeners.elementAt(x)).statusUpdateOccurred(e);
                    ++x;
                }
            }
        }
    }
}

