/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import jpos.JposTestCase;
import jpos.config.AbstractRegPopulatorTestCase;
import jpos.config.JposEntry;
import jpos.config.JposRegPopulator;
import jpos.config.simple.SimpleRegPopulator;
import jpos.loader.JposServiceLoader;
import jpos.test.JUnitUtility;
import junit.framework.Assert;

public class SimpleRegPopulatorTestCase
extends AbstractRegPopulatorTestCase {
    private JposRegPopulator populator2 = null;
    private JposEntry[] entries = null;
    private Vector entriesVector = null;
    public static final String JCL_CFG_FILE_NAME = JposTestCase.TEST_DATA_PATH + "jcl_cfg_file.cfg";
    public static final int MAX_ENTRIES = 10;
    public static final String LOGICAL_NAME_PROP_NAME = "logicalName";
    public static final String SI_FACTORY_CLASS_PROP_NAME = "factoryClass";
    public static final String SERVICE_CLASS_PROP_NAME = "serviceClass";
    public static final String VENDOR_NAME_PROP_NAME = "vendorName";
    public static final String VENDOR_URL_PROP_NAME = "http://www.vendorURL.com";
    public static final String DEVICE_CATEGORY_PROP_NAME = "POSPrinter";
    public static final String JPOS_VERSION_PROP_NAME = "1.6";
    public static final String PRODUCT_NAME_PROP_NAME = "productName";
    public static final String PRODUCT_DESCRIPTION_PROP_NAME = "productDescription";
    public static final String PRODUCT_URL_PROP_NAME = "http://www.productURL.com";

    public SimpleRegPopulatorTestCase(String string) {
        super(string);
    }

    protected void setUp() throws IOException {
        this.populator = new SimpleRegPopulator();
        this.populator2 = new SimpleRegPopulator();
        this.entriesVector = new Vector();
        this.entries = new JposEntry[10];
        int n = 0;
        while (n < 10) {
            this.entries[n] = this.createJposEntry(LOGICAL_NAME_PROP_NAME + n, SI_FACTORY_CLASS_PROP_NAME, SERVICE_CLASS_PROP_NAME, VENDOR_NAME_PROP_NAME, VENDOR_URL_PROP_NAME, DEVICE_CATEGORY_PROP_NAME, JPOS_VERSION_PROP_NAME, PRODUCT_NAME_PROP_NAME, PRODUCT_DESCRIPTION_PROP_NAME, PRODUCT_URL_PROP_NAME, this.populator);
            this.entriesVector.add(this.entries[n]);
            ++n;
        }
        this.deleteFileIfExists(JCL_CFG_FILE_NAME);
        new File(JCL_CFG_FILE_NAME).createNewFile();
        Assert.assertTrue((String)("Could not create the empty file: " + JCL_CFG_FILE_NAME), (boolean)new File(JCL_CFG_FILE_NAME).exists());
    }

    protected void tearDown() throws IOException {
        this.populator = null;
        this.populator2 = null;
        int n = 0;
        while (n < 10) {
            this.entries[n] = null;
            ++n;
        }
        this.entries = null;
        this.deleteFileIfExists(JCL_CFG_FILE_NAME);
    }

    private void deleteFileIfExists(String string) throws IOException {
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
    }

    public void testRegPopulatorGetUniqueId() {
        Assert.assertTrue((String)"populator.getUniqueId() cannot be null", (this.populator.getUniqueId() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"populator.getUniqueId() cannot be empty string", (!"".equals(this.populator.getUniqueId()) ? 1 : 0) != 0);
    }

    public void testRegPopulatorGetClassName() {
        Assert.assertTrue((String)"populator.getClassName() cannot be null", (this.populator.getClassName() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"populator.getClassName() cannot be empty string", (!"".equals(this.populator.getClassName()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"populator.getClassName() should be jpos.config.simple.SimpleRegPopulator", (boolean)"jpos.config.simple.SimpleRegPopulator".equals(this.populator.getClassName()));
    }

    public void testRegPopulatorSave1() throws Exception {
        Properties properties = new Properties();
        properties.put("jpos.util.tracing", "OFF");
        properties.put("jpos.config.regPopulatorClass", "jpos.config.simple.SimpleRegPopulator");
        properties.put("jpos.config.populatorFile", JCL_CFG_FILE_NAME);
        this.createPropFile(properties);
        JposServiceLoader.getManager().getProperties().loadJposProperties();
        this.populator.load();
        Assert.assertTrue((String)"Should not find any entries here from populatorFile", (!this.populator.getEntries().hasMoreElements() ? 1 : 0) != 0);
        this.populator.save(this.entriesVector.elements());
        File file = new File(JCL_CFG_FILE_NAME);
        Assert.assertTrue((String)(JCL_CFG_FILE_NAME + " was not created after calling populator.save()"), (boolean)file.exists());
        this.populator.load();
        Assert.assertTrue((String)"Should find entries here from populatorFile", (this.populator.getEntries().hasMoreElements() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Entries should equals the entries saved", (boolean)JUnitUtility.isEquals(this.entriesVector.elements(), (Enumeration)this.populator.getEntries()));
        this.populator.save(new Vector().elements());
        file = new File(JCL_CFG_FILE_NAME);
        Assert.assertTrue((String)(JCL_CFG_FILE_NAME + " was not created after calling populator.save()"), (boolean)file.exists());
        this.populator.load();
        Assert.assertTrue((String)"Should find entries here from populatorFile", (!this.populator.getEntries().hasMoreElements() ? 1 : 0) != 0);
        this.restorePropFile();
    }

    public void testRegPopulatorSave2() throws Exception {
        this.populator.save(this.entriesVector.elements(), JCL_CFG_FILE_NAME);
        File file = new File(JCL_CFG_FILE_NAME);
        Assert.assertTrue((String)(JCL_CFG_FILE_NAME + " was not created after calling populator.save()"), (boolean)file.exists());
    }

    public void testRegPopulatorLoad1() throws Exception {
        Properties properties = new Properties();
        properties.put("jpos.util.tracing", "OFF");
        properties.put("jpos.config.regPopulatorClass", "jpos.config.simple.SimpleRegPopulator");
        properties.put("jpos.config.populatorFile", JCL_CFG_FILE_NAME);
        this.createPropFile(properties);
        JposServiceLoader.getManager().getProperties().loadJposProperties();
        this.populator.save(this.entriesVector.elements());
        Assert.assertTrue((String)(JCL_CFG_FILE_NAME + " was not created after calling populator.save()"), (boolean)new File(JCL_CFG_FILE_NAME).exists());
        this.populator.load();
        Assert.assertTrue((String)"Should find entries here from populatorFile", (this.populator.getEntries().hasMoreElements() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Entries should equals the entries saved", (boolean)JUnitUtility.isEquals(this.entriesVector.elements(), (Enumeration)this.populator.getEntries()));
        this.restorePropFile();
    }

    public void testRegPopulatorLoad2() throws Exception {
        this.populator.save(this.entriesVector.elements(), JCL_CFG_FILE_NAME);
        this.populator2.load(JCL_CFG_FILE_NAME);
        Enumeration enumeration = this.populator2.getEntries();
        Assert.assertTrue((String)"Did not load( fileName ) any JposEntry objects", (enumeration != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"JposEntry found are not the ones saved", (boolean)JUnitUtility.isEquals(this.entriesVector.elements(), (Enumeration)enumeration));
    }

    public void testGetEntriesURL() throws Exception {
        this.populator2.load();
        URL uRL = this.populator2.getEntriesURL();
    }

    public void testGetName() {
        this.populator2.load();
        Assert.assertEquals((Object)"JCL Serialized Entries Populator", (Object)this.populator2.getName());
    }

    public void testGetLastLoadException() {
        this.emptyTest();
    }
}

