/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple.xml;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import jpos.JposTestCase;
import jpos.config.AbstractRegPopulatorTestCase;
import jpos.config.JposEntry;
import jpos.config.simple.SimpleEntry;
import jpos.config.simple.xml.XercesRegPopulator;
import jpos.test.JUnitUtility;
import junit.framework.Assert;

public class XercesRegPopulatorTestCase
extends AbstractRegPopulatorTestCase {
    private XercesRegPopulator xercesRegPopulator = null;
    public static final String JUNIT_CORP_STRING = "JUnit Corp.";
    public static final String JCL_JUNIT_XML_FILE_NAME = JposTestCase.TEST_DATA_PATH + "jcl-junit.xml";
    public static final String DEFECT_6562_XML_FILE = "defect6562.xml";
    public static final String JCL_JUNIT_TEST_PROP_TYPE_XML_FILE = "jcl_junit_test_prop_type.xml";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    public XercesRegPopulatorTestCase(String string) {
        super(string);
    }

    protected void setUp() {
        this.xercesRegPopulator = new XercesRegPopulator();
        try {
            File file = new File(JCL_JUNIT_XML_FILE_NAME);
            file.delete();
        }
        catch (SecurityException securityException) {
            this.println("Could not delete XML test file: " + JCL_JUNIT_XML_FILE_NAME);
            this.println("   Exception message = " + securityException.getMessage());
        }
        this.addToClasspath(JposTestCase.TEST_DATA_PATH);
    }

    protected void tearDown() {
        this.xercesRegPopulator = null;
    }

    private JposEntry createJposEntry(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        SimpleEntry simpleEntry = new SimpleEntry();
        simpleEntry.addProperty("logicalName", string);
        simpleEntry.addProperty("serviceInstanceFactoryClass", string2);
        simpleEntry.addProperty("serviceClass", string3);
        simpleEntry.addProperty("vendorName", string4);
        simpleEntry.addProperty("vendorURL", string5);
        simpleEntry.addProperty("deviceCategory", string6);
        simpleEntry.addProperty("jposVersion", string7);
        simpleEntry.addProperty("productName", string8);
        simpleEntry.addProperty("productDescription", string9);
        simpleEntry.addProperty("productURL", string10);
        return simpleEntry;
    }

    private Enumeration searchEntriesForVendorName(Enumeration enumeration, String string) {
        Vector<JposEntry> vector = new Vector<JposEntry>();
        while (enumeration.hasMoreElements()) {
            JposEntry jposEntry = (JposEntry)enumeration.nextElement();
            if (!jposEntry.hasPropertyWithName("vendorName") || !jposEntry.getPropertyValue("vendorName").toString().equals(JUNIT_CORP_STRING)) continue;
            vector.addElement(jposEntry);
        }
        return vector.elements();
    }

    public void testXercesPopulator1() {
        Enumeration enumeration;
        Object object;
        Vector<Object> vector = new Vector<Object>();
        try {
            this.xercesRegPopulator.save(vector.elements(), JCL_JUNIT_XML_FILE_NAME);
            this.xercesRegPopulator.load(JCL_JUNIT_XML_FILE_NAME);
            object = this.xercesRegPopulator.getEntries();
            Assert.assertTrue((String)"Expected an empty set of entries...", (boolean)JUnitUtility.isIdentical((Enumeration)object, vector.elements()));
            Assert.assertTrue((String)"Expected an empty set of entries...", (boolean)JUnitUtility.isEquals((Enumeration)object, vector.elements()));
        }
        catch (Exception exception) {
            Assert.fail((String)("Got unexpected Exception from XercesRegPopulator.save method with message = " + exception.getMessage()));
        }
        object = this.createJposEntry("entry1", "com.xyz.jpos.XyzJposServiceInstanceFactory", "com.xyz.jpos.LineDisplayService", "Xyz, Corp.", "http://www.javapos.com", "LineDisplay", "1.4a", "Virtual LineDisplay JavaPOS Service", "Example virtual LineDisplay JavaPOS Service from virtual Xyz Corporation", "http://www.javapos.com");
        JposEntry jposEntry = this.createJposEntry("entry2", "com.xyz.jpos.XyzJposServiceInstanceFactory", "com.xyz.jpos.LineDisplayService", "Xyz, Corp.", "http://www.javapos.com", "LineDisplay", "1.4a", "Virtual LineDisplay JavaPOS Service", "Example virtual LineDisplay JavaPOS Service from virtual Xyz Corporation", "http://www.javapos.com");
        try {
            vector.clear();
            vector.addElement(object);
            vector.addElement(jposEntry);
            this.xercesRegPopulator.save(vector.elements(), JCL_JUNIT_XML_FILE_NAME);
            this.xercesRegPopulator.load(JCL_JUNIT_XML_FILE_NAME);
            enumeration = this.xercesRegPopulator.getEntries();
            Assert.assertTrue((String)"Expected 2 entries...", (boolean)JUnitUtility.isEquals((Enumeration)enumeration, vector.elements()));
        }
        catch (Exception exception) {
            Assert.assertTrue((String)("Got unexpected Exception from XercesRegPopulator.save method with message = " + exception.getMessage()), (boolean)true);
        }
        vector.remove(object);
        try {
            this.xercesRegPopulator.save(vector.elements(), JCL_JUNIT_XML_FILE_NAME);
            this.xercesRegPopulator.load(JCL_JUNIT_XML_FILE_NAME);
            enumeration = this.xercesRegPopulator.getEntries();
            Assert.assertTrue((String)"Expected 1 entries...", (boolean)JUnitUtility.isEquals((Enumeration)enumeration, vector.elements()));
        }
        catch (Exception exception) {
            Assert.assertTrue((String)("Got unexpected Exception from XercesRegPopulator.save method with message = " + exception.getMessage()), (boolean)true);
        }
    }

    public void testXercesPopulator2() {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < 100) {
            object = this.createJposEntry("entry" + n, "com.xyz.jpos.XyzJposServiceInstanceFactory", "com.xyz.jpos.LineDisplayService", "Xyz, Corp.", "http://www.javapos.com", "LineDisplay", "1.4a", "Virtual LineDisplay JavaPOS Service", "Example virtual LineDisplay JavaPOS Service from virtual Xyz Corporation", "http://www.javapos.com");
            vector.addElement(object);
            ++n;
        }
        try {
            this.xercesRegPopulator.save(vector.elements(), JCL_JUNIT_XML_FILE_NAME);
            this.xercesRegPopulator.load(JCL_JUNIT_XML_FILE_NAME);
            object = this.xercesRegPopulator.getEntries();
            Assert.assertTrue((String)"Expected 100 entries...", (boolean)JUnitUtility.isEquals((Enumeration)object, vector.elements()));
        }
        catch (Exception exception) {
            Assert.fail((String)("Got unexpected Exception from XercesRegPopulator.save method with message = " + exception.getMessage()));
        }
    }

    public void testGetName() {
        this.xercesRegPopulator.load(JCL_JUNIT_XML_FILE_NAME);
        Assert.assertEquals((Object)"JCL XML Entries Populator", (Object)this.xercesRegPopulator.getName());
    }

    public void testLoad1() {
        try {
            Assert.assertTrue((String)("Expected file: " + JposTestCase.TEST_DATA_PATH + DEFECT_6562_XML_FILE + " to exist"), (boolean)new File(JposTestCase.TEST_DATA_PATH + DEFECT_6562_XML_FILE).exists());
            this.xercesRegPopulator.load(DEFECT_6562_XML_FILE);
            Enumeration enumeration = this.xercesRegPopulator.getEntries();
            JposEntry jposEntry = (JposEntry)enumeration.nextElement();
            Assert.assertTrue((String)"defect6562Entry == null", (jposEntry != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"defect6562Entry.logicalName != defect6562", (boolean)jposEntry.getLogicalName().equals("defect6562"));
        }
        catch (Exception exception) {
            Assert.fail((String)("Unexpected exception.message = " + exception.getMessage()));
        }
    }

    public void testLoadwithPropType() {
        try {
            Assert.assertTrue((String)("Expected file: " + JposTestCase.TEST_DATA_PATH + JCL_JUNIT_TEST_PROP_TYPE_XML_FILE + " to exist"), (boolean)new File(JposTestCase.TEST_DATA_PATH + JCL_JUNIT_TEST_PROP_TYPE_XML_FILE).exists());
            this.xercesRegPopulator.load(JCL_JUNIT_TEST_PROP_TYPE_XML_FILE);
            Enumeration enumeration = this.xercesRegPopulator.getEntries();
            JposEntry jposEntry = (JposEntry)enumeration.nextElement();
            Assert.assertTrue((String)"testPropTypeEntry == null", (jposEntry != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"testPropTypeEntry.logicalName != testPropType", (boolean)jposEntry.getLogicalName().equals("testPropType"));
            Assert.assertTrue((String)"testPropTypeEntry.getProp( \"stringProp\" ).getType() != String.class", (boolean)jposEntry.getProp("stringProp").getType().equals(class$java$lang$String == null ? (class$java$lang$String = XercesRegPopulatorTestCase.class$("java.lang.String")) : class$java$lang$String));
            Assert.assertTrue((String)"testPropTypeEntry.getProp( \"booleanProp\" ).getType() != Boolean.class", (boolean)jposEntry.getProp("booleanProp").getType().equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = XercesRegPopulatorTestCase.class$("java.lang.Boolean")) : class$java$lang$Boolean));
            Assert.assertTrue((String)"testPropTypeEntry.getProp( \"byteProp\" ).getType() != Byte.class", (boolean)jposEntry.getProp("byteProp").getType().equals(class$java$lang$Byte == null ? (class$java$lang$Byte = XercesRegPopulatorTestCase.class$("java.lang.Byte")) : class$java$lang$Byte));
            Assert.assertTrue((String)"testPropTypeEntry.getProp( \"characterProp\" ).getType() != Character.class", (boolean)jposEntry.getProp("characterProp").getType().equals(class$java$lang$Character == null ? (class$java$lang$Character = XercesRegPopulatorTestCase.class$("java.lang.Character")) : class$java$lang$Character));
            Assert.assertTrue((String)"testPropTypeEntry.getProp( \"doubleProp\" ).getType() != Double.class", (boolean)jposEntry.getProp("doubleProp").getType().equals(class$java$lang$Double == null ? (class$java$lang$Double = XercesRegPopulatorTestCase.class$("java.lang.Double")) : class$java$lang$Double));
            Assert.assertTrue((String)"testPropTypeEntry.getProp( \"floatProp\" ).getType() != Float.class", (boolean)jposEntry.getProp("floatProp").getType().equals(class$java$lang$Float == null ? (class$java$lang$Float = XercesRegPopulatorTestCase.class$("java.lang.Float")) : class$java$lang$Float));
            Assert.assertTrue((String)"testPropTypeEntry.getProp( \"integerProp\" ).getType() != Integer.class", (boolean)jposEntry.getProp("integerProp").getType().equals(class$java$lang$Integer == null ? (class$java$lang$Integer = XercesRegPopulatorTestCase.class$("java.lang.Integer")) : class$java$lang$Integer));
            Assert.assertTrue((String)"testPropTypeEntry.getProp( \"longProp\" ).getType() != Long.class", (boolean)jposEntry.getProp("longProp").getType().equals(class$java$lang$Long == null ? (class$java$lang$Long = XercesRegPopulatorTestCase.class$("java.lang.Long")) : class$java$lang$Long));
            Assert.assertTrue((String)"testPropTypeEntry.getProp( \"shortProp\" ).getType() != Short.class", (boolean)jposEntry.getProp("shortProp").getType().equals(class$java$lang$Short == null ? (class$java$lang$Short = XercesRegPopulatorTestCase.class$("java.lang.Short")) : class$java$lang$Short));
        }
        catch (Exception exception) {
            Assert.fail((String)("Unexpected exception.message = " + exception.getMessage()));
        }
    }

    public void testSaveWithPropType() {
        this.emptyTest();
    }

    public void testGetLastLoadException() {
        this.emptyTest();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

