/*
 * Decompiled with CFR 0.152.
 */
package jpos.loader.simple;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.config.JposEntryRegistry;
import jpos.loader.AbstractTestCase;
import jpos.loader.JposServiceConnection;
import jpos.loader.JposServiceInstance;
import jpos.loader.JposServiceLoader;
import jpos.loader.JposServiceManager;
import jpos.test.JUnitUtility;
import junit.framework.Assert;

public class SimpleServiceConnectionTestCase
extends AbstractTestCase {
    private JposServiceManager manager = null;
    private JposEntryRegistry registry = null;
    public static final String XYZ_SERVICE_CLASS = "com.xyz.jpos.LineDisplayService";
    public static final String XYZ_FACTORY_CLASS = "com.xyz.jpos.XyzJposServiceInstanceFactory";

    public SimpleServiceConnectionTestCase(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.manager = JposServiceLoader.getManager();
        this.manager.reloadEntryRegistry();
        this.registry = this.manager.getEntryRegistry();
    }

    protected void tearDown() throws Exception {
        this.manager = null;
        this.registry = null;
        super.tearDown();
    }

    protected boolean useSimpleProfile() {
        return false;
    }

    protected JposEntry createDefaultJposEntry(String string) {
        return this.createJposEntry(string, XYZ_FACTORY_CLASS, XYZ_SERVICE_CLASS, "Xyz, Corp.", "http://www.javapos.com", "LineDisplay", "1.5", "Virtual LineDisplay JavaPOS Service", "Example virtual LineDisplay JavaPOS Service from virtual Xyz Corporation", "http://www.javapos.com", null);
    }

    public void testGetService() throws JposException, ClassNotFoundException {
        Enumeration enumeration = this.registry.getEntries();
        while (enumeration.hasMoreElements()) {
            JposEntry jposEntry = (JposEntry)enumeration.nextElement();
            JposServiceConnection jposServiceConnection = this.manager.createConnection(jposEntry.getLogicalName());
            JposServiceInstance jposServiceInstance = jposServiceConnection.getService();
            Assert.assertTrue((String)"connection.getService() should be null since no connection.connect() call was made", (jposServiceInstance == null ? 1 : 0) != 0);
            jposServiceConnection.connect();
            jposServiceInstance = jposServiceConnection.getService();
            Assert.assertTrue((String)"connection.getService() returned null after successful connection.connect() call", (jposServiceInstance != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"connection.getService() should be instanceof com.xyz.jpos.LineDisplayService", (boolean)Class.forName(XYZ_SERVICE_CLASS).isInstance(jposServiceInstance));
            jposServiceConnection.disconnect();
        }
    }

    public void testGetLogicalName() throws JposException {
        Iterator iterator = this.logicalNames(JUnitUtility.createVector((Enumeration)this.registry.getEntries()).iterator()).iterator();
        Iterator iterator2 = this.logicalNames(this.getEntriesList()).iterator();
        Assert.assertTrue((String)"All logicalName in registry should match added entries logicalNames", (boolean)JUnitUtility.isEquals(iterator, iterator2));
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = this.registry.getEntries();
        while (enumeration.hasMoreElements()) {
            JposEntry jposEntry = (JposEntry)enumeration.nextElement();
            JposServiceConnection jposServiceConnection = this.manager.createConnection(jposEntry.getLogicalName());
            arrayList.add(jposServiceConnection.getLogicalName());
        }
        Assert.assertTrue((String)"All logicalName in registry should match added entries logicalNames", (boolean)JUnitUtility.isEquals(arrayList, (List)this.logicalNames(this.getEntriesList())));
    }

    public void testConnect() throws JposException {
        Enumeration enumeration = this.registry.getEntries();
        while (enumeration.hasMoreElements()) {
            JposEntry jposEntry = (JposEntry)enumeration.nextElement();
            JposServiceConnection jposServiceConnection = this.manager.createConnection(jposEntry.getLogicalName());
            jposServiceConnection.connect();
        }
    }

    public void testDisconnect() throws JposException {
        Enumeration enumeration = this.registry.getEntries();
        while (enumeration.hasMoreElements()) {
            JposEntry jposEntry = (JposEntry)enumeration.nextElement();
            JposServiceConnection jposServiceConnection = this.manager.createConnection(jposEntry.getLogicalName());
            jposServiceConnection.connect();
            jposServiceConnection.disconnect();
        }
    }
}

