/*
 * Decompiled with CFR 0.152.
 */
package jpos.profile;

import java.util.Vector;
import jpos.JposTestCase;
import jpos.profile.DefaultProfile;
import jpos.profile.DefaultPropInfo;
import jpos.profile.DefaultPropInfoList;
import jpos.profile.Profile;
import jpos.profile.PropInfo;
import jpos.profile.PropInfoList;
import jpos.test.JUnitUtility;
import junit.framework.Assert;

public class PropInfoListTestCase
extends JposTestCase {
    private Profile profile = null;
    private PropInfoList list = null;
    private PropInfo propInfo0 = null;
    private PropInfo propInfo1 = null;
    private PropInfo propInfo2 = null;

    public PropInfoListTestCase(String string) {
        super(string);
    }

    protected void setUp() {
        this.profile = new DefaultProfile("JUnit");
        this.list = new DefaultPropInfoList();
        this.propInfo0 = new DefaultPropInfo("propInfo0", this.profile);
        this.propInfo1 = new DefaultPropInfo("propInfo1", this.profile);
        this.propInfo2 = new DefaultPropInfo("propInfo2", this.profile);
    }

    protected void tearDown() {
        this.list = null;
    }

    public void testPropInfoList1() {
        Assert.assertTrue((String)"Expects PropInfoList to be of size 0", (this.list.getSize() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expects PropInfoList to be of size 0 and empty", (boolean)this.list.isEmpty());
        this.list.add(this.propInfo0);
        this.list.add(this.propInfo1);
        this.list.add(this.propInfo2);
        Assert.assertTrue((String)"Expects PropInfoList to be of size 3", (this.list.getSize() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expects PropInfoList to be of size 3 thus NOT empty", (!this.list.isEmpty() ? 1 : 0) != 0);
        this.list.remove(this.propInfo1);
        Assert.assertTrue((String)"Expects PropInfoList to be of size 2", (this.list.getSize() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expects list to have propInfo0", (boolean)this.list.contains(this.propInfo0));
        Assert.assertTrue((String)"Expects list to NOT have propInfo1", (!this.list.contains(this.propInfo1) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expects list to have propInfo2", (boolean)this.list.contains(this.propInfo2));
        this.list.removeAll();
        Assert.assertTrue((String)"Expects PropInfoList to be of size 0", (this.list.getSize() == 0 ? 1 : 0) != 0);
    }

    public void testPropInfoList2() {
        Assert.assertTrue((String)"Expects PropInfoList to be of size 0", (this.list.getSize() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expects PropInfoList to be of size 0 and empty", (boolean)this.list.isEmpty());
        this.list.add(this.propInfo0);
        this.list.add(this.propInfo1);
        this.list.add(this.propInfo2);
        Vector<PropInfo> vector = new Vector<PropInfo>();
        vector.add(this.propInfo0);
        vector.add(this.propInfo1);
        vector.add(this.propInfo2);
        Assert.assertTrue((String)"Expects PropInfoList to be of size 3", (this.list.getSize() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expects PropInfoList to be of size 3 thus NOT empty", (!this.list.isEmpty() ? 1 : 0) != 0);
        PropInfoList.Iterator iterator = this.list.iterator();
        Vector<PropInfo> vector2 = new Vector<PropInfo>();
        while (iterator.hasNext()) {
            vector2.add(iterator.next());
        }
        Assert.assertTrue((String)"Expects the PropInfoList.Iterator contents is <propInfo0, propInfo1, propInfo2>", (boolean)JUnitUtility.isEquals(vector, vector2));
        Assert.assertTrue((String)"Expects the PropInfoList.Iterator contents to be identical as <propInfo0, propInfo1, propInfo2>", (boolean)JUnitUtility.isIdentical(vector, vector2));
        this.list.remove(this.propInfo0);
        vector.remove(this.propInfo0);
        iterator = this.list.iterator();
        vector2.clear();
        while (iterator.hasNext()) {
            vector2.add(iterator.next());
        }
        Assert.assertTrue((String)"Expects the PropInfoList.Iterator contents is <propInfo0, propInfo1, propInfo2>", (boolean)JUnitUtility.isEquals(vector, vector2));
        Assert.assertTrue((String)"Expects the PropInfoList.Iterator contents to be identical as <propInfo0, propInfo1, propInfo2>", (boolean)JUnitUtility.isIdentical(vector, vector2));
        this.list.remove(this.propInfo2);
        vector.remove(this.propInfo2);
        iterator = this.list.iterator();
        vector2.clear();
        while (iterator.hasNext()) {
            vector2.add(iterator.next());
        }
        Assert.assertTrue((String)"Expects the PropInfoList.Iterator contents is <propInfo0, propInfo1, propInfo2>", (boolean)JUnitUtility.isEquals(vector, vector2));
        Assert.assertTrue((String)"Expects the PropInfoList.Iterator contents to be identical as <propInfo0, propInfo1, propInfo2>", (boolean)JUnitUtility.isIdentical(vector, vector2));
        this.list.removeAll();
        vector.clear();
        iterator = this.list.iterator();
        vector2.clear();
        while (iterator.hasNext()) {
            vector2.add(iterator.next());
        }
        Assert.assertTrue((String)"Expects the PropInfoList.Iterator contents is <propInfo0, propInfo1, propInfo2>", (boolean)JUnitUtility.isEquals(vector, vector2));
        Assert.assertTrue((String)"Expects the PropInfoList.Iterator contents to be identical as <propInfo0, propInfo1, propInfo2>", (boolean)JUnitUtility.isIdentical(vector, vector2));
    }
}

