/*
 * Decompiled with CFR 0.152.
 */
package jpos.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import jpos.JposTestCase;
import jpos.test.JUnitUtility;
import jpos.util.DefaultProperties;
import jpos.util.JposProperties;
import junit.framework.Assert;

public class JposPropertiesTestCase
extends JposTestCase {
    private DefaultProperties properties = null;
    public static final String JPOS_JUNIT_PROPERTIES_FILE_NAME = "jpos" + File.separator + "res" + File.separator + "jpos_junit.properties";
    public static final String MULTI_PROP_BASE_NAME = "multiProp";
    public static int MULTI_PROP_MAX_NUMBER = 5;

    public JposPropertiesTestCase(String string) {
        super(string);
    }

    protected void setUp() {
        this.properties = new DefaultProperties();
    }

    protected void tearDown() {
        this.properties = null;
    }

    private void verifyPropFileExist() throws IOException {
        File file = new File(JPOS_JUNIT_PROPERTIES_FILE_NAME);
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(JPOS_JUNIT_PROPERTIES_FILE_NAME);
        if (!file.exists() && inputStream == null) {
            throw new IOException("JUnit properties file: " + JPOS_JUNIT_PROPERTIES_FILE_NAME + " does not exist!");
        }
    }

    public void testIsLoadedAndGetLastException() {
        Assert.assertTrue((String)"Newly created properties should not be loaded", (!this.properties.isLoaded() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Newly created properties getLastException() should be null", (this.properties.getLastException() == null ? 1 : 0) != 0);
        this.properties.loadJposPropertiesByName(JPOS_JUNIT_PROPERTIES_FILE_NAME);
        Assert.assertTrue((String)"Loaded properties isLoaded() should return true", (this.properties.isLoaded() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Loaded properties getLastException() should be null", (this.properties.getLastException() == null ? 1 : 0) != 0);
    }

    public void testFindProperties() throws IOException {
        this.verifyPropFileExist();
        Properties properties = this.properties.findProperties(JPOS_JUNIT_PROPERTIES_FILE_NAME);
        Assert.assertTrue((String)"properties.findProperties( ... ) returned null Properties object", (properties != null ? 1 : 0) != 0);
    }

    public void testLoadJposProperties() {
        Assert.assertTrue((String)"Newly created properties should not be loaded", (!this.properties.isLoaded() ? 1 : 0) != 0);
        this.properties.loadJposPropertiesByName(JPOS_JUNIT_PROPERTIES_FILE_NAME);
        Assert.assertTrue((String)"Loaded properties isLoaded() should return true", (this.properties.isLoaded() ? 1 : 0) != 0);
    }

    public void testGetPropertyString() {
        this.properties.loadJposPropertiesByName(JPOS_JUNIT_PROPERTIES_FILE_NAME);
        Assert.assertTrue((String)"All JposProperties should contain property \"jpos.loader.serviceManagerClass\"", (this.properties.getPropertyString("jpos.loader.serviceManagerClass") != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"All JposProperties should contain property \"jpos.util.tracing\"", (this.properties.getPropertyString("jpos.util.tracing") != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"JposProperties should NOT contain property \"__this.is.a.fake.property_name__\"", (this.properties.getPropertyString("__this.is.a.fake.property_name__") == null ? 1 : 0) != 0);
    }

    public void testIsPropertyDefined() {
        this.properties.loadJposPropertiesByName(JPOS_JUNIT_PROPERTIES_FILE_NAME);
        Assert.assertTrue((String)"All JposProperties should contain property \"jpos.loader.serviceManagerClass\"", (this.properties.isPropertyDefined("jpos.loader.serviceManagerClass") ? 1 : 0) != 0);
        Assert.assertTrue((String)"All JposProperties should contain property \"jpos.util.tracing\"", (this.properties.isPropertyDefined("jpos.util.tracing") ? 1 : 0) != 0);
        Assert.assertTrue((String)"JposProperties should NOT contain property \"__this.is.a.fake.property_name__\"", (!this.properties.isPropertyDefined("__this.is.a.fake.property_name__") ? 1 : 0) != 0);
    }

    public void testGetPropertyNames() {
        this.properties.loadJposPropertiesByName(JPOS_JUNIT_PROPERTIES_FILE_NAME);
        Enumeration enumeration = this.properties.getPropertyNames();
        Assert.assertTrue((String)"All JposProperties should contain some properties", (enumeration.hasMoreElements() ? 1 : 0) != 0);
    }

    public void testGetMultiProperty() {
        this.properties.loadJposPropertiesByName(JPOS_JUNIT_PROPERTIES_FILE_NAME);
        JposProperties.MultiProperty multiProperty = this.properties.getMultiProperty(MULTI_PROP_BASE_NAME);
        Assert.assertTrue((String)"Should contain a multiproperty with name = multiProp", (multiProperty != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should contain a multiproperty with name = multiProp", (boolean)multiProperty.getBasePropertyName().equals(MULTI_PROP_BASE_NAME));
        int n = 0;
        while (n < MULTI_PROP_MAX_NUMBER) {
            String string = "multiProp." + n;
            String string2 = string + ".value";
            Assert.assertTrue((String)("Should contain a multiproperty with name = " + string), (multiProperty.getPropertyString(string) != null && multiProperty.getPropertyString(string).equals(string2) ? 1 : 0) != 0);
            Assert.assertTrue((String)("Should contain a multiproperty with name = " + string), (multiProperty.getPropertyString(string) != null && multiProperty.getPropertyString(n).equals(string2) ? 1 : 0) != 0);
            ++n;
        }
    }

    public void testHasMultiProperty() {
        this.properties.loadJposPropertiesByName(JPOS_JUNIT_PROPERTIES_FILE_NAME);
        Assert.assertTrue((String)"Should contain a multiproperty with name = multiProp", (boolean)this.properties.hasMultiProperty(MULTI_PROP_BASE_NAME));
        Assert.assertTrue((String)"Should NOT contain a multiproperty with name = __xyzMultiProp__", (!this.properties.hasMultiProperty("__xyzMultiProp__") ? 1 : 0) != 0);
    }

    public void testGetProps() {
        this.properties.loadJposPropertiesByName(JPOS_JUNIT_PROPERTIES_FILE_NAME);
        Enumeration enumeration = this.properties.getPropertyNames();
        Iterator iterator = this.properties.getProps();
        Vector<String> vector = new Vector<String>();
        while (iterator.hasNext()) {
            JposProperties.Prop prop = (JposProperties.Prop)iterator.next();
            vector.add(prop.getName());
        }
        Assert.assertTrue((String)"All names in properties should be in getProps() JposProperties.Prop list", (boolean)JUnitUtility.isEquals((Enumeration)enumeration, vector.elements()));
    }

    public void testSortGetProps() {
        this.properties.loadJposPropertiesByName(JPOS_JUNIT_PROPERTIES_FILE_NAME);
        Enumeration enumeration = this.properties.getPropertyNames();
        Iterator iterator = this.properties.getProps();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        while (iterator.hasNext()) {
            arrayList2.add(iterator.next());
        }
        Collections.sort(arrayList);
        Collections.sort(arrayList2, DefaultProperties.propComparator());
        int n = 0;
        while (n < arrayList2.size()) {
            arrayList3.add(((JposProperties.Prop)arrayList2.get(n)).getName());
            ++n;
        }
        Assert.assertTrue((String)"Sorting both properties.getPropertyNames() and getProps().getName() list should yield same list", (boolean)JUnitUtility.isEquals(arrayList, arrayList3));
    }

    public void testGetStringListProperty() {
    }
}

