/*
 * Decompiled with CFR 0.152.
 */
package jpos.util.tracing;

import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerOutput;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TracerTestCase
extends TestCase {
    private Tracer namedTracer = null;
    private Tracer tracer = null;
    private TestTracerOutput testTracerOutput = null;
    public static final String NAMED_TRACER_NAME = "NamedTracer";

    public TracerTestCase(String string) {
        super(string);
    }

    protected void setUp() {
        this.tracer = Tracer.getInstance();
        this.testTracerOutput = new TestTracerOutput();
        this.tracer.setTracerOutput(this.testTracerOutput);
        this.namedTracer = new Tracer(NAMED_TRACER_NAME);
    }

    protected void tearDown() {
        this.tracer = null;
        this.testTracerOutput = null;
        this.namedTracer = null;
    }

    public void testGetInstance() {
        Tracer tracer = Tracer.getInstance();
        Assert.assertTrue((String)"Did not get same instance from calls to Tracer.getInstance()", (tracer == Tracer.getInstance() ? 1 : 0) != 0);
    }

    public void testStringPrintln() {
        String string = "testString";
        this.tracer.println(string);
        Assert.assertTrue((String)"TracerOutput did not get testString", (boolean)this.testTracerOutput.getPrintlnString().equals(string));
    }

    public void testStringPrint() {
        String string = "testString";
        this.tracer.print(string);
        Assert.assertTrue((String)"TracerOutput did not get testString", (boolean)this.testTracerOutput.getPrintString().equals(string));
    }

    public void testObjectPrintln() {
        Integer n = new Integer(10);
        this.tracer.println(n);
        Assert.assertTrue((String)"TracerOutput did not get testObj", (boolean)this.testTracerOutput.getPrintlnString().equals(((Object)n).toString()));
    }

    public void testObjectPrint() {
        Boolean bl = new Boolean(false);
        this.tracer.print(bl);
        Assert.assertTrue((String)"TracerOutput did not get testObj", (boolean)this.testTracerOutput.getPrintString().equals(((Object)bl).toString()));
    }

    public void testFlush() {
        String string = "testString";
        this.tracer.print((Object)string);
        this.tracer.flush();
        Assert.assertTrue((String)"TracerOutput did not get flush call", (boolean)this.testTracerOutput.isFlush());
    }

    public void testExceptionPrint() {
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
        this.tracer.print(illegalArgumentException);
        Assert.assertTrue((String)"Exception not equal to printed exception", (boolean)this.testTracerOutput.getException().equals(illegalArgumentException));
    }

    public void testIsAppendName() {
        Assert.assertTrue((String)"Default Tracer should have no name and isAppendName() == false", (!this.tracer.isAppendName() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Named Tracer should default to isAppendName() == true", (boolean)this.namedTracer.isAppendName());
    }

    public void testSetAppendName() {
        Assert.assertTrue((String)"Named Tracer should default to isAppendName() == true", (boolean)this.namedTracer.isAppendName());
        this.namedTracer.setAppendName(false);
        Assert.assertTrue((String)"Named Tracer should default to isAppendName() == true", (!this.namedTracer.isAppendName() ? 1 : 0) != 0);
    }

    public void testCreateTracerWithName() {
        Tracer tracer = new Tracer("newNamedTracer");
        Assert.assertTrue((String)"newNamedTracer should default to isAppenName() == true", (boolean)tracer.isAppendName());
        Assert.assertTrue((String)"newNamedTracer.getName().equals( \"newNamedTracer\"", (boolean)tracer.getName().equals("newNamedTracer"));
    }

    protected class TestTracerOutput
    implements TracerOutput {
        private String suffix = "";
        private boolean flushed = false;
        private String printlnString = "";
        private String printString = "";
        private Exception exception = null;

        protected TestTracerOutput() {
        }

        public void close() {
        }

        public String getPrefix() {
            return this.suffix;
        }

        public void print(Exception exception) {
            this.exception = exception;
        }

        public void println(String string) {
            this.printlnString = string;
        }

        public void print(String string) {
            this.printString = string;
        }

        public void flush() {
            this.flushed = true;
        }

        boolean isFlush() {
            return this.flushed;
        }

        String getPrintString() {
            return this.printString;
        }

        String getPrintlnString() {
            return this.printlnString;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

