/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.tools.sdist;

import com.ibm.jpos.tools.sdist.SdistAppView;
import com.ibm.jpos.tools.sdist.SdistBaseFrame;
import com.ibm.jpos.tools.sdist.panels.SdistPnlMainDetailPanel;
import com.ibm.jpos.tools.sdist.panels.SdistPnlMainPanel;
import com.ibm.jpos.tools.sdist.panels.SdistPnlOptions;
import com.ibm.jutil.DefaultUtilProperties;
import com.ibm.jutil.UtilProperties;
import com.ibm.jutil.swing.ImageComponent;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class SupportToolApp {
    JWindow splashScr = null;
    JFrame mainFrame = null;
    SdistAppView view = null;
    public static final String SDIST_PROPERTIES_FILE_NAME = "sdist.properties";
    public static final String SPLASH_IMAGE = "com" + File.separator + "ibm" + File.separator + "jpos" + File.separator + "res" + File.separator + "images" + File.separator + "sdist_splash.jpg";
    public static final String PROP_DIRECTORY = "sdist.propertiesDirectory";
    public static final String PROP_LANGUAGE = "sdist.language";

    public SupportToolApp(UtilProperties props) {
        Object image;
        try {
            image = new ImageComponent(SPLASH_IMAGE);
        }
        catch (Exception e) {
            image = new JLabel();
        }
        this.splashScr = new JWindow();
        this.splashScr.getContentPane().add((Component)image);
        this.splashScr.pack();
        SupportToolApp.center(this.splashScr);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SupportToolApp.this.splashScr.setVisible(true);
                SupportToolApp.this.splashScr.validate();
                SupportToolApp.this.splashScr.repaint();
            }
        });
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SupportToolApp.this.mainFrame = new JFrame();
                SupportToolApp.this.view = new SdistAppView(SupportToolApp.this.mainFrame);
                SupportToolApp.this.mainFrame.setTitle("IBM UnifiedPOS Support Tool v 1.0.0");
                SupportToolApp.this.mainFrame.setIconImage(SdistBaseFrame.getInstance().APP_ICON.getImage());
                SupportToolApp.this.splashScr.setVisible(false);
                SupportToolApp.this.splashScr = null;
                SdistPnlMainPanel pnl1 = new SdistPnlMainPanel();
                SupportToolApp.this.view.addPanel(SdistPnlMainPanel.PANEL_ID, pnl1);
                SupportToolApp.this.view.addPanel("PNLSUBSYSTEM", new SdistPnlMainDetailPanel());
                SupportToolApp.this.view.addPanel("Options", new SdistPnlOptions());
                SupportToolApp.this.view.setCurrentPanel(SdistPnlMainPanel.PANEL_ID);
                SupportToolApp.this.mainFrame.setVisible(true);
            }
        });
    }

    public static void main(String[] args) {
        try {
            DefaultUtilProperties sdistProp = new DefaultUtilProperties(SDIST_PROPERTIES_FILE_NAME);
            sdistProp.loadProperties();
            if (sdistProp.isPropertyDefined(PROP_LANGUAGE)) {
                Locale.setDefault(new Locale(sdistProp.getPropertyString(PROP_LANGUAGE), ""));
            }
            new SupportToolApp((UtilProperties)sdistProp);
        }
        catch (Throwable e) {
            Tracer tracer = TracerFactory.getInstance().createTracer("SDIST", "SupportToolApp");
            if (tracer.isOn()) {
                tracer.println("Failed to start SupportTool.");
                tracer.print((Object)e);
            }
            e.printStackTrace();
        }
    }

    public static void center(JWindow wnd) {
        Dimension scr = Toolkit.getDefaultToolkit().getScreenSize();
        wnd.setLocation((scr.width - wnd.getSize().width) / 2, (scr.height - wnd.getSize().height) / 2);
    }
}

