/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.tools.sdist.model;

import com.ibm.jpos.tools.sdist.model.SdistConst;
import com.ibm.jpos.tools.sdist.model.SdistUtils;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class EnvironmentModel {
    private static String sendFolderLocation = "";
    private static EnvironmentModel instance = null;
    private static Tracer tracer = TracerFactory.getInstance().createTracer("SDIST", "EnvironmentModel");

    protected EnvironmentModel() {
        if (SdistUtils.isWindows()) {
            sendFolderLocation = SdistConst.WIN_FILES_TO_SEND_DEFAULT_LOCATION;
        } else if (SdistUtils.isLinux()) {
            sendFolderLocation = SdistConst.LIN_FILES_TO_SEND_DEFAULT_LOCATION;
        }
    }

    public static EnvironmentModel getInstance() {
        if (instance == null) {
            instance = new EnvironmentModel();
            if (tracer.isOn()) {
                tracer.println("-->Creating EnvironmentModel instance<--");
            }
        }
        return instance;
    }

    public void init() {
        EnvironmentModel.createInfoDir();
        EnvironmentModel.createSysInfoFile();
        EnvironmentModel.createLibContentFile();
        EnvironmentModel.getEnvInfoFile();
        EnvironmentModel.getXmlFile();
    }

    public void makeZip() throws Exception {
        byte[] buffer = new byte[1100000];
        SimpleDateFormat ldf = new SimpleDateFormat("yyyyMMddHHmmss");
        if (tracer.isOn()) {
            tracer.println("-->makeZIP");
        }
        String zipFileName = this.getSendFolderLocation() + File.separator + "send" + ldf.format(new Date()) + ".zip";
        File location = new File(SdistUtils.getTempFolderLocation());
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFileName));
        if (location.exists()) {
            File[] FileList = location.listFiles();
            if (FileList.length > 0) {
                for (int i = 0; i < FileList.length; ++i) {
                    int len;
                    File file = new File(FileList[i].toString());
                    FileInputStream in = new FileInputStream(file);
                    out.putNextEntry(new ZipEntry(file.getName()));
                    while ((len = in.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    out.closeEntry();
                    in.close();
                    if (!tracer.isOn()) continue;
                    tracer.println("File: " + file.getName() + " added to zip file.");
                }
                out.close();
            } else if (tracer.isOn()) {
                tracer.println("There are no files in information directory.");
            }
        } else if (tracer.isOn()) {
            tracer.println("<--makeZIP:" + SdistUtils.getTempFolderLocation() + " No exists");
            throw new Exception("INT1");
        }
        if (tracer.isOn()) {
            tracer.println("Finished zipping files");
        }
        if (tracer.isOn()) {
            tracer.println("<--makeZIP");
        }
    }

    public void setSendFolderLocation(String location) {
        if (location.endsWith(File.separator) && location.length() > 1) {
            location = location.substring(0, location.length() - 1);
        }
        sendFolderLocation = location;
    }

    public String getSendFolderLocation() {
        return sendFolderLocation;
    }

    private static void getEnvInfoFile() {
        String location = "";
        if (tracer.isOn()) {
            tracer.println("-->getEnvInfoFile");
        }
        if (SdistUtils.isWindows()) {
            location = SdistConst.WIN_ENV_INFO_FILENAME;
        } else if (SdistUtils.isLinux()) {
            location = SdistConst.LIN_ENV_INFO_FILENAME;
        }
        File path = new File(location);
        File newPath = new File(SdistUtils.getTempFolderLocation() + File.separator + path.getName());
        SdistUtils.getFile(path, newPath, "ENVIRONMENT VARIABLES AND VALUES: ");
        if (tracer.isOn()) {
            tracer.println("<--getEnvInfoFile");
        }
    }

    private static void getXmlFile() {
        File path = new File("jpos.xml");
        if (tracer.isOn()) {
            tracer.println("-->getXmlFile");
        }
        File newPath = new File(SdistUtils.getTempFolderLocation() + File.separator + "jpos.xml");
        SdistUtils.getFile(path, newPath, "JPOS.XML LOCATION: " + path.getAbsolutePath());
        if (tracer.isOn()) {
            tracer.println("<--getXmlFile");
        }
    }

    private static void createInfoDir() {
        File path = new File(instance.getSendFolderLocation());
        if (tracer.isOn()) {
            tracer.println("-->createInfoDir");
        }
        if (SdistUtils.isLinux()) {
            SdistUtils.makeWritable(path.getParent().toString());
        }
        if (path.exists()) {
            File[] FList = path.listFiles();
            for (int i = 0; i < FList.length; ++i) {
                if (!FList[i].getName().equals("environment.txt")) continue;
                FList[i].delete();
            }
            if (tracer.isOn()) {
                tracer.println("Information directory exists. Deleting old directory information file.");
            }
        } else if (path.mkdir()) {
            if (tracer.isOn()) {
                tracer.println("Directory for information files created.");
            }
        } else if (tracer.isOn()) {
            tracer.println("Directory for information files was not created.");
        }
        if (tracer.isOn()) {
            tracer.println("<--createInfoDir");
        }
    }

    private static void createSysInfoFile() {
        block4: {
            Properties sp = System.getProperties();
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(SdistUtils.getTempFolderLocation() + File.separator + "systemvars.txt", true));
                Enumeration<?> sysenum = sp.propertyNames();
                out.write("#########################################################################");
                out.newLine();
                out.write("SYSTEM VARIABLES AND VALUES");
                out.newLine();
                out.write("#########################################################################");
                out.newLine();
                while (sysenum.hasMoreElements()) {
                    String propName = (String)sysenum.nextElement();
                    out.newLine();
                    out.write(propName + "=" + sp.getProperty(propName));
                    out.newLine();
                }
                out.close();
                if (tracer.isOn()) {
                    tracer.println("-->createSysInfoFile:Writing system variables and values...<--");
                }
            }
            catch (IOException e) {
                if (!tracer.isOn()) break block4;
                tracer.println("-->createSysInfoFile:System variables and values could not be written...<--");
            }
        }
    }

    private static void createLibContentFile() {
        if (SdistUtils.isWindows()) {
            EnvironmentModel.createLibContentFileForWindows();
        } else if (SdistUtils.isLinux()) {
            EnvironmentModel.createLibContentFileForLinux();
        }
    }

    private static void createLibContentFileForWindows() {
        File path = new File(SdistConst.WIN_LIB_FILES_LOCATION);
        if (path.exists()) {
            File[] FileList = path.listFiles();
            if (FileList.length > 0) {
                try {
                    BufferedWriter out = new BufferedWriter(new FileWriter(SdistUtils.getTempFolderLocation() + File.separator + "libfolderinfo.txt", true));
                    out.newLine();
                    out.write("#########################################################################");
                    out.newLine();
                    out.write(SdistConst.WIN_LIB_FILES_LOCATION.toUpperCase() + " CONTENT:");
                    out.newLine();
                    out.write("#########################################################################");
                    out.newLine();
                    out.write("FILENAME - SIZE - LAST MODIFIED\n");
                    for (int i = 0; i < FileList.length; ++i) {
                        out.newLine();
                        out.write(FileList[i].getName() + " - " + FileList[i].length() + " - " + new Date(FileList[i].lastModified()));
                    }
                    out.newLine();
                    out.write("#########################################################################");
                    out.close();
                }
                catch (IOException e) {
                    if (tracer.isOn()) {
                        tracer.println("-->createLibContentFileForWindows:Error writing lib folder files details to file<--");
                    }
                }
            } else if (tracer.isOn()) {
                tracer.println("-->createLibContentFileForWindows:Lib folder has no files<--");
            }
        } else if (tracer.isOn()) {
            tracer.println("-->createLibContentFileForWindows:Lib folder is not present<--");
        }
    }

    private static void createLibContentFileForLinux() {
        block4: {
            File file = null;
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(SdistUtils.getTempFolderLocation() + File.separator + "sysfilesinfo.txt", true));
                out.newLine();
                out.write("#########################################################################");
                out.newLine();
                out.write("LINUX SYSTEM FILES:");
                out.newLine();
                out.write("#########################################################################");
                out.newLine();
                out.write("FILENAME - SIZE - LAST MODIFIED\n");
                for (int i = 0; i < SdistConst.LINUX_CONTENT_FILES.length; ++i) {
                    file = new File(SdistConst.LINUX_CONTENT_FILES[i]);
                    if (file.exists()) {
                        out.newLine();
                        out.write(file.getName() + " - " + file.length() + " - " + new Date(file.lastModified()));
                        continue;
                    }
                    out.newLine();
                    out.write(file.getName() + " - NOT FOUND");
                }
                out.newLine();
                out.write("#########################################################################");
                out.close();
            }
            catch (IOException e) {
                if (!tracer.isOn()) break block4;
                tracer.println("-->createLibContentFileForLinux:Error writing lib folder files details to file<--");
            }
        }
    }
}

