/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb;

import com.ibm.jusb.UsbDeviceImp;
import com.ibm.jusb.UsbPortImp;
import com.ibm.jusb.os.UsbDeviceOsImp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbException;
import javax.usb.UsbHub;
import javax.usb.UsbPort;
import javax.usb.util.UsbUtil;

public class UsbHubImp
extends UsbDeviceImp
implements UsbHub {
    protected List portList = new LinkedList();
    protected boolean resizingAllowed = true;
    public static final int USB_HUB_MIN_PORTS = 1;
    public static final int USB_HUB_MAX_PORTS = 255;
    private static final String USB_HUB_PORT_OUT_OF_RANGE = "No such port number on this hub : ";

    public UsbHubImp() {
        this(1);
        this.resizingAllowed = true;
    }

    public UsbHubImp(int ports) {
        this.resize(ports);
        this.resizingAllowed = false;
    }

    public UsbHubImp(UsbDeviceDescriptor desc) {
        this(1, desc);
        this.resizingAllowed = true;
    }

    public UsbHubImp(UsbDeviceOsImp device) {
        this(1, device);
        this.resizingAllowed = true;
    }

    public UsbHubImp(int ports, UsbDeviceDescriptor desc) {
        super(desc);
        this.resize(ports);
        this.resizingAllowed = false;
    }

    public UsbHubImp(int ports, UsbDeviceOsImp device) {
        super(device);
        this.resize(ports);
        this.resizingAllowed = false;
    }

    public UsbHubImp(UsbDeviceDescriptor desc, UsbDeviceOsImp device) {
        this(1, desc, device);
        this.resizingAllowed = true;
    }

    public UsbHubImp(int ports, UsbDeviceDescriptor desc, UsbDeviceOsImp device) {
        super(desc, device);
        this.resize(ports);
        this.resizingAllowed = false;
    }

    public synchronized void resize(int ports) throws UnsupportedOperationException {
        if (!this.resizingAllowed) {
            throw new UnsupportedOperationException("Resizing is not allowed on this hub");
        }
        int oldports = UsbUtil.unsignedInt((byte)this.getNumberOfPorts());
        if (ports == oldports) {
            return;
        }
        if (ports > 255) {
            ports = 255;
        }
        if (ports < 1) {
            ports = 1;
        }
        if (ports < oldports) {
            for (int i = oldports; i > ports; --i) {
                if (this.getUsbPortImp((byte)i).isUsbDeviceAttached()) {
                    return;
                }
                this.portList.remove(i - 1);
            }
        } else {
            for (int i = oldports; i < ports; ++i) {
                this.portList.add(new UsbPortImp(this, (byte)(i + 1)));
            }
        }
    }

    public synchronized void addUsbDeviceImp(UsbDeviceImp usbDeviceImp, byte portNumber) throws UsbException {
        if (UsbUtil.unsignedInt((byte)portNumber) > UsbUtil.unsignedInt((byte)this.getNumberOfPorts())) {
            this.resize(portNumber);
        }
        UsbPortImp usbPortImp = this.getUsbPortImp(portNumber);
        usbPortImp.attachUsbDeviceImp(usbDeviceImp);
    }

    public synchronized void removeUsbDeviceImp(UsbDeviceImp usbDeviceImp, byte portNumber) throws IllegalArgumentException {
        UsbPortImp usbPortImp = this.getUsbPortImp(portNumber);
        try {
            usbPortImp.detachUsbDeviceImp(usbDeviceImp);
        }
        catch (NullPointerException npE) {
            throw new IllegalArgumentException(USB_HUB_PORT_OUT_OF_RANGE + UsbUtil.unsignedInt((byte)portNumber));
        }
    }

    public boolean isUsbHub() {
        return true;
    }

    public boolean isRootUsbHub() {
        return false;
    }

    public byte getNumberOfPorts() {
        return (byte)this.portList.size();
    }

    public List getUsbPorts() {
        return Collections.unmodifiableList(this.portList);
    }

    public UsbPort getUsbPort(byte number) {
        return this.getUsbPortImp(number);
    }

    public synchronized UsbPortImp getUsbPortImp(byte number) {
        int num = UsbUtil.unsignedInt((byte)number);
        if (0 >= num || num > UsbUtil.unsignedInt((byte)this.getNumberOfPorts())) {
            return null;
        }
        return (UsbPortImp)this.portList.get(num - 1);
    }

    public synchronized List getAttachedUsbDevices() {
        ArrayList<UsbDeviceImp> attachedDevices = new ArrayList<UsbDeviceImp>();
        for (int i = 0; i < this.portList.size(); ++i) {
            UsbPortImp portImp = (UsbPortImp)this.portList.get(i);
            UsbDeviceImp device = portImp.getUsbDeviceImp();
            if (null == device) continue;
            attachedDevices.add(device);
        }
        return Collections.unmodifiableList(attachedDevices);
    }
}

