/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.tools.swing;

import com.ibm.jusb.tools.swing.UsbPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.usb.UsbEndpoint;
import javax.usb.util.UsbUtil;

public class UsbEndpointPanel
extends UsbPanel {
    private UsbEndpoint usbEndpoint = null;

    public UsbEndpointPanel(UsbEndpoint ep) {
        this.usbEndpoint = ep;
        this.string = "UsbEndpoint 0x" + UsbUtil.toHexString((byte)ep.getUsbEndpointDescriptor().bEndpointAddress());
        this.add(Box.createVerticalGlue());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(panel);
        this.refresh();
    }

    public UsbEndpoint getUsbEndpoint() {
        return this.usbEndpoint;
    }

    protected void refresh() {
        this.clear();
        this.appendln(this.string);
        this.initText();
    }

    protected void initText() {
        String type = null;
        switch (this.usbEndpoint.getType()) {
            case 0: {
                type = "Control";
                break;
            }
            case 2: {
                type = "Bulk";
                break;
            }
            case 3: {
                type = "Interrupt";
                break;
            }
            case 1: {
                type = "Isochronous";
                break;
            }
            default: {
                type = "Unknown";
            }
        }
        String direction = null;
        switch (this.usbEndpoint.getDirection()) {
            case -128: {
                direction = "IN";
                break;
            }
            case 0: {
                direction = "OUT";
                break;
            }
            default: {
                direction = "Unknown";
            }
        }
        this.appendln("Type : " + UsbUtil.toHexString((byte)this.usbEndpoint.getType()) + " (" + type + ")");
        this.appendln("Direction : " + direction);
        this.append(this.usbEndpoint.getUsbEndpointDescriptor().toString());
    }
}

