/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.systray;

import br.com.auttar.systray.ServiceCommand;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.SwingUtilities;

public class CTFClientSysTray
implements ActionListener,
MouseListener {
    private String START_SERVICE = "START_SERVICE";
    private String STOP_SERVICE = "STOP_SERVICE";
    private String RESTART_SERVICE = "RESTART_SERVICE";
    private String EXIT = "EXIT";
    private String LOGS = "LOGS";
    private PopupMenu popupMenu = null;
    private MenuItem startMenuItem = null;
    private MenuItem stopMenuItem = null;
    private MenuItem restartMenuItem = null;
    private MenuItem exitMenuItem = null;
    private MenuItem logsMenuItem = null;
    private TrayIcon icon = null;
    private ServiceCommand serviceCommand = null;
    private String wrkDir = null;

    public CTFClientSysTray() {
        this.init();
    }

    public void init() {
        try {
            Properties properties = new Properties();
            File file = new File("config.properties");
            properties.load(new FileInputStream(file));
            this.wrkDir = properties.getProperty("wrkdir");
            String jreDir = properties.getProperty("jredir");
            String[] params = properties.getProperty("params").split(";");
            String app = properties.getProperty("app");
            this.serviceCommand = ServiceCommand.createInstance(this.wrkDir, jreDir, params, app);
            this.icon = new TrayIcon(this.getImage(), "Painel de controle CTFClient", this.getPopupMenu());
            this.icon.addMouseListener(this);
            this.icon.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CTFClientSysTray.this.icon.displayMessage("CTFClient", "Painel de controle", TrayIcon.MessageType.INFO);
                }
            });
            this.icon.setImageAutoSize(true);
            SystemTray.getSystemTray().add(this.icon);
            Thread.sleep(3000L);
            this.icon.displayMessage("CTFClient", "Painel de controle", TrayIcon.MessageType.INFO);
            Thread.sleep(2000L);
            this.actionPerformed(new ActionEvent(this.getStartMenuItem(), 0, this.getStartMenuItem().getActionCommand()));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private Image getImage() throws HeadlessException {
        Image image = Toolkit.getDefaultToolkit().getImage("auttar.jpg");
        return image;
    }

    private MenuItem getStartMenuItem() {
        if (this.startMenuItem == null) {
            this.startMenuItem = new MenuItem("Iniciar");
            this.startMenuItem.setActionCommand(this.START_SERVICE);
            this.startMenuItem.addActionListener(this);
            this.startMenuItem.setEnabled(true);
        }
        return this.startMenuItem;
    }

    private MenuItem getStopMenuItem() {
        if (this.stopMenuItem == null) {
            this.stopMenuItem = new MenuItem("Parar");
            this.stopMenuItem.setActionCommand(this.STOP_SERVICE);
            this.stopMenuItem.addActionListener(this);
            this.stopMenuItem.setEnabled(false);
        }
        return this.stopMenuItem;
    }

    private MenuItem getRestartMenuItem() {
        if (this.restartMenuItem == null) {
            this.restartMenuItem = new MenuItem("Reiniciar");
            this.restartMenuItem.setActionCommand(this.RESTART_SERVICE);
            this.restartMenuItem.addActionListener(this);
            this.restartMenuItem.setEnabled(false);
        }
        return this.restartMenuItem;
    }

    private MenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new MenuItem("Exit");
            this.exitMenuItem.setActionCommand(this.EXIT);
            this.exitMenuItem.addActionListener(this);
        }
        return this.exitMenuItem;
    }

    private MenuItem getLogsMenuItem() {
        if (this.logsMenuItem == null) {
            this.logsMenuItem = new MenuItem("Logs");
            this.logsMenuItem.setActionCommand(this.LOGS);
            this.logsMenuItem.addActionListener(this);
        }
        return this.logsMenuItem;
    }

    private PopupMenu getPopupMenu() throws HeadlessException {
        if (this.popupMenu == null) {
            this.popupMenu = new PopupMenu();
            this.popupMenu.add(this.getStartMenuItem());
            this.popupMenu.add(this.getStopMenuItem());
            this.popupMenu.add(this.getRestartMenuItem());
            this.popupMenu.addSeparator();
            this.popupMenu.add(this.getLogsMenuItem());
            this.popupMenu.addSeparator();
            this.popupMenu.add(this.getExitMenuItem());
            this.popupMenu.addActionListener(this);
        }
        return this.popupMenu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(this.START_SERVICE)) {
            this.serviceCommand.start();
            this.icon.displayMessage("CTFClient", "Inicializado", TrayIcon.MessageType.INFO);
        } else if (e.getActionCommand().equals(this.STOP_SERVICE)) {
            this.serviceCommand.stop();
            this.icon.displayMessage("CTFClient", "Finalizado", TrayIcon.MessageType.INFO);
        } else if (e.getActionCommand().equals(this.RESTART_SERVICE)) {
            this.serviceCommand.restart();
            this.icon.displayMessage("CTFClient", "Restart Finalizado", TrayIcon.MessageType.INFO);
        } else if (e.getActionCommand().equals(this.LOGS)) {
            System.out.println(System.getProperty("os.name"));
            Runtime rt = Runtime.getRuntime();
            try {
                String cmdLine = "explorer " + this.wrkDir + File.separator + "logs";
                rt.exec(cmdLine);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else if (e.getActionCommand().equals(this.EXIT)) {
            if (this.serviceCommand.isAlive()) {
                this.serviceCommand.stop();
            }
            System.exit(0);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (this.serviceCommand.isAlive()) {
                this.icon.displayMessage("CTFClient", "Inicializado", TrayIcon.MessageType.INFO);
            }
        } else if (this.serviceCommand.isAlive()) {
            this.getStartMenuItem().setEnabled(false);
            this.getStopMenuItem().setEnabled(true);
            this.getRestartMenuItem().setEnabled(true);
        } else {
            this.getStopMenuItem().setEnabled(false);
            this.getStartMenuItem().setEnabled(true);
            this.getRestartMenuItem().setEnabled(false);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public static void main(String[] args) throws Exception {
        new CTFClientSysTray();
        try {
            while (true) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }
}

