/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperPrintStream;
import org.tanukisoftware.wrapper.WrapperSystemPropertyUtil;

public class WrapperJarApp
implements WrapperListener,
Runnable {
    private static WrapperPrintStream m_outInfo;
    private static WrapperPrintStream m_outError;
    private static WrapperPrintStream m_outDebug;
    private Method m_mainMethod;
    private String[] m_appArgs;
    private boolean m_mainStarted;
    private boolean m_mainComplete;
    private Integer m_mainExitCode;
    private boolean m_startComplete;
    static /* synthetic */ Class class$org$tanukisoftware$wrapper$WrapperManager;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$org$tanukisoftware$wrapper$WrapperJarApp;

    protected WrapperJarApp(String[] args) {
        Class<?> mainClass;
        URL[] classURLs;
        Manifest manifest;
        JarFile jarFile;
        Class wmClass = class$org$tanukisoftware$wrapper$WrapperManager == null ? (class$org$tanukisoftware$wrapper$WrapperManager = WrapperJarApp.class$("org.tanukisoftware.wrapper.WrapperManager")) : class$org$tanukisoftware$wrapper$WrapperManager;
        m_outInfo = new WrapperPrintStream(System.out, "WrapperJarApp: ");
        m_outError = new WrapperPrintStream(System.out, "WrapperJarApp: ");
        m_outDebug = new WrapperPrintStream(System.out, "WrapperJarApp Debug: ");
        if (args.length < 1) {
            this.showUsage();
            WrapperManager.stop(1);
            return;
        }
        File file = new File(args[0]);
        if (!file.exists()) {
            m_outError.println("Unable to locate the jar file " + args[0]);
            this.showUsage();
            WrapperManager.stop(1);
            return;
        }
        File parent = file.getParentFile();
        try {
            jarFile = new JarFile(file);
        }
        catch (IOException e) {
            m_outError.println("Unable to open the jar file " + args[0] + " : " + e);
            this.showUsage();
            WrapperManager.stop(1);
            return;
        }
        try {
            manifest = jarFile.getManifest();
        }
        catch (IOException e) {
            m_outError.println("Unable to access the jar's manifest file " + args[0] + " : " + e);
            this.showUsage();
            WrapperManager.stop(1);
            return;
        }
        Attributes attributes = manifest.getMainAttributes();
        String mainClassName = attributes.getValue("Main-Class");
        String classPath = attributes.getValue("Class-Path");
        if (WrapperManager.isDebugEnabled()) {
            m_outDebug.println("Jar Main-Class: " + mainClassName);
        }
        if (classPath != null && !classPath.equals("")) {
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println("Jar Class-Path: " + classPath);
            }
            StringTokenizer st = new StringTokenizer(classPath, " \n\r");
            classURLs = new URL[st.countTokens() + 1];
            try {
                classURLs[0] = new URL("file:" + file.getAbsolutePath());
            }
            catch (MalformedURLException e) {
                m_outError.println("Unable to add jar to classpath: " + e);
                this.showUsage();
                WrapperManager.stop(1);
                return;
            }
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println("    Classpath[0]=" + classURLs[0]);
            }
            int i = 1;
            while (st.hasMoreTokens()) {
                String classEntry = st.nextToken();
                try {
                    classURLs[i] = new URL("file:" + new File(parent, classEntry).getAbsolutePath());
                }
                catch (MalformedURLException e) {
                    m_outError.println("Malformed classpath in the jar's manifest file " + args[0] + " : " + e);
                    this.showUsage();
                    WrapperManager.stop(1);
                    return;
                }
                if (WrapperManager.isDebugEnabled()) {
                    m_outDebug.println("    Classpath[" + i + "]=" + classURLs[i]);
                }
                ++i;
            }
        } else {
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println("Jar Class-Path: Not specified.");
            }
            classURLs = new URL[1];
            try {
                classURLs[0] = new URL("file:" + file.getAbsolutePath());
            }
            catch (MalformedURLException e) {
                m_outError.println("Unable to add jar to classpath: " + e);
                this.showUsage();
                WrapperManager.stop(1);
                return;
            }
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println("    Classpath[0]=" + classURLs[0]);
            }
        }
        URLClassLoader cl = URLClassLoader.newInstance(classURLs, this.getClass().getClassLoader());
        try {
            mainClass = Class.forName(mainClassName, true, cl);
        }
        catch (ClassNotFoundException e) {
            m_outError.println("Unable to locate the class " + mainClassName + ": " + e);
            this.showUsage();
            WrapperManager.stop(1);
            return;
        }
        catch (ExceptionInInitializerError e) {
            m_outError.println("Class " + mainClassName + " found but could not be initialized due to:");
            e.printStackTrace(m_outError);
            WrapperManager.stop(1);
            return;
        }
        catch (LinkageError e) {
            m_outError.println("Class " + mainClassName + " found but could not be initialized: " + e);
            WrapperManager.stop(1);
            return;
        }
        try {
            this.m_mainMethod = mainClass.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = WrapperJarApp.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        }
        catch (NoSuchMethodException e) {
            m_outError.println("Unable to locate a public static main method in class " + args[0] + ": " + e);
            this.showUsage();
            WrapperManager.stop(1);
            return;
        }
        catch (SecurityException e) {
            m_outError.println("Unable to locate a public static main method in class " + args[0] + ": " + e);
            this.showUsage();
            WrapperManager.stop(1);
            return;
        }
        int modifiers = this.m_mainMethod.getModifiers();
        if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) {
            m_outError.println("The main method in class " + args[0] + " must be declared public and static.");
            this.showUsage();
            WrapperManager.stop(1);
            return;
        }
        String[] appArgs = new String[args.length - 1];
        System.arraycopy(args, 1, appArgs, 0, appArgs.length);
        WrapperManager.start(this, appArgs);
    }

    public void run() {
        Throwable t;
        block16: {
            WrapperJarApp wrapperJarApp = this;
            synchronized (wrapperJarApp) {
                this.m_mainStarted = true;
                this.notifyAll();
            }
            t = null;
            try {
                if (WrapperManager.isDebugEnabled()) {
                    m_outDebug.println("invoking main method");
                }
                this.m_mainMethod.invoke(null, new Object[]{this.m_appArgs});
                if (WrapperManager.isDebugEnabled()) {
                    m_outDebug.println("main method completed");
                }
                WrapperJarApp wrapperJarApp2 = this;
                synchronized (wrapperJarApp2) {
                    this.m_mainComplete = true;
                    this.notifyAll();
                }
                return;
            }
            catch (IllegalAccessException e) {
                t = e;
            }
            catch (IllegalArgumentException e) {
                t = e;
            }
            catch (InvocationTargetException e) {
                t = e.getTargetException();
                if (t != null) break block16;
                t = e;
            }
        }
        m_outInfo.println();
        m_outError.println("Encountered an error running main:");
        t.printStackTrace(m_outError);
        WrapperJarApp wrapperJarApp = this;
        synchronized (wrapperJarApp) {
            if (this.m_startComplete) {
                WrapperManager.stop(1);
                return;
            }
            this.m_mainComplete = true;
            this.m_mainExitCode = new Integer(1);
            this.notifyAll();
            return;
        }
    }

    public Integer start(String[] args) {
        int maxLoops;
        boolean waitForStartMain = WrapperSystemPropertyUtil.getBooleanProperty((class$org$tanukisoftware$wrapper$WrapperJarApp == null ? (class$org$tanukisoftware$wrapper$WrapperJarApp = WrapperJarApp.class$("org.tanukisoftware.wrapper.WrapperJarApp")) : class$org$tanukisoftware$wrapper$WrapperJarApp).getName() + ".waitForStartMain", false);
        int maxStartMainWait = WrapperSystemPropertyUtil.getIntProperty((class$org$tanukisoftware$wrapper$WrapperJarApp == null ? (class$org$tanukisoftware$wrapper$WrapperJarApp = WrapperJarApp.class$("org.tanukisoftware.wrapper.WrapperJarApp")) : class$org$tanukisoftware$wrapper$WrapperJarApp).getName() + ".maxStartMainWait", 2);
        maxStartMainWait = Math.max(1, maxStartMainWait);
        if (waitForStartMain) {
            maxLoops = Integer.MAX_VALUE;
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println("start(args) Will wait indefinitely for the main method to complete.");
            }
        } else {
            maxLoops = maxStartMainWait;
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println("start(args) Will wait up to " + maxLoops + " seconds for the main method to complete.");
            }
        }
        Thread mainThread = new Thread((Runnable)this, "WrapperJarAppMain");
        WrapperJarApp wrapperJarApp = this;
        synchronized (wrapperJarApp) {
            this.m_appArgs = args;
            mainThread.start();
            while (!this.m_mainStarted) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            int loops = 0;
            while (loops < maxLoops && !this.m_mainComplete) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!this.m_mainComplete) {
                    WrapperManager.signalStarting(5000);
                }
                ++loops;
            }
            this.m_startComplete = true;
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println("start(args) end.  Main Completed=" + this.m_mainComplete + ", exitCode=" + this.m_mainExitCode);
            }
            Integer n = this.m_mainExitCode;
            return n;
        }
    }

    public int stop(int exitCode) {
        if (WrapperManager.isDebugEnabled()) {
            m_outDebug.println("stop(" + exitCode + ")");
        }
        return exitCode;
    }

    public void controlEvent(int event) {
        if (event == 202 && (WrapperManager.isLaunchedAsService() || WrapperManager.isIgnoreUserLogoffs())) {
            m_outInfo.println("User logged out.  Ignored.");
        } else {
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println("controlEvent(" + event + ") Stopping");
            }
            WrapperManager.stop(0);
        }
    }

    protected void showUsage() {
        System.out.println();
        System.out.println("WrapperJarApp Usage:");
        System.out.println("  java org.tanukisoftware.wrapper.WrapperJarApp {jar_file} [app_arguments]");
        System.out.println();
        System.out.println("Where:");
        System.out.println("  jar_file:       The jar file to run.");
        System.out.println("  app_arguments:  The arguments that would normally be passed to the");
        System.out.println("                  application.");
    }

    public static void main(String[] args) {
        new WrapperJarApp(args);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

