/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil;

import com.ibm.jutil.JUtilException;
import com.ibm.jutil.LList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DefaultLList
implements LList {
    private LList.Item head = null;
    private LList.Item tail = null;
    private List cachedList = new LinkedList();
    private List cachedItemList = new LinkedList();

    public boolean isEmpty() {
        return this.head == null;
    }

    public int getSize() {
        return this.cachedList.size();
    }

    public Object first() throws JUtilException {
        return this.firstItem().getValue();
    }

    public LList.Item firstItem() throws JUtilException {
        if (this.isEmpty()) {
            throw new JUtilException("The LList is empty and thus has no first item");
        }
        return this.head;
    }

    public Object last() throws JUtilException {
        return this.lastItem().getValue();
    }

    public LList.Item lastItem() throws JUtilException {
        if (this.isEmpty()) {
            throw new JUtilException("The LList is empty and thus has no last item");
        }
        return this.tail;
    }

    public Object get(int i) throws JUtilException {
        try {
            return this.cachedList.get(i);
        }
        catch (Exception e) {
            throw new JUtilException("Invalid index", e);
        }
    }

    public LList.Item getItem(int i) throws JUtilException {
        try {
            return (LList.Item)this.cachedItemList.get(i);
        }
        catch (Exception e) {
            throw new JUtilException("Invalid index", e);
        }
    }

    public void insertLast(Object obj) {
        DefaultItem item = (DefaultItem)this.createItem(obj);
        if (this.tail == null) {
            this.tail = item;
        } else {
            ((DefaultItem)this.tail).setNext(item);
            item.setPrevious(this.tail);
            item.setNext(item);
            this.tail = item;
        }
        if (this.head == null) {
            this.head = item;
        }
        this.cachedList.add(obj);
        this.cachedItemList.add(item);
    }

    public void insertFirst(Object obj) {
        DefaultItem item = (DefaultItem)this.createItem(obj);
        if (this.tail == null) {
            this.tail = item;
        }
        if (this.head == null) {
            this.head = item;
        } else {
            ((DefaultItem)this.head).setPrevious(item);
            item.setNext(this.head);
            item.setPrevious(item);
            this.head = item;
        }
        this.cachedList.add(0, obj);
        this.cachedItemList.add(0, item);
    }

    public void insert(Object obj, int i) throws JUtilException {
        DefaultItem item = null;
        DefaultItem newItem = (DefaultItem)this.createItem(obj);
        try {
            item = (DefaultItem)this.cachedItemList.get(i);
        }
        catch (Exception e) {
            throw new JUtilException("Invalid index", e);
        }
        newItem.setPrevious(item.previous());
        newItem.setNext(item);
        item.setPrevious(newItem);
        this.cachedList.add(i, obj);
        this.cachedItemList.add(i, newItem);
    }

    public boolean remove(Object obj) {
        if (this.cachedList.contains(obj)) {
            int posi = -1;
            posi = this.cachedList.indexOf(obj);
            this.cachedList.remove(obj);
            LList.Item item = (LList.Item)this.cachedItemList.get(posi);
            if (item.getValue().equals(obj)) {
                if (item == this.head) {
                    if (this.head == this.tail) {
                        this.cachedList.clear();
                        this.cachedItemList.clear();
                        this.tail = null;
                        this.head = null;
                        return true;
                    }
                    this.head = this.head.next();
                    ((DefaultItem)this.head).setPrevious(this.head);
                } else if (item == this.tail) {
                    if (this.head == this.tail) {
                        this.cachedList.clear();
                        this.cachedItemList.clear();
                        this.tail = null;
                        this.head = null;
                        return true;
                    }
                    this.tail = this.tail.previous();
                    ((DefaultItem)this.tail).setNext(this.tail);
                } else {
                    ((DefaultItem)item.next()).setPrevious(item.previous());
                    ((DefaultItem)item.previous()).setNext(item.next());
                }
                this.cachedItemList.remove(item);
                return true;
            }
        }
        return false;
    }

    public void remove(Object obj, int i) throws JUtilException {
        Object itemListObject = null;
        Object listObject = null;
        if (this.cachedItemList.contains(obj) && (itemListObject = (Object)this.cachedItemList.get(i)).equals(obj)) {
            this.cachedItemList.remove(itemListObject);
        }
        if (this.cachedList.contains(obj) && (listObject = (Object)this.cachedList.get(i)).equals(obj)) {
            this.cachedList.remove(listObject);
        }
    }

    public Object removeLast() throws JUtilException {
        LList.Item rlObject = null;
        if (this.tail != null) {
            rlObject = this.lastItem();
            this.cachedItemList.remove(rlObject);
            this.cachedList.remove(rlObject.getValue());
            if (!this.cachedItemList.isEmpty()) {
                this.tail = (LList.Item)this.cachedItemList.get(this.cachedItemList.size() - 1);
                ((DefaultItem)this.tail).setNext(this.tail);
            } else {
                this.head = null;
                this.tail = null;
            }
            return rlObject.getValue();
        }
        return rlObject;
    }

    public Object removeFirst() throws JUtilException {
        LList.Item rfObject = null;
        if (this.head != null) {
            rfObject = this.firstItem();
            this.cachedItemList.remove(rfObject);
            this.cachedList.remove(rfObject.getValue());
            if (!this.cachedItemList.isEmpty()) {
                this.head = (LList.Item)this.cachedItemList.get(0);
                ((DefaultItem)this.head).setPrevious(this.head);
            } else {
                this.head = null;
                this.tail = null;
            }
            return rfObject.getValue();
        }
        return rfObject;
    }

    public Iterator iterator() {
        return this.toList().iterator();
    }

    public Iterator itemIterator() {
        return this.toItemList().iterator();
    }

    public void clear() {
        this.head = null;
        this.tail = null;
        this.cachedList.clear();
        this.cachedItemList.clear();
    }

    public boolean equals(LList llist) {
        if (llist == null) {
            return false;
        }
        if (llist == this) {
            return true;
        }
        Iterator itemIterator = llist.itemIterator();
        Iterator thisItemIterator = this.itemIterator();
        while (itemIterator.hasNext()) {
            LList.Item item = (LList.Item)itemIterator.next();
            if (!thisItemIterator.hasNext()) {
                return false;
            }
            LList.Item thisItem = (LList.Item)thisItemIterator.next();
            if (thisItem == null) {
                return false;
            }
            if (thisItem.equals(item)) continue;
            return false;
        }
        return !thisItemIterator.hasNext();
    }

    public List toList() {
        LinkedList<Byte> newList = new LinkedList<Byte>();
        Byte dummy = new Byte(0);
        for (int x = 0; x < this.cachedList.size(); ++x) {
            newList.add(dummy);
        }
        Collections.copy(newList, this.cachedList);
        return newList;
    }

    public List toItemList() {
        LinkedList<Byte> newList = new LinkedList<Byte>();
        Byte dummy = new Byte(0);
        for (int x = 0; x < this.cachedItemList.size(); ++x) {
            newList.add(dummy);
        }
        Collections.copy(newList, this.cachedItemList);
        return newList;
    }

    public LList.Item getTail() {
        return this.tail;
    }

    public void setTail(LList.Item t) {
        this.tail = t;
    }

    public LList.Item getHead() {
        return this.head;
    }

    public void setHead(LList.Item h) {
        this.head = h;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<DefaultLList size=\"" + this.getSize() + "\">\n");
        sb.append("\t<cachedList size=\"" + this.cachedList.size() + "\">\n");
        sb.append("\t<cachedItemList size=\"" + this.cachedItemList.size() + "\">\n");
        sb.append("</DefaultLList>");
        sb.append(this.cachedList.toString());
        return sb.toString();
    }

    List getCachedList() {
        return this.cachedList;
    }

    List getCachedItemList() {
        return this.cachedItemList;
    }

    protected LList.Item createItem(Object obj) {
        return new DefaultItem(obj);
    }

    public class DefaultItem
    implements LList.Item {
        private Object value = null;
        private LList.Item next = null;
        private LList.Item previous = null;

        public DefaultItem(Object value) {
            this.value = value;
            this.next = this;
            this.previous = this;
        }

        public LList.Item next() {
            return this.next;
        }

        public LList.Item previous() {
            return this.previous;
        }

        public boolean isFirst() {
            return this.previous().equals(this);
        }

        public boolean isLast() {
            return this.next().equals(this);
        }

        public boolean equals(LList.Item item) {
            if (item == null) {
                return false;
            }
            if (item == this) {
                return true;
            }
            if (item.getValue() == null && this.getValue() != null) {
                return false;
            }
            return item.getValue().equals(this.getValue()) && item.next() == this.next() && item.previous() == this.previous();
        }

        public Object getValue() {
            return this.value;
        }

        protected void setPrevious(LList.Item item) {
            this.previous = item;
        }

        protected void setNext(LList.Item item) {
            this.next = item;
        }
    }
}

