/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil;

import com.ibm.jutil.FileUtil;
import com.ibm.jutil.StoreFileUtil;
import com.ibm.jutil.tracing.Tracer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

public class DefaultStoreFileUtil
implements StoreFileUtil {
    private String dirName;
    private String fileName;
    private File rootLocation;
    private PrintWriter fOut;
    private ObjectOutputStream sOut;
    private FileOutputStream foStream;
    private FileInputStream fiStream;

    public DefaultStoreFileUtil(String name) {
        this.dirName = name;
        this.rootLocation = new File(name);
    }

    public InputStream load(String fileName) throws FileNotFoundException {
        this.fiStream = new FileInputStream(new File(this.dirName + File.separator + fileName));
        return this.fiStream;
    }

    public String loadAsString(String fileName) throws FileNotFoundException {
        String s = "";
        try {
            char[] c = new char[(int)this.length(fileName)];
            InputStream is = FileUtil.loadFile(fileName, true, true);
            InputStreamReader reader = new InputStreamReader(is);
            reader.read(c);
            s = new String(c);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return s;
    }

    public void create(String fileName) throws IOException {
        File out;
        this.fileName = fileName;
        if (!this.rootLocation.exists()) {
            Tracer.getInstance().println(this.dirName + " does not exists, will create it");
            this.rootLocation.mkdirs();
        }
        if ((out = new File(this.dirName + File.separator + fileName)).exists()) {
            out.renameTo(new File(this.dirName + File.separator + fileName + ".bk"));
            out = new File(this.dirName + File.separator + fileName);
        }
        out.createNewFile();
        this.foStream = new FileOutputStream(out);
        Tracer.getInstance().println(this.dirName + File.separator + fileName + " created");
    }

    public void store(String fileName, Object o) throws IOException {
        this.create(fileName);
        this.print(o);
    }

    public void add(String fileName, Object o) throws IOException, FileNotFoundException {
        if (!new File(this.dirName + File.separator + fileName).exists()) {
            throw new FileNotFoundException("File not found " + fileName);
        }
        if (fileName.equals(this.fileName)) {
            this.setFileName(fileName);
            File out = new File(this.dirName + File.separator + fileName);
            this.foStream = new FileOutputStream(out);
            System.out.println(this.fileName + " != " + fileName);
        }
        this.print(o);
    }

    public void close() throws IOException {
        try {
            this.foStream.close();
            this.fiStream.close();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void print(Object o) throws IOException {
        if (o instanceof String) {
            this.fOut = new PrintWriter(this.foStream, true);
            this.fOut.println((String)o);
            if (this.fOut.checkError()) {
                throw new IOException("Could not write in the file " + this.dirName + File.separator + this.fileName);
            }
        } else {
            this.sOut = new ObjectOutputStream(this.foStream);
            this.sOut.writeObject(o);
        }
    }

    public boolean fileExists(String fileName) {
        File f = new File(this.dirName + File.separator + fileName);
        return f.exists();
    }

    public boolean pathExists() {
        return this.rootLocation.exists();
    }

    public long length(String fileName) throws FileNotFoundException {
        File f = new File(this.dirName + File.separator + fileName);
        return f.length();
    }

    public String getDirName() {
        return this.dirName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public OutputStream getOutputStream() {
        return this.foStream;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
        this.rootLocation = new File(dirName);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    void clear() throws FileNotFoundException {
        if (!this.rootLocation.exists()) {
            throw new FileNotFoundException("directory " + this.dirName + " does not exist");
        }
        File[] filesList = this.rootLocation.listFiles();
        if (filesList.length != 0) {
            for (int i = 0; i < filesList.length; ++i) {
                filesList[i].delete();
            }
        }
        this.rootLocation.delete();
    }

    void delete(String fileName) throws FileNotFoundException {
        File f = new File(this.dirName + File.separator + fileName);
        if (!f.exists()) {
            throw new FileNotFoundException("File " + fileName + " does not exist in the default location");
        }
        f.delete();
    }
}

