/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil;

import com.ibm.jutil.DefaultProperties;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import java.util.Enumeration;

public class JUtilPropertiesViewer {
    public static void main(String[] args) {
        try {
            DefaultProperties props = new DefaultProperties();
            props.loadProperties();
            Enumeration propNames = props.getPropertyNames();
            System.out.println("com.ibm.jutil defined Java properties:");
            System.out.println("<!-- name = \"propName\" value = \"propValue\" -->");
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                String propValue = props.getPropertyString(propName);
                System.out.println("<name = \"" + propName + "\"" + " value = \"" + propValue + "\" />");
            }
        }
        catch (Throwable e) {
            Tracer tracer = TracerFactory.getInstance().createTracer("jutil", "JUtilPropertiesViewer");
            if (tracer.isOn()) {
                tracer.println("Failed to print JutilProperties.");
                tracer.print(e);
            }
            e.printStackTrace();
            System.exit(0);
        }
    }
}

