/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil;

import com.ibm.jutil.tracing.Tracer;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Resource {
    private static ResourceBundle resourceBundle = null;

    private Resource() {
    }

    public static String getString(String key) {
        try {
            return Resource.getResourceBundle().getString(key);
        }
        catch (MissingResourceException mre) {
            Tracer.getInstance().println("[Resource]" + mre);
            return "";
        }
    }

    public static ResourceBundle getResourceBundle() {
        if (resourceBundle == null) {
            resourceBundle = ResourceBundle.getBundle("com.ibm.jutil.res.text.JUtilResources", Locale.getDefault());
            Tracer.getInstance().println("[Resource]Using locale: " + resourceBundle.getLocale());
        }
        return resourceBundle;
    }

    public static void setLocale(Locale locale) {
        resourceBundle = ResourceBundle.getBundle("com.ibm.jutil.res.text.JUtilResources", locale);
        Tracer.getInstance().println("[Resource]Using locale: " + resourceBundle.getLocale());
    }
}

