/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil;

import com.ibm.jutil.Timerable;

public final class Timer
implements Runnable {
    private Thread timerThread = new Thread(this);
    private Timerable timerable = null;
    private long time = 0L;
    private long timeLeft = 0L;
    private boolean started = false;
    private boolean timerReset = false;
    private Object waitObj = new Object();

    public Timer(Timerable timerable) {
        this.setTimerable(timerable);
        this.timerThread.setPriority(10);
        this.timerThread.start();
    }

    public Timer(Timerable timerable, int time) throws IllegalArgumentException {
        this(timerable);
        this.setTime(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            long startTime = 0L;
            long endTime = 0L;
            boolean interrupted = false;
            this.timerReset = false;
            while (!this.started) {
                Object object = this.waitObj;
                synchronized (object) {
                    try {
                        this.waitObj.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            try {
                startTime = System.currentTimeMillis();
                Thread.sleep(this.timeLeft);
            }
            catch (InterruptedException e) {
                if (this.timerReset) {
                    this.timeLeft = this.time;
                } else {
                    endTime = System.currentTimeMillis();
                    this.timeLeft -= endTime - startTime;
                }
                interrupted = true;
            }
            this.started = false;
            if (interrupted) continue;
            this.timeLeft = 0L;
            this.timerable.timerExpired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        this.started = true;
        Object object = this.waitObj;
        synchronized (object) {
            this.waitObj.notifyAll();
        }
    }

    public synchronized void stop() {
        if (this.timerThread.isAlive()) {
            this.timerThread.interrupt();
        }
    }

    public synchronized void reset() {
        this.timerReset = true;
        this.stop();
    }

    public synchronized void setTime(int i) throws IllegalArgumentException {
        if (i < 0) {
            throw new IllegalArgumentException();
        }
        this.timeLeft = this.time = (long)i;
    }

    public synchronized boolean getStarted() {
        return this.started;
    }

    public synchronized long getTimeLeft() {
        return this.timeLeft;
    }

    public synchronized long getTime() {
        return this.time;
    }

    private void setTimerable(Timerable t) {
        this.timerable = t;
    }
}

