/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil.logging;

import com.ibm.jutil.logging.LogEntry;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DefaultLogEntry
implements Serializable,
LogEntry {
    protected Date dateStamp = new Date(System.currentTimeMillis());
    protected int id = 0;
    protected String message = "";
    protected Object data = null;
    protected int priority = 0;
    protected String category = "";
    public static final String ID_FIELD = "ID: ";
    public static final String MESSAGE_FIELD = "message: ";
    public static final String DATESTAMP_FIELD = "date stamp: ";
    public static final String FIELD_SEPARATOR = ", ";
    public static final String LOGENTRY_SEPARATOR = "-------------------------------------------------";

    public int getCode() {
        return this.id;
    }

    public int getIndex() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getData() {
        return this.data;
    }

    public Date getDate() {
        return this.dateStamp;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getCategory() {
        return this.category;
    }

    public void setDate(Date date) {
        this.dateStamp = date;
    }

    public void setCode(int id) {
        this.id = id;
    }

    public void setIndex(int id) {
        this.id = id;
    }

    public void setDateToNow() {
        this.dateStamp = new Date(System.currentTimeMillis());
    }

    public void setPriority(int prior) {
        this.priority = prior;
    }

    public void setCategory(String name) {
        this.category = name;
    }

    public void setMessage(String s) {
        this.message = s;
    }

    public void setData(Object obj) {
        this.data = obj;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n-------------------------------------------------\n");
        sb.append(ID_FIELD + this.getCode() + FIELD_SEPARATOR);
        sb.append(this.getPriority() + FIELD_SEPARATOR);
        sb.append(MESSAGE_FIELD + this.getMessage() + "\n\n");
        sb.append(new SimpleDateFormat().format(this.dateStamp) + " ");
        return sb.toString();
    }

    public String display() {
        return this.toString();
    }

    public void clear() {
        this.id = 0;
        this.priority = 0;
        this.dateStamp = new Date(System.currentTimeMillis());
        this.message = "";
        this.data = null;
    }

    public LogEntry makeClone() {
        DefaultLogEntry entry = new DefaultLogEntry();
        entry.setDate(this.getDate());
        entry.setCode(this.getCode());
        entry.setData(this.getData());
        entry.setIndex(this.getIndex());
        entry.setMessage(this.getMessage());
        entry.setCategory(this.getCategory());
        entry.setPriority(this.getPriority());
        return entry;
    }
}

