/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil.logging;

import com.ibm.jutil.DefaultProperties;
import com.ibm.jutil.logging.LogEntry;
import com.ibm.jutil.logging.LogEntryFactory;
import com.ibm.jutil.logging.LogHelper;
import com.ibm.jutil.logging.Logger;
import com.ibm.jutil.logging.LoggerProperties;

public class DefaultLogHelper
implements LogHelper {
    private static LogHelper instance = null;
    private Logger logger = this.getLogger();
    private LogEntryFactory logEntryFactory = null;
    private LogEntry logEntry = null;
    boolean allLoggingOff;
    boolean loggingPrinter;
    boolean loggingScanner;
    boolean loggingLineDisplay;
    boolean loggingMSR;
    boolean loggingPOSKeyboard;
    boolean loggingKeylock;
    boolean loggingToneIndicator;
    boolean loggingCashDrawer;
    boolean loggingAllDevices;
    boolean loggingUniversalSerialBus;
    boolean loggingMICR;
    int logAllPriorityAbove;
    int logAllPriorityBelow;
    boolean loggingDEBUGPriority;
    boolean loggingINFOPriority;
    boolean loggingWARNPriority;
    boolean loggingERRORPriority;
    boolean loggingFATALPriority;
    public static final int CODE_FILTER = 1000;
    public static final String TRUE_STRING = "true";
    public static final int NO_PRIORITY_ASSIGNED = -1;
    public static final int LOGGING_MAX = 6;

    protected DefaultLogHelper() {
        this.initFromProperties();
    }

    public static LogHelper getInstance() {
        if (instance == null) {
            instance = new DefaultLogHelper();
        }
        return instance;
    }

    public void addLogEntry(int code, String className) {
        if (this.passesThroughFilter(code, -1)) {
            this.getLogEntry().setCode(code);
            this.getLogEntry().setCategory(className);
            this.getLogger().add(this.logEntry.makeClone());
        }
    }

    public void addLogEntry(int code, String msg, String className) {
        if (this.passesThroughFilter(code, -1)) {
            this.getLogEntry().setCode(code);
            this.getLogEntry().setCategory(className);
            this.getLogEntry().setMessage(msg);
            this.getLogger().add(this.logEntry.makeClone());
        }
    }

    public void addLogEntry(int code, String msg, String className, int priority) {
        if (this.passesThroughFilter(code, priority)) {
            this.getLogEntry().setCode(code);
            this.getLogEntry().setCategory(className);
            this.getLogEntry().setPriority(priority);
            this.getLogEntry().setMessage(msg);
            this.getLogger().add(this.logEntry.makeClone());
        }
    }

    public void close() {
        this.getLogger().save();
    }

    public Logger getLogger() {
        if (null == this.logger) {
            this.logger = Logger.getInstance();
        }
        return this.logger;
    }

    private LogEntryFactory getLogEntryFactory() {
        if (null == this.logEntryFactory) {
            this.logEntryFactory = this.logger.getLogEntryFactory();
        }
        return this.logEntryFactory;
    }

    private LogEntry getLogEntry() {
        if (null == this.logEntry) {
            this.logEntry = this.getLogEntryFactory().createLogEntry();
        }
        return this.logEntry;
    }

    private boolean passesThroughFilter(int code, int priority) {
        if (-1 == priority) {
            priority = 4;
        }
        if (this.allLoggingOff) {
            return false;
        }
        int dividedCode = code / 1000;
        switch (dividedCode) {
            case 1: {
                if (this.loggingAllDevices) break;
                return false;
            }
            case 2: {
                if (this.loggingUniversalSerialBus) break;
                return false;
            }
            case 3: {
                if (this.loggingPrinter) break;
                return false;
            }
            case 4: {
                if (this.loggingScanner) break;
                return false;
            }
            case 5: {
                if (this.loggingLineDisplay) break;
                return false;
            }
            case 6: {
                if (this.loggingMSR) break;
                return false;
            }
            case 7: {
                if (this.loggingPOSKeyboard) break;
                return false;
            }
            case 8: {
                if (this.loggingKeylock) break;
                return false;
            }
            case 9: {
                if (this.loggingToneIndicator) break;
                return false;
            }
            case 10: {
                if (this.loggingCashDrawer) break;
                return false;
            }
            case 11: {
                if (this.loggingMICR) break;
                return false;
            }
            default: {
                this.addLogEntry(1011, "Invalid LogEntry number submitted", "AllDevices", 5);
                return false;
            }
        }
        if (this.logAllPriorityBelow != 6 || this.logAllPriorityAbove != -1) {
            return priority < this.logAllPriorityBelow && priority > this.logAllPriorityAbove;
        }
        switch (priority) {
            case 1: {
                return this.loggingDEBUGPriority;
            }
            case 2: {
                return this.loggingINFOPriority;
            }
            case 3: {
                return this.loggingWARNPriority;
            }
            case 4: {
                return this.loggingERRORPriority;
            }
            case 5: {
                return this.loggingFATALPriority;
            }
        }
        this.addLogEntry(1011, "Invalid LogEntry priority submitted", "AllDevices", 5);
        return false;
    }

    public void initFromProperties() {
        try {
            this.allLoggingOff = TRUE_STRING.equalsIgnoreCase(LoggerProperties.getProperty("com.ibm.jutil.logging.AllLoggingOff"));
            this.loggingPrinter = TRUE_STRING.equalsIgnoreCase(LoggerProperties.getProperty("com.ibm.jutil.logging.LoggingPrinter"));
            this.loggingScanner = TRUE_STRING.equalsIgnoreCase(LoggerProperties.getProperty("com.ibm.jutil.logging.LoggingScanner"));
            this.loggingLineDisplay = TRUE_STRING.equalsIgnoreCase(LoggerProperties.getProperty("com.ibm.jutil.logging.LoggingLineDisplay"));
            this.loggingMSR = TRUE_STRING.equalsIgnoreCase(LoggerProperties.getProperty("com.ibm.jutil.logging.LoggingMSR"));
            this.loggingPOSKeyboard = TRUE_STRING.equalsIgnoreCase(LoggerProperties.getProperty("com.ibm.jutil.logging.LoggingPOSKeyboard"));
            this.loggingKeylock = TRUE_STRING.equalsIgnoreCase(LoggerProperties.getProperty("com.ibm.jutil.logging.LoggingKeylock"));
            this.loggingToneIndicator = TRUE_STRING.equalsIgnoreCase(LoggerProperties.getProperty("com.ibm.jutil.logging.LoggingToneIndicator"));
            this.loggingCashDrawer = TRUE_STRING.equalsIgnoreCase(LoggerProperties.getProperty("com.ibm.jutil.logging.LoggingCashDrawer"));
            this.loggingAllDevices = TRUE_STRING.equalsIgnoreCase(LoggerProperties.getProperty("com.ibm.jutil.logging.LoggingAllDevices"));
            this.loggingUniversalSerialBus = TRUE_STRING.equalsIgnoreCase(LoggerProperties.getProperty("com.ibm.jutil.logging.LoggingUniversalSerialBus"));
            this.loggingMICR = TRUE_STRING.equalsIgnoreCase(LoggerProperties.getProperty("com.ibm.jutil.logging.LoggingMICR"));
            this.logAllPriorityAbove = Integer.parseInt(LoggerProperties.getProperty("com.ibm.jutil.logging.LogAllPriorityAbove"));
            this.logAllPriorityBelow = Integer.parseInt(LoggerProperties.getProperty("com.ibm.jutil.logging.LogAllPriorityBelow"));
            this.loggingDEBUGPriority = TRUE_STRING.equalsIgnoreCase(LoggerProperties.getProperty("com.ibm.jutil.logging.LoggingDEBUGPriority"));
            this.loggingINFOPriority = TRUE_STRING.equalsIgnoreCase(LoggerProperties.getProperty("com.ibm.jutil.logging.LoggingINFOPriority"));
            this.loggingWARNPriority = TRUE_STRING.equalsIgnoreCase(LoggerProperties.getProperty("com.ibm.jutil.logging.LoggingWARNPriority"));
            this.loggingERRORPriority = TRUE_STRING.equalsIgnoreCase(LoggerProperties.getProperty("com.ibm.jutil.logging.LoggingERRORPriority"));
            this.loggingFATALPriority = TRUE_STRING.equalsIgnoreCase(LoggerProperties.getProperty("com.ibm.jutil.logging.LoggingFATALPriority"));
            DefaultProperties props = new DefaultProperties();
            props.loadProperties();
        }
        catch (Exception e) {
            System.err.println("ERROR reading properties in DefaultLogHelper");
        }
    }
}

