/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil.logging;

import com.ibm.jutil.logging.AbstractLogStore;
import com.ibm.jutil.logging.LogEntry;
import com.ibm.jutil.logging.LogStore;
import com.ibm.jutil.logging.LoggerProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;

public class JDKLogStore
extends AbstractLogStore
implements LogStore {
    private PrintWriter fOut;
    private ObjectOutputStream sOut;
    private FileOutputStream ftxt;
    private FileOutputStream fser;
    private File dir = null;
    private String ftxtname;
    private String fsername;

    public void flush() {
        while (this.queue.size() > 0) {
            LogEntry entry = (LogEntry)this.queue.remove(0);
            try {
                this.fOut.println(entry.display());
                this.sOut.writeObject(entry);
            }
            catch (IOException e) {
            }
            catch (NullPointerException nullPointerException) {}
        }
        try {
            this.fOut.flush();
            this.sOut.flush();
        }
        catch (IOException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.addFlag = false;
        this.flushFlag = true;
    }

    private void initFromProperties() {
        String fileName = LoggerProperties.getProperty("com.ibm.jutil.logging.JDKLogStore.LogFileName", "com.ibm.jutil.logging.default.JDKLogStore.LogFileName");
        String filePath = LoggerProperties.getProperty("com.ibm.jutil.logging.JDKLogStore.LogFilePath", "com.ibm.jutil.logging.default.JDKLogStore.LogFilePath");
        this.ftxtname = filePath + File.separator + fileName + LoggerProperties.getProperty("com.ibm.jutil.logging.JDKLogStore.LogTextFileNameExt", "com.ibm.jutil.logging.default.JDKLogStore.LogTextFileNameExt");
        this.fsername = filePath + File.separator + fileName + LoggerProperties.getProperty("com.ibm.jutil.logging.JDKLogStore.LogSerFileNameExt", "com.ibm.jutil.logging.default.JDKLogStore.LogSerFileNameExt");
    }

    public void init() {
        this.initFromProperties();
        this.ftxt = null;
        this.fser = null;
        if (this.dir == null) {
            String tmp = LoggerProperties.getProperty("com.ibm.jutil.logging.JDKLogStore.LogFilePath");
            try {
                this.dir = new File(LoggerProperties.getProperty("com.ibm.jutil.logging.JDKLogStore.LogFilePath"));
                this.dir.mkdir();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        try {
            this.ftxt = new FileOutputStream(this.ftxtname);
            this.fser = new FileOutputStream(this.fsername);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.fOut = new PrintWriter(this.ftxt);
            this.sOut = new ObjectOutputStream(this.fser);
        }
        catch (IOException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void close() {
        this.flush();
        try {
            this.fOut.close();
            this.sOut.close();
        }
        catch (IOException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected PrintWriter getTextOutputStream() {
        return this.fOut;
    }

    protected ObjectOutputStream getSerOutputStream() {
        return this.sOut;
    }

    protected FileOutputStream getTextFileStream() {
        return this.ftxt;
    }

    protected FileOutputStream getSerFileStream() {
        return this.fser;
    }

    protected String getTextFileName() {
        return this.ftxtname;
    }

    protected String getSerFileName() {
        return this.fsername;
    }
}

