/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil.patterns.factory;

import com.ibm.jutil.patterns.factory.RecyclableObject;
import com.ibm.jutil.patterns.factory.RecyclableObjectHelper;
import com.ibm.jutil.patterns.factory.RecycleFactory;

public abstract class AbstractRecyclableObject
implements RecyclableObject {
    private RecyclableObjectHelper helper = null;

    public AbstractRecyclableObject(RecycleFactory recycleFactory) {
        this.helper = new RecyclableObjectHelper(recycleFactory);
    }

    public abstract void clean();

    public void recycle() {
        this.getRecycleFactory().recycle(this);
        this.helper.recycle();
    }

    public boolean isRecycled() {
        return this.helper.isRecycled();
    }

    public boolean isCleaned() {
        return this.helper.isCleaned();
    }

    public RecycleFactory getRecycleFactory() {
        return this.helper.getRecycleFactory();
    }

    public RecyclableObject.CtorArg createCtorArg(String name, Object value) throws IllegalArgumentException {
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException("RecyclableObject.CtorArg.name cannot be null or empty");
        }
        return new DefaultCtorArg(name, value);
    }

    protected RecyclableObjectHelper getRecyclableObjectHelper() {
        return this.helper;
    }

    public static class DefaultCtorArg
    implements RecyclableObject.CtorArg {
        private String name = null;
        private Object value = null;

        public DefaultCtorArg(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public Class getType() {
            return this.value.getClass();
        }
    }
}

