/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil.swing;

import com.ibm.jutil.ResourceConst;
import com.ibm.jutil.swing.PropertiesEditor;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class PropertiesDialog
extends JDialog {
    private JButton saveButton;
    private ActionListener al = new PropActionListener();
    private JTabbedPane tabProperties;
    private Tracer tracer = TracerFactory.getInstance().createGlobalTracer();
    public static final Dimension DEFAULT_SIZE = new Dimension(600, 350);

    public PropertiesDialog(JFrame parent) {
        super(parent, ResourceConst.TEXT_PROPERTIES_EDITOR, true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.createTabbedPane(), "Center");
        contentPane.add((Component)this.createButtonPanel(), "South");
        this.setSize(DEFAULT_SIZE);
        this.setDefaultCloseOperation(1);
        this.centerDialog();
    }

    public void addProperties(String[] propName) {
        PropertiesEditor propEditor = null;
        this.removeAllProperties();
        for (int i = 0; i < propName.length; ++i) {
            String tabName = propName[i];
            if (tabName.lastIndexOf(".") >= 0) {
                tabName = tabName.substring(0, tabName.lastIndexOf("."));
            }
            if (tabName.lastIndexOf(File.separator) >= 0) {
                tabName = tabName.substring(tabName.lastIndexOf(File.separator) + 1);
            }
            propEditor = new PropertiesEditor(propName[i]);
            try {
                propEditor.loadProperties();
                this.tabProperties.addTab(tabName, propEditor);
                continue;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, ResourceConst.TEXT_FILE_NOT_FOUND + " : " + propName[i], ResourceConst.WORD_ERROR, 0);
            }
        }
        if (propName.length > 0) {
            this.saveButton.setEnabled(true);
        }
    }

    public void removeAllProperties() {
        this.tabProperties.removeAll();
        this.saveButton.setEnabled(false);
    }

    public int getTabCount() {
        return this.tabProperties.getTabCount();
    }

    protected void centerDialog() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - this.getSize().width / 2, screenSize.height / 2 - this.getSize().height / 2);
    }

    protected JTabbedPane createTabbedPane() {
        this.tabProperties = new JTabbedPane();
        return this.tabProperties;
    }

    protected JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        JButton exitButton = new JButton(ResourceConst.WORD_EXIT);
        exitButton.addActionListener(this.al);
        this.saveButton = new JButton(ResourceConst.WORD_SAVE);
        this.saveButton.addActionListener(this.al);
        this.saveButton.setEnabled(false);
        panel.add(this.saveButton);
        panel.add(exitButton);
        return panel;
    }

    protected void trace(String msg) {
        this.tracer.println("[PropertiesDialog]" + msg);
    }

    void saveButtonClicked(ActionEvent e) {
        int tabSelected = this.tabProperties.getModel().getSelectedIndex();
        PropertiesEditor propEditor = null;
        try {
            propEditor = (PropertiesEditor)this.tabProperties.getSelectedComponent();
            if (propEditor != null) {
                propEditor.saveProperties();
                this.trace("Saving file: " + propEditor.getPropertiesFileName());
            }
        }
        catch (IOException io) {
            JOptionPane.showMessageDialog(this.getParent(), ResourceConst.TEXT_ERROR_SAVING_FILE + ": " + io.getMessage(), ResourceConst.WORD_ERROR, 0);
            this.trace("Error Saving file : " + e.toString());
        }
    }

    void exitButtonClicked(ActionEvent e) {
        this.setVisible(false);
    }

    class PropActionListener
    implements ActionListener {
        private String actionCmd = "";

        PropActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            this.actionCmd = e.getActionCommand();
            if (this.actionCmd.equals("")) {
                PropertiesDialog.this.trace(".PropActionListener->ignore action");
            } else if (this.actionCmd.equals(ResourceConst.WORD_SAVE)) {
                PropertiesDialog.this.saveButtonClicked(e);
            } else if (this.actionCmd.equals(ResourceConst.WORD_EXIT)) {
                PropertiesDialog.this.exitButtonClicked(e);
            }
        }
    }
}

