/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil.tracing;

import com.ibm.jutil.DefaultProperties;
import com.ibm.jutil.JUtilProperties;
import com.ibm.jutil.logging.DefaultLogHelper;
import com.ibm.jutil.patterns.factory.Factory;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerOutput;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TracerFactory
implements Factory {
    private boolean turnOnAllNamedTracersDefined = false;
    private boolean turnOnAllNamedTracers = false;
    private boolean addAllTraceSubNameDefined = false;
    private boolean addAllTraceSubName = false;
    private int tracerLevel = 2;
    private HashMap tracerMap = new HashMap();
    private HashMap namedTracerState = new HashMap();
    private Tracer globalTracer = null;
    private PrintStream printStream = null;
    private int outputFileThreshold = 200;
    private int flushFrequency = 500;
    private long fileMaxSize = 10000000L;
    private int maxFiles = 1;
    private String timeStampingFormat = "";
    private JUtilProperties props = null;
    private static TracerFactory instance = null;
    public static final String ADD_ALL_TRACE_SUBNAME_PROP_NAME = "com.ibm.jutil.tracing.AddAllTraceSubName";
    public static final String TRACER_PROP_NAME = "com.ibm.jutil.tracing.Tracer";
    public static final String TURN_ON_NAMED_TRACERS_PROP_NAME = "com.ibm.jutil.tracing.TurnOnNamedTracers";
    public static final String TURN_ON_ALL_NAMED_TRACERS_PROP_NAME = "com.ibm.jutil.tracing.TurnOnAllNamedTracers";
    public static final String TRACER_LEVEL_PROP_NAME = "com.ibm.jutil.tracing.TracerLevel";
    public static final String TRACER_OUTPUT_TO_PROP_NAME = "com.ibm.jutil.tracing.TracerOutputTo";
    public static final String TRACER_OUTPUT_FILE_NAME_PROP_NAME = "com.ibm.jutil.tracing.TracerOutputFileName";
    public static final String TRACER_OUTPUT_FILE_LOCATION_PROP_NAME = "com.ibm.jutil.tracing.TracerOutputFileLocation";
    public static final String TRACER_OUTPUT_FILE_THRESHOLD_PROP_NAME = "com.ibm.jutil.tracing.TracerOutputFileThreshold";
    public static final String TRACER_OUTPUT_FILE_FLUSH_FREQUENCY_PROP_NAME = "com.ibm.jutil.tracing.TracerOutputFileFlushFrequency";
    public static final String TRACER_OUTPUT_FILE_MAX_SIZE_PROP_NAME = "com.ibm.jutil.tracing.TracerOutputFileMaxSize";
    public static final String TRACER_OUTPUT_FILE_MAX_FILES_PROP_NAME = "com.ibm.jutil.tracing.TracerOutputFileMaxFiles";
    public static final String TIMESTAMPING_PROP_NAME = "com.ibm.jutil.tracing.TimeStampFormat";
    public static final String USER_HOME_LOCATION_VALUE = "~";
    public static final String FILE_LOCATION_DEFAULT_VALUE = System.getProperty("user.home") + File.separator + ".jutil";
    public static final String FILE_NAME_DEFAULT_VALUE = "traceroutput.txt";
    public static final int THRESHOLD_DEFAULT_VALUE = 200;
    public static final int FILE_FLUSH_FREQUENCY = 500;
    public static final long MAX_FILE_SIZE = 10000000L;
    public static final int MAX_FILES = 1;

    protected TracerFactory() {
    }

    public static TracerFactory getInstance() {
        if (instance == null) {
            instance = new TracerFactory();
            instance.init();
        }
        return instance;
    }

    public String getJutilPropertyPath() {
        return this.props.getPropertyFilePath();
    }

    public void enableAllTracing(boolean b) {
        this.turnOnAllNamedTracers = this.turnOnAllNamedTracersDefined = b;
        Iterator namedTracers = this.tracerMap.values().iterator();
        while (namedTracers.hasNext()) {
            try {
                Tracer tracer = (Tracer)namedTracers.next();
                tracer.setOn(this.turnOnAllNamedTracersDefined);
            }
            catch (Exception e) {
                this.globalTracer.print(e);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<TracerFactory>\n");
        sb.append("\t<jutil.property file> = " + this.getJutilPropertyPath());
        sb.append("\n\t<globalTracer state=\"" + this.globalTracer.isOn() + "\"/>\n");
        Iterator namedTracers = this.tracerMap.values().iterator();
        while (namedTracers.hasNext()) {
            Tracer tracer = (Tracer)namedTracers.next();
            sb.append("\t<namedTracer name=\"" + tracer.getName() + "\" state=\"" + tracer.isOn() + "\"/>\n");
        }
        sb.append("\t<properties>\n");
        String indent = "\t\t";
        this.appendPropToStringBuffer(TRACER_PROP_NAME, sb, indent);
        this.appendNamedTracersToStringBuffer(sb, indent);
        this.appendPropToStringBuffer(TURN_ON_NAMED_TRACERS_PROP_NAME, sb, indent);
        this.appendPropToStringBuffer(TURN_ON_ALL_NAMED_TRACERS_PROP_NAME, sb, indent);
        this.appendPropToStringBuffer(ADD_ALL_TRACE_SUBNAME_PROP_NAME, sb, indent);
        this.appendPropToStringBuffer("com.ibm.jutil.tracing.TracerLevel-" + this.getAllTracersLevel(), sb, indent);
        this.appendPropToStringBuffer(TRACER_OUTPUT_TO_PROP_NAME, sb, indent);
        this.appendPropToStringBuffer(TRACER_OUTPUT_FILE_LOCATION_PROP_NAME, sb, indent);
        this.appendPropToStringBuffer(TRACER_OUTPUT_FILE_NAME_PROP_NAME, sb, indent);
        this.appendPropToStringBuffer(TRACER_OUTPUT_FILE_THRESHOLD_PROP_NAME, sb, indent);
        this.appendPropToStringBuffer(TRACER_OUTPUT_FILE_FLUSH_FREQUENCY_PROP_NAME, sb, indent);
        this.appendPropToStringBuffer(TRACER_OUTPUT_FILE_MAX_SIZE_PROP_NAME, sb, indent);
        this.appendPropToStringBuffer(TRACER_OUTPUT_FILE_MAX_FILES_PROP_NAME, sb, indent);
        this.appendPropToStringBuffer(TIMESTAMPING_PROP_NAME, sb, indent);
        sb.append("\t</properties>\n");
        sb.append("\n<TracerFactory>");
        return sb.toString();
    }

    private void appendNamedTracersToStringBuffer(StringBuffer sb, String indent) {
        Enumeration propNames = this.props.getPropertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            if (!propName.startsWith("com.ibm.jutil.tracing.Tracer.")) continue;
            this.appendPropToStringBuffer(propName, sb, indent);
        }
    }

    private void appendPropToStringBuffer(String propName, StringBuffer sb, String indent) {
        String value = "";
        if (this.props.isPropertyDefined(propName)) {
            value = this.props.getPropertyString(propName);
        }
        sb.append(indent + "<prop name=\"" + propName + "\" value=\"" + value + "\"/>\n");
    }

    public void setOutputFileThreshold(int i) throws IllegalArgumentException {
        if (i <= 0) {
            throw new IllegalArgumentException("OutputFileThreshold must be > 0");
        }
        this.outputFileThreshold = i;
    }

    public void setOutputFile(File file) throws IOException {
        TracerOutput fileTracerOutput = this.createGlobalTracer().createFileTracerOutput(file, this.outputFileThreshold, true, this.flushFrequency, this.fileMaxSize, this.maxFiles);
        this.setCommonTracerOutput(fileTracerOutput);
    }

    public void setCommonTracerOutput(TracerOutput tracerOutput) {
        Tracer.setCommonTracerOutput(tracerOutput);
    }

    public Tracer createGlobalTracer() {
        if (this.globalTracer == null) {
            this.globalTracer = this.createTracer("GlobalTracer");
        }
        return this.globalTracer;
    }

    public Tracer createGlobalTracer(boolean b) {
        this.globalTracer.setOn(b);
        return this.globalTracer;
    }

    public Tracer createTracer(String name) {
        return this.createTracer(name, "");
    }

    public Tracer createTracer(String name, String subName) {
        String tracerMapName = name + subName;
        if (this.tracerMap.containsKey(tracerMapName)) {
            return (Tracer)this.tracerMap.get(tracerMapName);
        }
        Tracer tracer = new Tracer(name, subName);
        tracer.setTraceLevel(this.getAllTracersLevel());
        tracer.setTimeStampFormat(this.getStamps());
        if (this.namedTracerState.containsKey(name)) {
            tracer.setOn((Boolean)this.namedTracerState.get(name));
        } else {
            tracer.setOn(false);
        }
        this.tracerMap.put(tracerMapName, tracer);
        if (this.turnOnAllNamedTracersDefined) {
            tracer.setOn(this.turnOnAllNamedTracers);
        }
        if (this.addAllTraceSubNameDefined) {
            tracer.setAppendSubName(this.addAllTraceSubName);
        }
        return tracer;
    }

    public Tracer createTracer(String name, boolean b) {
        Tracer tracer = this.createTracer(name);
        tracer.setOn(b);
        if (this.turnOnAllNamedTracersDefined) {
            tracer.setOn(this.turnOnAllNamedTracers);
        }
        return tracer;
    }

    protected void finalize() {
        if (this.printStream != null) {
            this.printStream.close();
        }
        if (this.globalTracer != null && this.globalTracer.getTracerOutput() != null) {
            this.globalTracer.getTracerOutput().close();
        }
    }

    private void init() {
        this.props = new DefaultProperties();
        this.props.loadProperties();
        this.createGlobalTracer();
        this.initTracerLevel(this.props);
        this.initTimeStamp(this.props);
        this.initTurnedOnTracers(this.props);
        this.initNamedTracers(this.props);
        this.initTracerOutput(this.props);
        this.globalTracer.println("jutil.properties file = " + this.props.getPropertyFilePath());
    }

    private void initTurnedOnTracers(JUtilProperties props) {
        if (props.isPropertyDefined(TURN_ON_NAMED_TRACERS_PROP_NAME)) {
            List turnOnNamedTracersList = props.getStringListProperty(TURN_ON_NAMED_TRACERS_PROP_NAME);
            for (int i = 0; i < turnOnNamedTracersList.size(); ++i) {
                String tracerName = turnOnNamedTracersList.get(i).toString();
                this.namedTracerState.put(tracerName, Boolean.TRUE);
            }
        }
    }

    private void initNamedTracers(JUtilProperties props) {
        Enumeration propNames = props.getPropertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            if (!propName.startsWith(TRACER_PROP_NAME)) continue;
            String name = propName.substring("com.ibm.jutil.tracing.Tracer.".length(), propName.length());
            if (!props.isPropertyDefined(propName)) continue;
            String propValue = props.getPropertyString(propName);
            if (propValue.equalsIgnoreCase("ON") || propValue.equalsIgnoreCase("TRUE")) {
                this.namedTracerState.put(name, Boolean.TRUE);
                continue;
            }
            this.namedTracerState.put(name, Boolean.FALSE);
        }
        this.initAllNamedTracers(props);
    }

    private void initAllNamedTracers(JUtilProperties props) {
        if (props.isPropertyDefined(TURN_ON_ALL_NAMED_TRACERS_PROP_NAME)) {
            this.turnOnAllNamedTracersDefined = true;
            this.turnOnAllNamedTracers = props.getBooleanProperty(TURN_ON_ALL_NAMED_TRACERS_PROP_NAME);
        }
        if (props.isPropertyDefined(ADD_ALL_TRACE_SUBNAME_PROP_NAME)) {
            this.addAllTraceSubNameDefined = true;
            this.addAllTraceSubName = props.getBooleanProperty(ADD_ALL_TRACE_SUBNAME_PROP_NAME);
        }
    }

    private void initTracerOutput(JUtilProperties props) {
        String tracerToFile = props.getPropertyString(TRACER_OUTPUT_TO_PROP_NAME);
        if (props.isPropertyDefined(TRACER_OUTPUT_TO_PROP_NAME) && tracerToFile.equalsIgnoreCase("File")) {
            this.initFileTracerOutput(props);
        } else if (props.isPropertyDefined(TRACER_OUTPUT_TO_PROP_NAME) && tracerToFile.equalsIgnoreCase("Logging")) {
            this.initLoggingTracerOutput(props);
        }
    }

    private void initLoggingTracerOutput(JUtilProperties props) {
        Tracer tracer = this.createGlobalTracer();
        tracer.setAppendName(false);
        this.setCommonTracerOutput(tracer.createLogTracerOutput(DefaultLogHelper.getInstance()));
    }

    private void initFileTracerOutput(JUtilProperties props) {
        try {
            File directory;
            String fileLocation = FILE_LOCATION_DEFAULT_VALUE;
            String fileName = FILE_NAME_DEFAULT_VALUE;
            int threshold = 200;
            if (props.isPropertyDefined(TRACER_OUTPUT_FILE_LOCATION_PROP_NAME)) {
                fileLocation = props.getPropertyString(TRACER_OUTPUT_FILE_LOCATION_PROP_NAME);
            }
            if (props.isPropertyDefined(TRACER_OUTPUT_FILE_NAME_PROP_NAME)) {
                fileName = props.getPropertyString(TRACER_OUTPUT_FILE_NAME_PROP_NAME);
            }
            if (props.isPropertyDefined(TRACER_OUTPUT_FILE_THRESHOLD_PROP_NAME)) {
                threshold = props.getIntProperty(TRACER_OUTPUT_FILE_THRESHOLD_PROP_NAME);
            }
            if (props.isPropertyDefined(TRACER_OUTPUT_FILE_FLUSH_FREQUENCY_PROP_NAME)) {
                this.flushFrequency = props.getIntProperty(TRACER_OUTPUT_FILE_FLUSH_FREQUENCY_PROP_NAME);
            }
            if (props.isPropertyDefined(TRACER_OUTPUT_FILE_MAX_SIZE_PROP_NAME) && props.getIntProperty(TRACER_OUTPUT_FILE_MAX_SIZE_PROP_NAME) >= 0) {
                this.fileMaxSize = props.getIntProperty(TRACER_OUTPUT_FILE_MAX_SIZE_PROP_NAME);
            }
            if (props.isPropertyDefined(TRACER_OUTPUT_FILE_MAX_FILES_PROP_NAME) && props.getIntProperty(TRACER_OUTPUT_FILE_MAX_FILES_PROP_NAME) >= 2) {
                this.maxFiles = props.getIntProperty(TRACER_OUTPUT_FILE_MAX_FILES_PROP_NAME);
            }
            if (fileLocation.startsWith(USER_HOME_LOCATION_VALUE)) {
                fileLocation = System.getProperty("user.home") + fileLocation.substring(1);
            }
            if (!(directory = new File(fileLocation)).exists()) {
                directory.mkdirs();
            }
            File tracerOutputFile = new File(fileLocation + File.separator + fileName);
            this.setOutputFileThreshold(threshold);
            this.setOutputFile(tracerOutputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("[TracerFactory]Unexpected exception message= " + e.getMessage());
        }
    }

    private void initTracerLevel(JUtilProperties props) {
        String tracerToFile = props.getPropertyString(TRACER_LEVEL_PROP_NAME);
        if (tracerToFile == null) {
            this.setAllTracersLevel(2);
            return;
        }
        tracerToFile.trim();
        if (tracerToFile.equalsIgnoreCase("Minimum")) {
            this.setAllTracersLevel(1);
        } else if (tracerToFile.equalsIgnoreCase("Maximum")) {
            this.setAllTracersLevel(3);
        } else {
            this.setAllTracersLevel(2);
        }
    }

    private void initTimeStamp(JUtilProperties props) {
        String timeStamp = props.getPropertyString(TIMESTAMPING_PROP_NAME);
        if (timeStamp == null) {
            this.setStamp("DATE");
            return;
        }
        timeStamp.trim();
        if (props.isPropertyDefined(TIMESTAMPING_PROP_NAME)) {
            if (timeStamp.equalsIgnoreCase("MSECS")) {
                this.setStamp("MSECS");
            } else if (timeStamp.equalsIgnoreCase("DATE")) {
                this.setStamp("DATE");
            } else {
                this.setStamp("DATE");
            }
        }
    }

    private void setAllTracersLevel(int level) {
        this.tracerLevel = level;
    }

    private void setStamp(String stampingFormat) {
        this.timeStampingFormat = stampingFormat;
    }

    private int getAllTracersLevel() {
        return this.tracerLevel;
    }

    private String getStamps() {
        return this.timeStampingFormat;
    }
}

