/*
 * Decompiled with CFR 0.152.
 */
package de.ailis.usb4java;

import de.ailis.usb4java.Configuration;
import de.ailis.usb4java.ControlIrpQueue;
import de.ailis.usb4java.DeviceId;
import de.ailis.usb4java.DeviceListenerList;
import de.ailis.usb4java.DeviceManager;
import de.ailis.usb4java.Hub;
import de.ailis.usb4java.Services;
import de.ailis.usb4java.descriptors.SimpleUsbStringDescriptor;
import de.ailis.usb4java.libusb.ConfigDescriptor;
import de.ailis.usb4java.libusb.Device;
import de.ailis.usb4java.libusb.DeviceHandle;
import de.ailis.usb4java.libusb.LibUsb;
import de.ailis.usb4java.libusb.LibUsbException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.usb.UsbClaimException;
import javax.usb.UsbConst;
import javax.usb.UsbControlIrp;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbException;
import javax.usb.UsbPort;
import javax.usb.UsbStringDescriptor;
import javax.usb.event.UsbDeviceEvent;
import javax.usb.event.UsbDeviceListener;
import javax.usb.util.DefaultUsbControlIrp;

abstract class AbstractDevice
implements UsbDevice {
    private final DeviceManager manager;
    private final DeviceId id;
    private final DeviceId parentId;
    private final int speed;
    private List<Configuration> configurations;
    private Map<Byte, Configuration> configMapping = new HashMap<Byte, Configuration>();
    private final DeviceListenerList listeners = new DeviceListenerList();
    private DeviceHandle handle;
    private byte activeConfigurationNumber = 0;
    private Byte claimedInterfaceNumber = null;
    private UsbPort port;
    private final ControlIrpQueue queue = new ControlIrpQueue(this, this.listeners);
    private boolean detachedKernelDriver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractDevice(DeviceManager manager, DeviceId id, DeviceId parentId, int speed, Device device) throws LibUsbException {
        if (manager == null) {
            throw new IllegalArgumentException("manager must be set");
        }
        if (id == null) {
            throw new IllegalArgumentException("id must be set");
        }
        this.manager = manager;
        this.id = id;
        this.parentId = parentId;
        this.speed = speed;
        int numConfigurations = id.getDeviceDescriptor().bNumConfigurations() & 0xFF;
        ArrayList<Configuration> configurations = new ArrayList<Configuration>(numConfigurations);
        for (int i = 0; i < numConfigurations; ++i) {
            ConfigDescriptor configDescriptor = new ConfigDescriptor();
            int result = LibUsb.getConfigDescriptor(device, i, configDescriptor);
            if (result < 0) {
                throw new LibUsbException("Unable to get configuation " + i + " for device " + id, result);
            }
            try {
                Configuration config = new Configuration(this, configDescriptor);
                configurations.add(config);
                this.configMapping.put(configDescriptor.bConfigurationValue(), config);
                continue;
            }
            finally {
                LibUsb.freeConfigDescriptor(configDescriptor);
            }
        }
        this.configurations = Collections.unmodifiableList(configurations);
        ConfigDescriptor configDescriptor = new ConfigDescriptor();
        int result = LibUsb.getActiveConfigDescriptor(device, configDescriptor);
        if (result == -5 || result == -2) {
            this.activeConfigurationNumber = 0;
        } else {
            if (result < 0) {
                throw new LibUsbException("Unable to read active config descriptor from device " + id, result);
            }
            this.activeConfigurationNumber = configDescriptor.bConfigurationValue();
            LibUsb.freeConfigDescriptor(configDescriptor);
        }
    }

    public final DeviceId getId() {
        return this.id;
    }

    public final DeviceId getParentId() {
        return this.parentId;
    }

    final void checkConnected() {
        if (this.port == null) {
            throw new UsbDisconnectedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DeviceHandle open() throws UsbException {
        if (this.handle == null) {
            Device device = this.manager.getLibUsbDevice(this.id);
            try {
                DeviceHandle handle = new DeviceHandle();
                int result = LibUsb.open(device, handle);
                if (result < 0) {
                    throw new LibUsbException("Can't open device " + this.id, result);
                }
                this.handle = handle;
            }
            finally {
                this.manager.releaseDevice(device);
            }
        }
        return this.handle;
    }

    public final void close() {
        if (this.handle != null) {
            LibUsb.close(this.handle);
            this.handle = null;
        }
    }

    @Override
    public final UsbPort getParentUsbPort() {
        this.checkConnected();
        return this.port;
    }

    final void setParentUsbPort(UsbPort port) {
        if (this.port == null && port == null) {
            throw new IllegalStateException("Device already detached");
        }
        if (this.port != null && port != null) {
            throw new IllegalStateException("Device already attached");
        }
        if (port == null && this.isUsbHub()) {
            Hub hub = (Hub)this;
            for (AbstractDevice device : hub.getAttachedUsbDevices()) {
                hub.disconnectUsbDevice(device);
            }
        }
        this.port = port;
        Services services = Services.getInstance();
        if (port == null) {
            this.listeners.usbDeviceDetached(new UsbDeviceEvent(this));
            services.usbDeviceDetached(this);
        } else {
            services.usbDeviceAttached(this);
        }
    }

    @Override
    public final String getManufacturerString() throws UsbException, UnsupportedEncodingException {
        this.checkConnected();
        byte index = this.getUsbDeviceDescriptor().iManufacturer();
        if (index == 0) {
            return null;
        }
        return this.getString(index);
    }

    @Override
    public final String getSerialNumberString() throws UsbException, UnsupportedEncodingException {
        this.checkConnected();
        byte index = this.getUsbDeviceDescriptor().iSerialNumber();
        if (index == 0) {
            return null;
        }
        return this.getString(index);
    }

    @Override
    public final String getProductString() throws UsbException, UnsupportedEncodingException {
        this.checkConnected();
        byte index = this.getUsbDeviceDescriptor().iProduct();
        if (index == 0) {
            return null;
        }
        return this.getString(index);
    }

    @Override
    public final Object getSpeed() {
        switch (this.speed) {
            case 2: {
                return UsbConst.DEVICE_SPEED_FULL;
            }
            case 1: {
                return UsbConst.DEVICE_SPEED_LOW;
            }
        }
        return UsbConst.DEVICE_SPEED_UNKNOWN;
    }

    @Override
    public final List<Configuration> getUsbConfigurations() {
        return this.configurations;
    }

    @Override
    public final Configuration getUsbConfiguration(byte number) {
        return this.configMapping.get(number);
    }

    @Override
    public final boolean containsUsbConfiguration(byte number) {
        return this.configMapping.containsKey(number);
    }

    @Override
    public final byte getActiveUsbConfigurationNumber() {
        return this.activeConfigurationNumber;
    }

    final void setActiveUsbConfigurationNumber(byte number) throws UsbException {
        if (number != this.activeConfigurationNumber) {
            if (this.claimedInterfaceNumber != null) {
                throw new UsbException("Can't change configuration while an interface is still claimed");
            }
            int result = LibUsb.setConfiguration(this.open(), number & 0xFF);
            if (result < 0) {
                throw new LibUsbException("Unable to set configuration", result);
            }
            this.activeConfigurationNumber = number;
        }
    }

    final void claimInterface(byte number, boolean force) throws UsbException {
        int result;
        if (this.claimedInterfaceNumber != null) {
            throw new UsbClaimException("An interface is already claimed");
        }
        DeviceHandle handle = this.open();
        if (force) {
            result = LibUsb.kernelDriverActive(handle, number);
            if (result == -4) {
                throw new UsbDisconnectedException();
            }
            if (result == 1) {
                result = LibUsb.detachKernelDriver(handle, number);
                if (result < 0) {
                    throw new LibUsbException("Unable to detach kernel driver", result);
                }
                this.detachedKernelDriver = true;
            }
        }
        if ((result = LibUsb.claimInterface(handle, number & 0xFF)) < 0) {
            throw new LibUsbException("Unable to claim interface", result);
        }
        this.claimedInterfaceNumber = number;
    }

    final void releaseInterface(byte number) throws UsbException {
        if (this.claimedInterfaceNumber == null) {
            throw new UsbClaimException("No interface is claimed");
        }
        if (!Byte.valueOf(number).equals(this.claimedInterfaceNumber)) {
            throw new UsbClaimException("Interface not claimed");
        }
        DeviceHandle handle = this.open();
        int result = LibUsb.releaseInterface(handle, number & 0xFF);
        if (result < 0) {
            throw new LibUsbException("Unable to release interface", result);
        }
        if (this.detachedKernelDriver && (result = LibUsb.attachKernelDriver(handle, number & 0xFF)) < 0) {
            throw new LibUsbException("Uanble to re-attach kernel driver", result);
        }
        this.claimedInterfaceNumber = null;
    }

    final boolean isInterfaceClaimed(byte number) {
        return Byte.valueOf(number).equals(this.claimedInterfaceNumber);
    }

    @Override
    public final Configuration getActiveUsbConfiguration() {
        return this.getUsbConfiguration(this.getActiveUsbConfigurationNumber());
    }

    @Override
    public final boolean isConfigured() {
        return this.getActiveUsbConfigurationNumber() != 0;
    }

    @Override
    public final UsbDeviceDescriptor getUsbDeviceDescriptor() {
        return this.id.getDeviceDescriptor();
    }

    @Override
    public final UsbStringDescriptor getUsbStringDescriptor(byte index) throws UsbException {
        this.checkConnected();
        short[] languages = this.getLanguages();
        DeviceHandle handle = this.open();
        short langId = languages.length == 0 ? (short)0 : languages[0];
        ByteBuffer data = ByteBuffer.allocateDirect(256);
        int result = LibUsb.getStringDescriptor(handle, index, langId, data);
        if (result < 0) {
            throw new LibUsbException("Unable to get string descriptor " + index + " from device " + this, result);
        }
        return new SimpleUsbStringDescriptor(data);
    }

    @Override
    public final String getString(byte index) throws UsbException, UnsupportedEncodingException {
        return this.getUsbStringDescriptor(index).getString();
    }

    private short[] getLanguages() throws UsbException {
        ByteBuffer buffer;
        DeviceHandle handle = this.open();
        int result = LibUsb.getDescriptor(handle, 3, 0, buffer = ByteBuffer.allocateDirect(256));
        if (result < 0) {
            throw new LibUsbException("Unable to get string descriptor languages", result);
        }
        if (result < 2) {
            throw new UsbException("Received illegal descriptor length: " + result);
        }
        short[] languages = new short[(result - 2) / 2];
        if (languages.length == 0) {
            return languages;
        }
        buffer.position(2);
        buffer.order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(languages);
        return languages;
    }

    @Override
    public final void syncSubmit(UsbControlIrp irp) throws UsbException {
        if (irp == null) {
            throw new IllegalArgumentException("irp must not be null");
        }
        this.checkConnected();
        this.queue.add(irp);
        irp.waitUntilComplete();
        if (irp.isUsbException()) {
            throw irp.getUsbException();
        }
    }

    @Override
    public final void asyncSubmit(UsbControlIrp irp) {
        if (irp == null) {
            throw new IllegalArgumentException("irp must not be null");
        }
        this.checkConnected();
        this.queue.add(irp);
    }

    @Override
    public final void syncSubmit(List list) throws UsbException {
        if (list == null) {
            throw new IllegalArgumentException("list must not be null");
        }
        this.checkConnected();
        for (Object item : list) {
            if (!(item instanceof UsbControlIrp)) {
                throw new IllegalArgumentException("List contains non-UsbControlIrp objects");
            }
            this.syncSubmit((UsbControlIrp)item);
        }
    }

    @Override
    public final void asyncSubmit(List list) {
        if (list == null) {
            throw new IllegalArgumentException("list must not be null");
        }
        this.checkConnected();
        for (Object item : list) {
            if (!(item instanceof UsbControlIrp)) {
                throw new IllegalArgumentException("List contains non-UsbControlIrp objects");
            }
            this.asyncSubmit((UsbControlIrp)item);
        }
    }

    @Override
    public final UsbControlIrp createUsbControlIrp(byte bmRequestType, byte bRequest, short wValue, short wIndex) {
        return new DefaultUsbControlIrp(bmRequestType, bRequest, wValue, wIndex);
    }

    @Override
    public final void addUsbDeviceListener(UsbDeviceListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public final void removeUsbDeviceListener(UsbDeviceListener listener) {
        this.listeners.remove(listener);
    }

    public final String toString() {
        return this.id.toString();
    }
}

