/*
 * Decompiled with CFR 0.152.
 */
package de.ailis.usb4java.descriptors;

import de.ailis.usb4java.descriptors.SimpleUsbDescriptor;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.usb.UsbStringDescriptor;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class SimpleUsbStringDescriptor
extends SimpleUsbDescriptor
implements UsbStringDescriptor {
    private static final long serialVersionUID = 1L;
    private final byte[] bString;

    public SimpleUsbStringDescriptor(ByteBuffer data) {
        super(data.get(0), data.get(1));
        data.position(2);
        this.bString = new byte[this.bLength() - 2];
        data.get(this.bString);
    }

    public SimpleUsbStringDescriptor(byte bLength, byte bDescriptorType, String string) throws UnsupportedEncodingException {
        super(bLength, bDescriptorType);
        this.bString = string.getBytes("UTF-16LE");
    }

    public SimpleUsbStringDescriptor(UsbStringDescriptor descriptor) {
        super(descriptor.bLength(), descriptor.bDescriptorType());
        this.bString = (byte[])descriptor.bString().clone();
    }

    @Override
    public byte[] bString() {
        return (byte[])this.bString.clone();
    }

    @Override
    public String getString() throws UnsupportedEncodingException {
        return new String(this.bString, "UTF-16LE");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleUsbStringDescriptor other = (SimpleUsbStringDescriptor)obj;
        return new EqualsBuilder().append(this.bLength(), other.bLength()).append(this.bDescriptorType(), other.bDescriptorType()).append(this.bString, other.bString).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.bDescriptorType()).append(this.bLength()).append(this.bString).toHashCode();
    }

    public String toString() {
        return new String(this.bString, Charset.forName("UTF-16LE"));
    }
}

