/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao.websocket;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.integracao.Handler;
import com.csi.ctfclient.integracao.websocket.Draft_17_Auttar;
import com.csi.ctfclient.servicos.CTFClient;
import com.csi.ctfclient.servicos.EntradaCTFClient;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.servicos.SaidaCTFClient;
import com.csi.ctfclient.tools.util.KeyStoreUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.Logger;
import org.java_websocket.WebSocket;
import org.java_websocket.drafts.Draft;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.DefaultSSLWebSocketServerFactory;
import org.java_websocket.server.WebSocketServer;

public class WebSocketHandler
extends Handler {
    protected Logger logger = CTFClientLogger.getIntegrador();
    private WebSocketServer server;
    private WebSocketServer serverConfig;
    private int port;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public WebSocketHandler(String strHost, String port) {
        this.port = Integer.parseInt(port);
    }

    public void start() {
        try {
            Draft_17_Auttar draft = new Draft_17_Auttar(new Draft_17_Auttar.PosentraHandler(){

                public void onCodigoOperacao(String operacao) {
                    String comando = "{operacao: " + operacao + "}";
                    WebSocketHandler.this.server.onMessage(null, comando);
                }
            });
            this.server = new WebSocketServer(this.port, (Draft)draft);
            this.init();
            this.server.start();
            this.logger.info((Object)"Servidor WebSocket CTFClient aberto.");
            if (this.port != 2500) {
                this.serverConfig = new WebSocketServer(2500, (Draft)draft);
                this.serverConfig.start();
                this.logger.info((Object)"porta de configuracao inicializado.");
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"Erro instanciando servi\u00e7o local", (Throwable)e);
        }
    }

    protected void init() {
        if (this.port == 4433) {
            SSLContext sslContext = null;
            try {
                String KEYPASSWORD = "websocket#$auttar";
                KeyStore ks = KeyStoreUtil.getDefaultKeyStory();
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(ks, KEYPASSWORD.toCharArray());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                tmf.init(ks);
                sslContext = SSLContext.getInstance("TLS");
                sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            }
            catch (NoSuchAlgorithmException e) {
                this.logger.error((Object)"erro: ", (Throwable)e);
            }
            catch (KeyManagementException e) {
                this.logger.error((Object)"erro: ", (Throwable)e);
            }
            catch (KeyStoreException e) {
                this.logger.error((Object)"erro: ", (Throwable)e);
            }
            catch (UnrecoverableKeyException e) {
                this.logger.error((Object)"erro: ", (Throwable)e);
            }
            this.getService().setWebSocketFactory((WebSocketServer.WebSocketServerFactory)new DefaultSSLWebSocketServerFactory(sslContext));
            this.logger.info((Object)"SSContext inicializado para WebSocket");
        }
    }

    protected WebSocketServer getService() {
        return this.server;
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            this.logger.error((Object)"nao foi possivel finalizar o servico WebSocket", (Throwable)e);
        }
        try {
            if (this.serverConfig != null) {
                this.serverConfig.stop();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"nao foi possivel finaliza a porta de configuracao", (Throwable)e);
        }
    }

    static class CupomUtil {
        public static final String CLIENTE = "CUPOMCTF.1";
        public static final String ESTABELECIMENTO = "CUPOMCTF.2";
        public static final String CLIENTE_REIMP = "CUPOMCTF.3";
        public static final String ESTABELECIMENTO_REIMP = "CUPOMCTF.4";
        public static final String CLIENTE_REIMP_TEMP = "CUPOMCTF.5";
        public static final String ESTABELECIMENTO_REIMP_TEMP = "CUPOMCTF.6";
        public static final String REDUZIDO = "REDUZIDO.1";
        public static final String CUPOMS = "CUPOMS.1";

        CupomUtil() {
        }

        public static JsonArray getCupom(String tipoCupom, EntradaCTFClient entrada) {
            JsonArray jsonArray = new JsonArray();
            try {
                ControladorConfCTFClient controladorConfCTFClient = ControladorConfCTFClient.getInstance();
                ConfCTFClient config = controladorConfCTFClient.getConfig();
                String path = ControladorConfCTFClient.getDiretorioTrabalho();
                int idxEmpresa = config.getVersaoPathTerminal() == 1 ? 0 : 1;
                path = String.valueOf(path) + config.getEstabelecimento().substring(idxEmpresa) + config.getLoja() + "." + config.getTerminal() + File.separator + tipoCupom;
                path = String.valueOf(path) + StringUtil.completaString((String)String.valueOf(entrada.getNumeroTransacao()), (int)2, (char)'0', (int)3);
                File fileCupom = new File(path);
                if (fileCupom.exists()) {
                    FileReader fReader = new FileReader(fileCupom);
                    BufferedReader bufReader = new BufferedReader(fReader);
                    String linha = null;
                    while ((linha = bufReader.readLine()) != null) {
                        JsonObject jsonObject = new JsonObject();
                        jsonObject.addProperty("linha", linha);
                        jsonArray.add((JsonElement)jsonObject);
                    }
                    bufReader.close();
                    fReader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (jsonArray.size() == 0) {
                return null;
            }
            return jsonArray;
        }
    }

    class EntradaTypeAdapter
    implements JsonDeserializer {
        EntradaTypeAdapter() {
        }

        public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            EntradaCTFClient entrada = new EntradaCTFClient();
            if (json.isJsonObject()) {
                JsonObject jsonObject = json.getAsJsonObject();
                if (this.isNotNull(jsonObject, "documento")) {
                    entrada.setNumeroCupom(jsonObject.get("documento").getAsString());
                }
                if (jsonObject.has("operacao")) {
                    entrada.setOperacao(jsonObject.get("operacao").getAsInt());
                }
                if (this.isNotNull(jsonObject, "numeroTransacao")) {
                    entrada.setNumeroTransacao(jsonObject.get("numeroTransacao").getAsInt());
                }
                if (this.isNotNull(jsonObject, "valorTransacao")) {
                    entrada.setValorTransacao(jsonObject.get("valorTransacao").getAsBigDecimal().movePointLeft(2));
                }
                if (this.isNotNull(jsonObject, "numeroParcelas")) {
                    entrada.setNumeroParcelas(jsonObject.get("numeroParcelas").getAsInt());
                }
                if (this.isNotNull(jsonObject, "nsuCTF")) {
                    entrada.setNsuCTF(jsonObject.get("nsuCTF").getAsInt());
                }
                if (this.isNotNull(jsonObject, "dataTransacao")) {
                    SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
                    try {
                        Date dataTransacao = df.parse(jsonObject.get("dataTransacao").getAsString());
                        entrada.setDataReferencia(dataTransacao);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return entrada;
        }

        private boolean isNotNull(JsonObject jsonObject, String parametro) {
            return jsonObject.has(parametro) && !"".equals(jsonObject.get(parametro).getAsString());
        }
    }

    class SaidaTypeAdapter
    implements JsonSerializer {
        public EntradaCTFClient entrada;

        public SaidaTypeAdapter(EntradaCTFClient entradaCTFClient) {
            this.entrada = entradaCTFClient;
        }

        public JsonElement serialize(Object obj, Type typeOfSrc, JsonSerializationContext context) {
            SaidaCTFClient saida = (SaidaCTFClient)obj;
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("operacao", (Number)new Integer(this.entrada.getOperacao()));
            jsonObject.addProperty("retorno", (Number)new Integer(saida.getCodigoRetorno()));
            jsonObject.addProperty("codigoErro", saida.getCodigoErro());
            String[] display = saida.getMensagemCTF();
            if (display != null && display.length > 0) {
                JsonArray jsonArray = new JsonArray();
                int i = 0;
                while (i < display.length) {
                    JsonObject jsonMsg = new JsonObject();
                    jsonMsg.addProperty("mensagem", display[i]);
                    jsonArray.add((JsonElement)jsonMsg);
                    ++i;
                }
                jsonObject.add("display", (JsonElement)jsonArray);
            }
            if (!this.isNull(saida.getCodigoRespAutorizadora())) {
                jsonObject.addProperty("codigoRespAutorizadora", saida.getCodigoAutorizadora());
            }
            if (!this.isNull(saida.getCodigoAprovacao())) {
                jsonObject.addProperty("codigoAprovacao", saida.getCodigoAprovacao());
            }
            if (saida.getValorTransacao() != null && saida.getValorTransacao().doubleValue() > 0.0) {
                jsonObject.addProperty("valorTransacao", "" + saida.getValorTransacao().movePointRight(2));
            }
            if (saida.getNsuCTF() > 0) {
                jsonObject.addProperty("nsuCTF", (Number)new Integer(saida.getNsuCTF()));
            }
            if (saida.getNsuAutorizadora() > 0L) {
                jsonObject.addProperty("nsuAutorizadora", (Number)new Long(saida.getNsuAutorizadora()));
            }
            if (!this.isNull(saida.getNomeBandeiraProduto())) {
                jsonObject.addProperty("bandeira", saida.getNomeBandeiraProduto());
            }
            if (!this.isNull(saida.getNomeRedeAdquirente())) {
                jsonObject.addProperty("redeAdquirente", saida.getNomeRedeAdquirente());
            }
            if (!this.isNull(saida.getNumeroCartao())) {
                jsonObject.addProperty("cartao", saida.getNumeroCartao());
            }
            if (saida.getCodigoRetorno() == 0 && this.entrada.getOperacao() != 6 && this.entrada.getOperacao() != 7 && this.entrada.getOperacao() != 191) {
                JsonArray cupomReduzido;
                JsonArray cupomCliente;
                JsonArray cupomEstab = CupomUtil.getCupom("CUPOMCTF.2", this.entrada);
                if (cupomEstab != null) {
                    jsonObject.add("cupomEstabelecimento", (JsonElement)cupomEstab);
                }
                if ((cupomCliente = CupomUtil.getCupom("CUPOMCTF.1", this.entrada)) != null) {
                    jsonObject.add("cupomCliente", (JsonElement)cupomCliente);
                }
                if ((cupomReduzido = CupomUtil.getCupom("REDUZIDO.1", this.entrada)) != null) {
                    jsonObject.add("cupomReduzido", (JsonElement)cupomReduzido);
                }
            }
            return jsonObject;
        }

        private boolean isNull(String valor) {
            return valor == null || "".equals(valor) || valor.trim().length() == 0;
        }
    }

    class WebSocketServer
    extends org.java_websocket.server.WebSocketServer {
        public WebSocketServer(int port, Draft d) throws UnknownHostException {
            super(new InetSocketAddress(port), Collections.singletonList(d));
        }

        public WebSocketServer(InetSocketAddress address, Draft d) {
            super(address, Collections.singletonList(d));
        }

        public void onClose(WebSocket webSocket, int code, String reason, boolean remote) {
        }

        public void onError(WebSocket webSocket, Exception ex) {
        }

        public void onMessage(WebSocket webSocket, String message) {
            try {
                WebSocketHandler.this.logger.debug((Object)("request: " + message));
                GsonBuilder gsonBuilder = new GsonBuilder();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.csi.ctfclient.servicos.EntradaCTFClient");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                gsonBuilder.registerTypeAdapter(clazz, (Object)new EntradaTypeAdapter());
                Gson gson = gsonBuilder.create();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("com.csi.ctfclient.servicos.EntradaCTFClient");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                EntradaCTFClient entrada = (EntradaCTFClient)gson.fromJson(message, (Class)clazz2);
                entrada.setDataAbertura(new Date());
                if (entrada.getNumeroTransacao() == 0) {
                    entrada.setNumeroTransacao(1);
                }
                ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
                IdentTerminal identTerminal = new IdentTerminal();
                identTerminal.setEstabelecimento(confCTFClient.getEstabelecimento());
                identTerminal.setLoja(confCTFClient.getLoja());
                identTerminal.setTerminal(confCTFClient.getTerminal());
                SaidaCTFClient saida = CTFClient.getInstancia().efetuarTransacao(identTerminal, entrada);
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$1 = Class.forName("com.csi.ctfclient.servicos.SaidaCTFClient");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                gsonBuilder.registerTypeAdapter(clazz3, (Object)new SaidaTypeAdapter(entrada));
                gson = gsonBuilder.create();
                String resp = gson.toJson((Object)saida);
                WebSocketHandler.this.logger.debug((Object)("respose: " + resp));
                if (webSocket != null) {
                    webSocket.send(resp);
                    webSocket.close();
                }
            }
            catch (Exception e) {
                WebSocketHandler.this.logger.error((Object)"nao foi possivel processar a requisicao.", (Throwable)e);
            }
        }

        public void onOpen(WebSocket webSocket, ClientHandshake handshake) {
            Iterator iterator = handshake.iterateHttpFields();
            while (iterator.hasNext()) {
                String obj = (String)iterator.next();
                WebSocketHandler.this.logger.debug((Object)(String.valueOf(obj) + " : " + handshake.getFieldValue(obj)));
            }
        }
    }
}

