/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.autenticacao.AutenticacaoUtil;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoParametroInvalido;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IAutenticacao;
import com.csi.ctfclient.tools.communication.Host;
import com.csi.ctfclient.tools.communication.ServicoCTF;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.ByteUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicAutenticacaoJava1_4Compatible {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    public static final String ERROR_AC = "ERROR_AC";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String processaResposta(IAutenticacao dados, String cnpj, Map parameters) throws Exception {
        CloseableHttpClient client = HttpClients.createDefault();
        try {
            String url = "https://autenticador.auttar.com.br/resources/registro";
            HttpPost httpPost = new HttpPost(url);
            ArrayList<BasicNameValuePair> pList = new ArrayList<BasicNameValuePair>();
            Set keys = parameters.keySet();
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                pList.add(new BasicNameValuePair(key, (String)parameters.get(key)));
            }
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(pList);
            httpPost.setEntity((HttpEntity)formEntity);
            System.out.println("Executing request " + httpPost.getRequestLine());
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            try {
                System.out.println("----------------------------------------");
                System.out.println(response.getStatusLine());
                if (response.getStatusLine().getStatusCode() == 200) {
                    HttpEntity entity = response.getEntity();
                    String string = this.processaResposta(dados, EntityUtils.toString((HttpEntity)entity), cnpj);
                    return string;
                }
            }
            finally {
                response.close();
            }
            {
            }
        }
        finally {
            client.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String processaResposta(IAutenticacao dados, String resposta, String cnpj) throws Exception {
        block28: {
            InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
            ControladorPerifericos perifericos = dados.getPerifericos();
            ControladorConfCTFClient controladorConfCTFClient = ControladorConfCTFClient.getInstance();
            ConfCTFClient confCTFClient = new ConfCTFClient();
            AutenticacaoUtil autenticacaoUtil = AutenticacaoUtil.getInstance();
            autenticacaoUtil.clean();
            JsonObject jsonObject = null;
            try {
                jsonObject = new JsonParser().parse(resposta).getAsJsonObject();
            }
            catch (JsonParseException e) {
                LayoutDisplay layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE")));
                layoutDisplay.addLinha(new Linha("ERRO NO PROCESSAMENTO", 0, 1));
                perifericos.confirmaDado(layoutDisplay);
                return "RERUN";
            }
            String certificado = null;
            String certificadoMD5 = null;
            String md5 = null;
            String token = null;
            try {
                int retorno = jsonObject.get("retorno").getAsInt();
                String mensagem = jsonObject.get("mensagem").getAsString();
                if (jsonObject.has("token")) {
                    token = jsonObject.get("token").getAsString();
                }
                if (retorno != 0) {
                    this.logger.error((Object)("erro: " + mensagem));
                    LayoutDisplay layoutDisplay = new LayoutDisplay();
                    layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE")));
                    layoutDisplay.addLinha(new Linha(mensagem.toUpperCase(), 0, 1));
                    perifericos.confirmaDado(layoutDisplay);
                    return "RERUN";
                }
                confCTFClient.setCnpj(cnpj);
                String terminal = jsonObject.get("codigoterminal").getAsString();
                confCTFClient.setEstabelecimento(terminal.substring(0, 5));
                confCTFClient.setLoja(terminal.substring(5, 9));
                confCTFClient.setTerminal(terminal.substring(9));
                JsonArray parametros = jsonObject.getAsJsonObject("parametros").getAsJsonArray("parametro");
                if (parametros == null || parametros.size() <= 0) break block28;
                int i = 0;
                while (true) {
                    if (i >= parametros.size()) {
                        if (certificado == null || certificadoMD5 == null || !certificadoMD5.equalsIgnoreCase(md5)) break;
                        try {
                            String nomeCertificado = "ca-bundle.crt";
                            FileOutputStream fos = new FileOutputStream(new File(nomeCertificado));
                            fos.write(certificado.getBytes());
                            fos.flush();
                            fos.close();
                            break;
                        }
                        catch (Exception e) {
                            this.logger.error((Object)"erro: ", (Throwable)e);
                            LayoutDisplay layoutDisplay = new LayoutDisplay();
                            layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE"), 0, 1));
                            layoutDisplay.addLinha(new Linha("ERRO AO GRAVAR CERTIFICADO."));
                            perifericos.confirmaDado(layoutDisplay);
                            return "RERUN";
                        }
                    }
                    JsonObject parametro = parametros.get(i).getAsJsonObject();
                    if (parametro.get("id").getAsString().equalsIgnoreCase("hostctf")) {
                        String[] hostsArray = parametro.get("valor").getAsString().split(";");
                        if (hostsArray.length > 0) {
                            LinkedHashSet<ServicoCTF> ips = new LinkedHashSet<ServicoCTF>();
                            int y = 0;
                            while (true) {
                                if (y >= hostsArray.length) {
                                    confCTFClient.setIps(ips);
                                    break;
                                }
                                String strHost = "";
                                if (hostsArray[y].toLowerCase().contains("http")) {
                                    ServicoCTF servico;
                                    strHost = hostsArray[y];
                                    Host hostCTF = new Host(strHost);
                                    try {
                                        servico = new ServicoCTF(hostCTF, "443", "HTTPS");
                                    }
                                    catch (ExcecaoParametroInvalido e) {
                                        this.logger.log((Priority)Level.ERROR, (Object)"valor de parametro invalido ==> ips = protocolo, usar TCP, UDP ou UDP2, HTTPS");
                                        return ERROR;
                                    }
                                    ips.add(servico);
                                }
                                ++y;
                            }
                        }
                    } else if (parametro.get("id").getAsString().equalsIgnoreCase("ambiente")) {
                        parametro.get("valor").getAsString();
                    } else if (parametro.get("id").getAsString().equalsIgnoreCase("certificado-md5")) {
                        md5 = parametro.get("valor").getAsString();
                    } else if (parametro.get("id").getAsString().equalsIgnoreCase("certificado")) {
                        try {
                            certificado = parametro.get("valor").getAsString();
                            byte[] buffer = certificado.getBytes();
                            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                            messageDigest.reset();
                            messageDigest.update(buffer);
                            byte[] resultByte = messageDigest.digest();
                            certificadoMD5 = ByteUtil.byteArrayToHex((byte[])resultByte);
                        }
                        catch (Exception e) {
                            this.logger.error((Object)"erro: ", (Throwable)e);
                            LayoutDisplay layoutDisplay = new LayoutDisplay();
                            layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE")));
                            layoutDisplay.addLinha(new Linha("CERTIFICADO INVALIDO", 0, 1));
                            perifericos.confirmaDado(layoutDisplay);
                            return "RERUN";
                        }
                    }
                    ++i;
                }
                if (token != null) {
                    autenticacaoUtil.configTokenAutorizacao(token);
                    try {
                        controladorConfCTFClient.save(confCTFClient, true);
                    }
                    catch (ExcecaoApiAc e) {
                        autenticacaoUtil.clean();
                    }
                }
                LayoutDisplay layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha(mensagem.toUpperCase()));
                perifericos.confirmaDado(layoutDisplay);
                return SUCCESS;
            }
            catch (Exception e) {
                this.logger.error((Object)"erro", (Throwable)e);
            }
        }
        return ERROR;
    }

    public static void main(String[] args) {
        URIBuilder builder = new URIBuilder();
        builder.setHost("homologacao.auttar.com.br/marcos");
        builder.setScheme("https");
        builder.addParameter("tess", "fdss");
        System.out.println(builder.toString());
    }
}

